/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.compress;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class StorageBlockCraftingRecipeAssimilator {
    public static String[] problemMods = new String[]{"BiblioWoodsForestry"};

    public List<IRecipe> getPackingRecipes() {
        LinkedList<PackingRecipe> packingRecipes = new LinkedList<PackingRecipe>();
        ArrayList<IRecipe> unpackingRecipes = new ArrayList<IRecipe>();
        for (IRecipe recipe : this.getCraftingRecipes()) {
            ItemStack output = recipe.func_77571_b();
            if (output == null || output.func_77973_b() == null) continue;
            if (output.field_77994_a == 1) {
                PackingRecipe packingRecipe = this.getPackingRecipe(recipe);
                if (packingRecipe == null) continue;
                packingRecipes.add(packingRecipe);
                continue;
            }
            if (output.field_77994_a != 4 && output.field_77994_a != 9 || recipe.func_77570_a() != 1) continue;
            unpackingRecipes.add(recipe);
        }
        Container container = this.makeDummyContainer();
        InventoryCrafting inventoryUnpack = new InventoryCrafting(container, 2, 2);
        InventoryCrafting inventory2x2 = new InventoryCrafting(container, 2, 2);
        InventoryCrafting inventory3x3 = new InventoryCrafting(container, 3, 3);
        World world = null;
        ArrayList<IRecipe> ret = new ArrayList<IRecipe>();
        for (IRecipe recipeUnpack : unpackingRecipes) {
            ItemStack unpacked = recipeUnpack.func_77571_b();
            InventoryCrafting inventory = null;
            Iterator it = packingRecipes.iterator();
            while (it.hasNext()) {
                PackingRecipe recipePack = (PackingRecipe)it.next();
                boolean matched = false;
                if (recipePack.possibleInputs != null) {
                    if (recipePack.inputCount != unpacked.field_77994_a) continue;
                    for (ItemStack stack : recipePack.possibleInputs) {
                        if (!this.areInputsIdentical(unpacked, stack)) continue;
                        matched = true;
                        break;
                    }
                } else {
                    if (unpacked.field_77994_a == 9 && recipePack.recipe.func_77570_a() < 9) continue;
                    if (inventory == null) {
                        inventory = unpacked.field_77994_a == 4 ? inventory2x2 : inventory3x3;
                        for (int i = 0; i < unpacked.field_77994_a; ++i) {
                            inventory.func_70299_a(i, unpacked.func_77946_l());
                        }
                    }
                    matched = recipePack.recipe.func_77569_a(inventory, world);
                }
                if (!matched) continue;
                ItemStack packOutput = recipePack.recipe.func_77571_b();
                inventoryUnpack.func_70299_a(0, packOutput.func_77946_l());
                if (!recipeUnpack.func_77569_a(inventoryUnpack, world)) continue;
                ret.add(recipePack.recipe);
                AlchemicalWizardry.logger.info("Adding the following recipe to the Compression Handler: " + packOutput);
                it.remove();
            }
        }
        return ret;
    }

    private List<IRecipe> getCraftingRecipes() {
        return CraftingManager.func_77594_a().func_77592_b();
    }

    private Container makeDummyContainer() {
        return new Container(){

            public boolean func_75145_c(EntityPlayer p_75145_1_) {
                return true;
            }
        };
    }

    private PackingRecipe getPackingRecipe(IRecipe recipe) {
        ArrayList inputs;
        if (recipe.func_77570_a() < 4) {
            return null;
        }
        if (recipe instanceof ShapedRecipes) {
            inputs = Arrays.asList(((ShapedRecipes)recipe).field_77574_d);
        } else if (recipe instanceof ShapelessRecipes) {
            inputs = ((ShapelessRecipes)recipe).field_77579_b;
        } else if (recipe instanceof ShapedOreRecipe) {
            inputs = Arrays.asList(((ShapedOreRecipe)recipe).getInput());
        } else if (recipe instanceof ShapelessOreRecipe) {
            inputs = ((ShapelessOreRecipe)recipe).getInput();
        } else {
            return new PackingRecipe(recipe, null, -1);
        }
        int count = 0;
        for (Object o : inputs) {
            if (o == null) continue;
            ++count;
        }
        if (count != 4 && count != 9) {
            return null;
        }
        List<ItemStack> identicalInputs = this.getIdenticalInputs(inputs);
        if (identicalInputs == null) {
            return null;
        }
        return new PackingRecipe(recipe, identicalInputs, count);
    }

    private List<ItemStack> getIdenticalInputs(List<?> inputs) {
        ArrayList<ItemStack> options = null;
        for (Object input : inputs) {
            List<ItemStack> offers;
            if (input == null) continue;
            if (input instanceof ItemStack) {
                offers = Arrays.asList((ItemStack)input);
            } else if (input instanceof List) {
                offers = (List<ItemStack>)input;
                if (offers.isEmpty()) {
                    return null;
                }
            } else {
                throw new RuntimeException("invalid input: " + input.getClass());
            }
            if (options == null) {
                options = new ArrayList<ItemStack>(offers);
                continue;
            }
            Iterator it = options.iterator();
            while (it.hasNext()) {
                ItemStack stackReq = (ItemStack)it.next();
                boolean found = false;
                for (ItemStack stackCmp : offers) {
                    if (!this.areInputsIdentical(stackReq, stackCmp)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                it.remove();
                if (!options.isEmpty()) continue;
                return null;
            }
        }
        return options;
    }

    private boolean areInputsIdentical(ItemStack a, ItemStack b) {
        try {
            int dmgB;
            if (a.func_77973_b() != b.func_77973_b()) {
                return false;
            }
            int dmgA = a.func_77960_j();
            return dmgA == (dmgB = b.func_77960_j()) || dmgA == Short.MAX_VALUE || dmgB == Short.MAX_VALUE;
        }
        catch (NullPointerException e) {
            AlchemicalWizardry.logger.error("A mod in this instance has registered an item with a null input. Known problem mods are:");
            String err = "";
            for (String problem : problemMods) {
                err = err + (err.length() > 0 ? ", " : "") + problem;
            }
            AlchemicalWizardry.logger.error(err);
            return false;
        }
    }

    private static class PackingRecipe {
        final IRecipe recipe;
        final List<ItemStack> possibleInputs;
        final int inputCount;

        PackingRecipe(IRecipe recipe, List<ItemStack> possibleInputs, int inputCount) {
            this.recipe = recipe;
            this.possibleInputs = possibleInputs;
            this.inputCount = inputCount;
        }
    }
}

