/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.thaumcraft.util;

import com.github.bartimaeusnek.bartworks.API.API_ConfigValues;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.bartworks.util.log.DebugLog;
import gregtech.api.enums.TC_Aspects;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;

public class ThaumcraftHandler {
    private static Integer taintBiomeID;
    private static Integer magicalForestBiomeID;
    private static Class mWandInterface;

    private ThaumcraftHandler() {
    }

    public static boolean isWand(ItemStack aStack) {
        try {
            return aStack != null && mWandInterface.isAssignableFrom(aStack.func_77973_b().getClass());
        }
        catch (Throwable var3) {
            return false;
        }
    }

    public static boolean isMagicalForestBiome(int biomeID) {
        if (magicalForestBiomeID == null) {
            try {
                BiomeGenBase biome = (BiomeGenBase)Class.forName("thaumcraft.common.lib.world.ThaumcraftWorldGenerator").getField("biomeMagicalForest").get(null);
                magicalForestBiomeID = biome.field_76756_M;
                return biomeID == magicalForestBiomeID;
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                return false;
            }
        }
        return biomeID == magicalForestBiomeID;
    }

    public static boolean isTaintBiome(int biomeID) {
        if (taintBiomeID == null) {
            try {
                BiomeGenBase TaintBiome = (BiomeGenBase)Class.forName("thaumcraft.common.lib.world.ThaumcraftWorldGenerator").getField("biomeTaint").get(null);
                taintBiomeID = TaintBiome.field_76756_M;
                return biomeID == taintBiomeID;
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                return false;
            }
        }
        return biomeID == taintBiomeID;
    }

    static {
        try {
            mWandInterface = Class.forName("thaumcraft.common.items.wands.ItemWandCasting");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static class AspectAdder {
        public static Class mAspectListClass;
        public static Class mAspectClass;
        public static Method registerObjectTag;
        public static Method addToList;
        public static Method getName;
        public static Method writeAspectListToNBT;
        public static Method readAspectListFromNBT;
        public static Method add;
        public static Method getAmount;
        public static Method getAspects;
        public static Method isResearchComplete;
        public static Field linkedAspektList;

        public static void addAspectViaBW(ItemStack stack, Pair<Object, Integer> ... aspectPair) {
            if (stack == null || stack.func_77973_b() == null || stack.func_77977_a() == null) {
                return;
            }
            try {
                Object aspectList = mAspectListClass.newInstance();
                for (Pair<Object, Integer> a : aspectPair) {
                    if (API_ConfigValues.debugLog) {
                        DebugLog.log("Stack:" + stack.func_82833_r() + " Damage:" + stack.func_77960_j() + " aspectPair: " + getName.invoke(a.getKey(), new Object[0]) + " / " + a.getValue());
                    }
                    addToList.invoke(aspectList, a.getKey(), a.getValue());
                }
                registerObjectTag.invoke(null, stack, aspectList);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        public static void addAspectViaGT(ItemStack stack, TC_Aspects.TC_AspectStack ... tc_aspectStacks) {
            try {
                Object aspectList = mAspectListClass.newInstance();
                for (TC_Aspects.TC_AspectStack tc_aspects : tc_aspectStacks) {
                    addToList.invoke(aspectList, tc_aspects.mAspect.mAspect, (int)tc_aspects.mAmount);
                }
                registerObjectTag.invoke(null, stack, aspectList);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        static {
            try {
                mAspectListClass = Class.forName("thaumcraft.api.aspects.AspectList");
                mAspectClass = Class.forName("thaumcraft.api.aspects.Aspect");
                addToList = mAspectListClass.getMethod("add", mAspectClass, Integer.TYPE);
                registerObjectTag = Class.forName("thaumcraft.api.ThaumcraftApi").getMethod("registerObjectTag", ItemStack.class, mAspectListClass);
                getName = mAspectClass.getMethod("getName", new Class[0]);
                writeAspectListToNBT = mAspectListClass.getMethod("writeToNBT", NBTTagCompound.class);
                add = mAspectListClass.getMethod("add", mAspectListClass);
                getAmount = mAspectListClass.getMethod("getAmount", mAspectClass);
                getAspects = mAspectListClass.getMethod("getAspects", new Class[0]);
                readAspectListFromNBT = mAspectListClass.getMethod("readFromNBT", NBTTagCompound.class);
                isResearchComplete = Class.forName("thaumcraft.common.lib.research.ResearchManager").getMethod("isResearchComplete", String.class, String.class);
                linkedAspektList = mAspectListClass.getField("aspects");
            }
            catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }
}

