/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration;

import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.CircuitData;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.CircuitImprintLoader;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;

public class BW_Meta_Items {
    private static final BW_GT_MetaGenCircuits NEWCIRCUITS = new BW_GT_MetaGenCircuits();

    public static BW_GT_MetaGenCircuits getNEWCIRCUITS() {
        return NEWCIRCUITS;
    }

    public void addNewCircuit(int aTier, int aID, String aName) {
        String additionalOreDictData = "";
        String tooltip = "";
        String aOreDictPrefix = OrePrefixes.circuit.toString();
        switch (aTier) {
            case 0: {
                additionalOreDictData = Materials.Primitive.toString();
                tooltip = Materials.Primitive.getToolTip();
                break;
            }
            case 1: {
                additionalOreDictData = Materials.Basic.toString();
                tooltip = Materials.Basic.getToolTip();
                break;
            }
            case 2: {
                additionalOreDictData = Materials.Good.toString();
                tooltip = Materials.Good.getToolTip();
                break;
            }
            case 3: {
                additionalOreDictData = Materials.Advanced.toString();
                tooltip = Materials.Advanced.getToolTip();
                break;
            }
            case 4: {
                additionalOreDictData = Materials.Data.toString();
                tooltip = Materials.Data.getToolTip();
                break;
            }
            case 5: {
                additionalOreDictData = Materials.Elite.toString();
                tooltip = Materials.Elite.getToolTip();
                break;
            }
            case 6: {
                additionalOreDictData = Materials.Master.toString();
                tooltip = Materials.Master.getToolTip();
                break;
            }
            case 7: {
                additionalOreDictData = Materials.Ultimate.toString();
                tooltip = Materials.Ultimate.getToolTip();
                break;
            }
            case 8: {
                additionalOreDictData = Materials.SuperconductorUHV.toString();
                tooltip = Materials.SuperconductorUHV.getToolTip();
                break;
            }
            case 9: {
                additionalOreDictData = "Infinite";
                tooltip = "An Infinite Circuit";
                break;
            }
            case 10: {
                additionalOreDictData = "Bio";
                tooltip = "A Bio Circuit";
            }
        }
        ItemStack tStack = NEWCIRCUITS.addCircuit(aID, aName, tooltip, aTier);
        GT_OreDictUnificator.registerOre((Object)(aOreDictPrefix + additionalOreDictData).replaceAll(" ", ""), (ItemStack)tStack);
    }

    static {
        NEWCIRCUITS.addItem(0, "Circuit Imprint", "", SubTag.NO_UNIFICATION, SubTag.NO_RECYCLING);
        NEWCIRCUITS.addItem(1, "Sliced Circuit", "", SubTag.NO_UNIFICATION, SubTag.NO_RECYCLING);
        NEWCIRCUITS.addItem(2, "Raw Imprint supporting Board", "A Raw Board needed for Circuit Imprints", new Object[0]);
        NEWCIRCUITS.addItem(3, "Imprint supporting Board", "A Board needed for Circuit Imprints", new Object[0]);
        GT_Values.RA.addFormingPressRecipe(WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.dust, 1), WerkstoffLoader.ArInGaPhoBiBoTe.get(OrePrefixes.dust, 4), NEWCIRCUITS.getStack(2), 300, 480);
        GT_Recipe.GT_Recipe_Map.sAutoclaveRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(false, new ItemStack[]{NEWCIRCUITS.getStack(2)}, new ItemStack[]{NEWCIRCUITS.getStack(3)}, null, new int[]{7500}, new FluidStack[]{Materials.SolderingAlloy.getMolten(576L)}, null, 300, BW_Util.getMachineVoltageFromTier(4), -200));
    }

    public static class BW_GT_MetaGen_Item_Hook
    extends GT_MetaBase_Item {
        public static final HashSet<BW_GT_MetaGen_Item_Hook> sInstances = new HashSet();
        public final IIcon[] mIconList = new IIcon[65534];
        public final BitSet mEnabledItems = new BitSet(Short.MAX_VALUE);

        private BW_GT_MetaGen_Item_Hook(String aUnlocalized) {
            super(aUnlocalized);
            this.func_77637_a(new CreativeTabs("bw.MetaItems.0"){

                public Item func_78016_d() {
                    return ItemRegistry.TAB;
                }
            });
            this.func_77627_a(true);
            this.func_77656_e(0);
            sInstances.add(this);
        }

        public Long[] getElectricStats(ItemStack itemStack) {
            return null;
        }

        public Long[] getFluidContainerStats(ItemStack itemStack) {
            return null;
        }

        public final ItemStack addItem(int aID, String aEnglish, String aToolTip, Object ... aRandomData) {
            Object tRandomData;
            int var9;
            if (aToolTip == null) {
                aToolTip = "";
            }
            ItemStack rStack = new ItemStack((Item)this, 1, aID);
            GT_LanguageManager.addStringLocalization((String)(this.func_77667_c(rStack) + ".name"), (String)aEnglish);
            GT_LanguageManager.addStringLocalization((String)(this.func_77667_c(rStack) + ".tooltip"), (String)aToolTip);
            ArrayList tAspects = new ArrayList();
            this.mEnabledItems.set(aID);
            Object[] var7 = aRandomData;
            int var8 = aRandomData.length;
            for (var9 = 0; var9 < var8; ++var9) {
                tRandomData = var7[var9];
                if (!(tRandomData instanceof SubTag) || tRandomData != SubTag.NO_UNIFICATION) continue;
                GT_OreDictUnificator.addToBlacklist((ItemStack)rStack);
            }
            var7 = aRandomData;
            var8 = aRandomData.length;
            for (var9 = 0; var9 < var8; ++var9) {
                tRandomData = var7[var9];
                if (tRandomData == null) continue;
                boolean tUseOreDict = true;
                if (tRandomData instanceof IItemBehaviour) {
                    this.addItemBehavior(aID, (IItemBehaviour)tRandomData);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IItemContainer) {
                    ((IItemContainer)tRandomData).set(rStack);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof SubTag) continue;
                if (tRandomData instanceof TC_Aspects.TC_AspectStack) {
                    ((TC_Aspects.TC_AspectStack)tRandomData).addToAspectList(tAspects);
                    continue;
                }
                if (tRandomData instanceof ItemData) {
                    if (GT_Utility.isStringValid((Object)tRandomData)) {
                        GT_OreDictUnificator.registerOre((Object)tRandomData, (ItemStack)rStack);
                        continue;
                    }
                    GT_OreDictUnificator.addItemData((ItemStack)rStack, (ItemData)((ItemData)tRandomData));
                    continue;
                }
                if (!tUseOreDict) continue;
                GT_OreDictUnificator.registerOre((Object)tRandomData, (ItemStack)rStack);
            }
            if (GregTech_API.sThaumcraftCompat != null) {
                GregTech_API.sThaumcraftCompat.registerThaumcraftAspectsToItem(rStack, tAspects, false);
            }
            return rStack;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
            int j = this.mEnabledItems.length();
            for (int i = 0; i < j; ++i) {
                if (!this.mEnabledItems.get(i)) continue;
                ItemStack tStack = new ItemStack((Item)this, 1, i);
                this.isItemStackUsable(tStack);
                aList.add(tStack);
            }
        }

        protected void addAdditionalToolTips(List aList, ItemStack aStack, EntityPlayer aPlayer) {
            super.addAdditionalToolTips(aList, aStack, aPlayer);
            aList.add(BW_Tooltip_Reference.ADDED_BY_BARTWORKS.get());
        }

        public String func_77667_c(ItemStack aStack) {
            return this.func_77658_a() + "." + aStack.func_77960_j();
        }

        public IIcon func_77617_a(int i) {
            if (this.mEnabledItems.get(i)) {
                return (IIcon)BW_Util.get2DCoordFrom1DArray(i, 0, 2, this.mIconList);
            }
            return null;
        }

        public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
            return this.func_77617_a(stack.func_77960_j());
        }

        public IIcon getIcon(ItemStack stack, int pass) {
            return this.func_77617_a(stack.func_77960_j());
        }
    }

    public static class BW_GT_MetaGenCircuits
    extends BW_GT_MetaGen_Item_Hook {
        public BW_GT_MetaGenCircuits() {
            super("bwMetaGeneratedItem0");
        }

        public final ItemStack addCircuit(int aID, String aEnglish, String aToolTip, int tier) {
            CircuitImprintLoader.bwCircuitTagMap.put((Object)new CircuitData(BW_Util.getMachineVoltageFromTier(Math.min(1, tier - 2)), tier > 2 ? -200 : 0, (byte)tier), (Object)new ItemStack((Item)NEWCIRCUITS, 1, aID));
            return this.addItem(aID, aEnglish, aToolTip, SubTag.NO_UNIFICATION);
        }

        public final ItemStack getStack(int ... meta_amount) {
            ItemStack ret = new ItemStack((Item)this);
            if (meta_amount.length <= 0 || meta_amount.length > 2) {
                return ret;
            }
            if (meta_amount.length == 1) {
                ret.func_77964_b(meta_amount[0]);
                return ret;
            }
            ret.func_77964_b(meta_amount[0]);
            ret.field_77994_a = meta_amount[1];
            return ret;
        }

        public final ItemStack getStackWithNBT(NBTTagCompound tag, int ... meta_amount) {
            ItemStack ret = this.getStack(meta_amount);
            ret.func_77982_d(tag);
            return ret;
        }

        @Override
        public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
            if (aCreativeTab == this.func_77640_w()) {
                for (NBTTagCompound tag : CircuitImprintLoader.recipeTagMap.keySet()) {
                    ItemStack stack = new ItemStack((Item)NEWCIRCUITS, 1, 0);
                    stack.func_77982_d(tag);
                    aList.add(stack);
                }
            }
            super.func_150895_a(var1, aCreativeTab, aList);
        }

        @SideOnly(value=Side.CLIENT)
        public final void func_94581_a(IIconRegister aIconRegister) {
            short i;
            for (i = 0; i < CircuitImprintLoader.reverseIDs; i = (short)(i + 1)) {
                if (!this.mEnabledItems.get(i)) continue;
                BW_Util.set2DCoordTo1DArray(i, 0, 2, aIconRegister.func_94245_a("gregtech:" + (GT_Config.troll ? "troll" : this.func_77658_a() + "/" + i)), this.mIconList);
            }
            for (i = CircuitImprintLoader.reverseIDs; i < Short.MAX_VALUE; i = (short)(i + 1)) {
                if (!this.mEnabledItems.get(i)) continue;
                BW_Util.set2DCoordTo1DArray(i, 0, 2, ((ItemList)Objects.requireNonNull(CircuitImprintLoader.circuitIIconRefs.get((Object)i))).get(1L, new Object[0]).func_77954_c(), this.mIconList);
                BW_Util.set2DCoordTo1DArray(i, 1, 2, aIconRegister.func_94245_a("bartworks:WrapOverlay"), this.mIconList);
            }
        }

        @Override
        protected void addAdditionalToolTips(List aList, ItemStack aStack, EntityPlayer aPlayer) {
            if (aStack.func_77960_j() == 0) {
                if (aStack.func_77978_p() != null && CircuitImprintLoader.getStackFromTag(aStack.func_77978_p()) != null) {
                    aList.add("An Imprint for: " + GT_LanguageManager.getTranslation((String)GT_LanguageManager.getTranslateableItemStackName((ItemStack)CircuitImprintLoader.getStackFromTag(aStack.func_77978_p()))));
                } else {
                    aList.add("An Imprint for a Circuit");
                }
            } else if (aStack.func_77960_j() == 1) {
                if (aStack.func_77978_p() != null && CircuitImprintLoader.getStackFromTag(aStack.func_77978_p()) != null) {
                    aList.add("A Sliced " + GT_LanguageManager.getTranslation((String)GT_LanguageManager.getTranslateableItemStackName((ItemStack)CircuitImprintLoader.getStackFromTag(aStack.func_77978_p()))));
                } else {
                    aList.add("A Sliced Circuit");
                }
            }
            super.addAdditionalToolTips(aList, aStack, aPlayer);
        }
    }
}

