/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.tiered;

import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicHull;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Diode
extends GT_MetaTileEntity_BasicHull {
    private long maxAmps;
    private long aAmps;

    public GT_MetaTileEntity_Diode(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, StatCollector.func_74838_a((String)"tooltip.tile.diode.0.name"), new ITexture[0]);
        this.aAmps = this.maxAmps = this.getAmpsfromMeta(aID);
    }

    public GT_MetaTileEntity_Diode(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (this.maxAmps == 0L && !this.getBaseMetaTileEntity().getWorld().field_72995_K) {
            this.aAmps = this.maxAmps = this.getAmpsfromMeta(this.getBaseMetaTileEntity().getMetaTileID());
        }
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
        if (this.getBaseMetaTileEntity().getWorld().field_72995_K) {
            return;
        }
        if (!aPlayer.func_70093_af()) {
            --this.aAmps;
            if (this.aAmps < 0L) {
                this.aAmps = this.maxAmps;
            }
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Max Amps: " + this.aAmps));
        } else {
            ++this.aAmps;
            if (this.aAmps > this.maxAmps) {
                this.aAmps = 0L;
            }
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Max Amps: " + this.aAmps));
        }
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("maxAmp", this.maxAmps);
        aNBT.func_74772_a("Amps", this.aAmps);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.maxAmps = aNBT.func_74763_f("maxAmp");
        this.aAmps = aNBT.func_74763_f("Amps");
        super.loadNBTData(aNBT);
    }

    public long maxAmperesOut() {
        return this.aAmps;
    }

    public long maxAmperesIn() {
        return this.aAmps;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Diode(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    private long getAmpsfromMeta(int meta) {
        if (meta > ConfigHandler.IDOffset + GT_Values.VN.length && meta <= ConfigHandler.IDOffset + GT_Values.VN.length * 2) {
            return 2L;
        }
        if (meta > ConfigHandler.IDOffset + GT_Values.VN.length * 2 && meta <= ConfigHandler.IDOffset + GT_Values.VN.length * 3) {
            return 4L;
        }
        if (meta > ConfigHandler.IDOffset + GT_Values.VN.length * 3 && meta <= ConfigHandler.IDOffset + GT_Values.VN.length * 4) {
            return 8L;
        }
        if (meta > ConfigHandler.IDOffset + GT_Values.VN.length * 4 && meta <= ConfigHandler.IDOffset + GT_Values.VN.length * 5) {
            return 12L;
        }
        if (meta > ConfigHandler.IDOffset + GT_Values.VN.length * 5 && meta <= ConfigHandler.IDOffset + GT_Values.VN.length * 6) {
            return 16L;
        }
        return 0L;
    }

    public String[] getDescription() {
        return new String[]{this.mDescription, StatCollector.func_74838_a((String)"tooltip.tile.tiereddsc.0.name") + " " + "\u00a7e" + GT_Utility.formatNumbers((long)GT_Values.V[this.mTier]), StatCollector.func_74838_a((String)"tooltip.tile.tiereddsc.1.name") + " " + "\u00a7e" + GT_Utility.formatNumbers((long)this.maxAmperesIn()), StatCollector.func_74838_a((String)"tooltip.tile.tiereddsc.2.name") + " " + "\u00a7e" + GT_Utility.formatNumbers((long)this.maxAmperesOut()), BW_Tooltip_Reference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get()};
    }
}

