/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.client.block.IBlockAccessFake;
import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.littletiles.client.render.LittleBlockRenderHelper;
import com.creativemd.littletiles.client.render.LittleBlockVertex;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.utils.TileList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class RenderingThread
extends Thread {
    private static final CopyOnWriteArrayList<ChunkCoordinates> updateCoords = new CopyOnWriteArrayList();
    private static final HashMap<ChunkCoordinates, AtomicInteger> chunks = new HashMap();
    private static World lastWorld;
    public static RenderBlocks renderer;
    public static RenderingThread instance;
    public boolean active = true;

    public static ChunkCoordinates getChunkCoords(ChunkCoordinates coord) {
        return new ChunkCoordinates(coord.field_71574_a >> 4, 0, coord.field_71573_c >> 4);
    }

    public static void addCoordToUpdate(World world, ChunkCoordinates coord) {
        if (lastWorld != world) {
            updateCoords.clear();
        }
        lastWorld = world;
        if (!updateCoords.contains(coord)) {
            ChunkCoordinates chunk = RenderingThread.getChunkCoords(coord);
            AtomicInteger count = chunks.get(chunk);
            if (count == null) {
                count = new AtomicInteger(0);
            }
            count.addAndGet(1);
            updateCoords.add(coord);
        }
    }

    public RenderingThread() {
        this.start();
    }

    @Override
    public void run() {
        while (this.active) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && updateCoords.size() > 0) {
                ChunkCoordinates coord = updateCoords.get(0);
                updateCoords.remove(0);
                try {
                    TileEntity tileEntity = world.func_147438_o(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
                    if (tileEntity instanceof TileEntityLittleTiles) {
                        TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
                        ArrayList<LittleBlockVertex> vertexes = new ArrayList<LittleBlockVertex>();
                        TileList<LittleTile> tiles = te.getTiles();
                        for (LittleTile tile : tiles) {
                            if (!(tile instanceof LittleTileBlock) || !tile.canBlockBeThreaded()) continue;
                            ArrayList<CubeObject> cubes = tile.getRenderingCubes();
                            for (CubeObject cube : cubes) {
                                if (cube.block == null || cube.meta == -1) continue;
                                if (LittleBlockRenderHelper.fake == null) {
                                    LittleBlockRenderHelper.fake = new IBlockAccessFake((IBlockAccess)Minecraft.func_71410_x().field_71441_e);
                                    LittleBlockRenderHelper.renderBlocks.field_147845_a = LittleBlockRenderHelper.fake;
                                }
                                if (LittleBlockRenderHelper.fake.world != Minecraft.func_71410_x().field_71441_e) {
                                    LittleBlockRenderHelper.fake.world = Minecraft.func_71410_x().field_71441_e;
                                }
                                LittleBlockRenderHelper.renderBlocks.func_147771_a();
                                LittleBlockRenderHelper.renderBlocks.field_147847_n = false;
                                LittleBlockRenderHelper.renderBlocks.func_147782_a(cube.minX, cube.minY, cube.minZ, cube.maxX, cube.maxY, cube.maxZ);
                                LittleBlockRenderHelper.renderBlocks.meta = cube.meta;
                                LittleBlockRenderHelper.fake.overrideMeta = cube.meta;
                                LittleBlockRenderHelper.renderBlocks.color = cube.color;
                                LittleBlockRenderHelper.renderBlocks.field_147847_n = true;
                                LittleBlockRenderHelper.renderBlocks.blockVertex = new LittleBlockVertex();
                                LittleBlockRenderHelper.renderBlocks.func_147769_a(cube.block, te.field_145851_c, te.field_145848_d, te.field_145849_e);
                                vertexes.add(LittleBlockRenderHelper.renderBlocks.blockVertex);
                                LittleBlockRenderHelper.renderBlocks.field_147847_n = false;
                                LittleBlockRenderHelper.renderBlocks.color = ColorUtils.WHITE;
                            }
                        }
                        this.setLastRenderedTiles(vertexes, te, coord);
                    }
                }
                catch (Exception e) {
                    updateCoords.add(coord);
                }
                try {
                    RenderingThread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (updateCoords.size() != 0) continue;
            chunks.clear();
        }
    }

    public synchronized void setLastRenderedTiles(ArrayList<LittleBlockVertex> vertexes, TileEntityLittleTiles te, ChunkCoordinates coord) {
        while (te.isRendering) {
            try {
                RenderingThread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        te.lastRendered = vertexes;
        ChunkCoordinates chunk = RenderingThread.getChunkCoords(coord);
        AtomicInteger count = chunks.get(chunk);
        if (count != null) {
            count.addAndGet(-1);
        }
        if (count == null || count.intValue() <= 0) {
            chunks.remove(chunk);
            te.needsRenderingUpdate = true;
        }
    }

    static {
        instance = new RenderingThread();
    }
}

