/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import vswe.stevesfactory.blocks.ClusterMethodRegistration;
import vswe.stevesfactory.blocks.ISystemListener;
import vswe.stevesfactory.blocks.ITriggerNode;
import vswe.stevesfactory.blocks.TileEntityClusterElement;
import vswe.stevesfactory.blocks.TileEntityManager;

public class TileEntityBUD
extends TileEntityClusterElement
implements ISystemListener,
ITriggerNode {
    private List<TileEntityManager> managerList = new ArrayList<TileEntityManager>();
    private int[] oldData = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private int[] data = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private static final String NBT_SIDES = "Sides";
    private static final String NBT_DATA = "Data";

    @Override
    public void added(TileEntityManager owner) {
        if (!this.managerList.contains(owner)) {
            this.managerList.add(owner);
        }
    }

    @Override
    public void removed(TileEntityManager owner) {
        this.managerList.remove(owner);
    }

    public void onTrigger() {
        this.updateData();
        for (int i = this.managerList.size() - 1; i >= 0; --i) {
            this.managerList.get(i).triggerBUD(this);
        }
        this.makeOld();
    }

    @Override
    public int[] getData() {
        return this.data;
    }

    @Override
    public int[] getOldData() {
        return this.oldData;
    }

    public void updateData() {
        if (this.field_145850_b != null) {
            this.data = new int[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                ForgeDirection direction = ForgeDirection.VALID_DIRECTIONS[i];
                int x = direction.offsetX + this.field_145851_c;
                int y = direction.offsetY + this.field_145848_d;
                int z = direction.offsetZ + this.field_145849_e;
                this.data[i] = Block.func_149682_b((Block)this.field_145850_b.func_147439_a(x, y, z)) << 4 | this.field_145850_b.func_72805_g(x, y, z) & 0xF;
            }
        }
    }

    public void makeOld() {
        this.oldData = this.data;
    }

    @Override
    public void readContentFromNBT(NBTTagCompound nbtTagCompound) {
        byte version = nbtTagCompound.func_74771_c("ProtocolVersion");
        NBTTagList sidesTag = nbtTagCompound.func_150295_c(NBT_SIDES, 10);
        for (int i = 0; i < sidesTag.func_74745_c(); ++i) {
            NBTTagCompound sideTag = sidesTag.func_150305_b(i);
            short s = sideTag.func_74765_d(NBT_DATA);
            this.data[i] = s;
            this.oldData[i] = s;
        }
    }

    @Override
    public void writeContentToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74774_a("ProtocolVersion", (byte)12);
        NBTTagList sidesTag = new NBTTagList();
        for (int i = 0; i < this.data.length; ++i) {
            NBTTagCompound sideTag = new NBTTagCompound();
            sideTag.func_74777_a(NBT_DATA, (short)this.data[i]);
            sidesTag.func_74742_a((NBTBase)sideTag);
        }
        nbtTagCompound.func_74782_a(NBT_SIDES, (NBTBase)sidesTag);
    }

    @Override
    protected EnumSet<ClusterMethodRegistration> getRegistrations() {
        return EnumSet.of(ClusterMethodRegistration.ON_NEIGHBOR_BLOCK_CHANGED);
    }
}

