/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup;

import aroma1997.backup.Config;
import aroma1997.core.log.LogHelperPre;
import java.io.File;
import java.util.Date;
import org.apache.logging.log4j.Level;

public class BackupInformation
implements Comparable {
    public final int year;
    public final int month;
    public final int day;
    public final int hour;
    public final int minute;
    public final String world;

    public BackupInformation(String world, int year, int month, int day, int hour, int minute) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.world = world;
    }

    public String toString() {
        return this.world + "=" + this.year + "=" + this.month + "=" + this.day + "=" + this.hour + "=" + this.minute;
    }

    public static BackupInformation loadFromString(String str) {
        String[] data = str.split("=");
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        String world = "";
        try {
            world = data[0];
            year = Integer.valueOf(data[1]);
            month = Integer.valueOf(data[2]);
            day = Integer.valueOf(data[3]);
            hour = Integer.valueOf(data[4]);
            minute = Integer.valueOf(data[5]);
        }
        catch (Exception e) {
            LogHelperPre.log((Level)Level.ERROR, (String)"Failed to load Backup Information.");
        }
        return new BackupInformation(world, year, month, day, hour, minute);
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public File getFile() {
        return new File(this.getDir(), "Backup-" + this.world + "-" + this.year + "-" + this.month + "-" + this.day + "--" + this.hour + "-" + this.minute + ".zip");
    }

    public File getDir() {
        return new File(Config.instance.location + "/" + this.world + "/" + this.year + "/" + this.month + "/" + this.day);
    }

    public int compareTo(Object arg0) {
        BackupInformation other = (BackupInformation)arg0;
        return this.getDate().compareTo(other.getDate());
    }

    public Date getDate() {
        return new Date(this.year, this.month - 1, this.day, this.hour, this.minute);
    }
}

