/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.MessageGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiScreen;

public class SelectorGui
extends ExtendedScreen {
    private final String mainTitle;
    private final String attributeName;
    private final String originalValue;
    private final List<String> originalList;
    private final boolean allowContinuing;
    private final boolean allowDynamicEditing;
    private final BiConsumer<String, String> onUpdatedCallback;
    private final ScrollableListControl.RenderType renderType;
    private final BiConsumer<String, GuiScreen> onAdjustDynamicEntry;
    private ExtendedButtonControl proceedButton;
    private ScrollableListControl scrollList;
    private ExtendedTextControl searchBox;
    private String searchTerm;
    private List<String> itemList;
    private ScrollableListControl.IdentifierType identifierType = ScrollableListControl.IdentifierType.None;

    public SelectorGui(GuiScreen parentScreen, String mainTitle, List<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, ScrollableListControl.RenderType renderType, BiConsumer<String, String> onUpdatedCallback, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        super(parentScreen);
        this.originalList = StringUtils.newArrayList(list);
        this.itemList = this.originalList;
        this.originalValue = currentValue;
        this.mainTitle = mainTitle;
        this.attributeName = attributeName;
        this.allowContinuing = allowContinuing;
        this.allowDynamicEditing = allowDynamicEditing;
        this.renderType = renderType;
        this.onUpdatedCallback = onUpdatedCallback;
        this.onAdjustDynamicEntry = onAdjustDynamicEntry;
    }

    public SelectorGui(GuiScreen parentScreen, String mainTitle, Set<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, ScrollableListControl.RenderType renderType, BiConsumer<String, String> onUpdatedCallback, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        this(parentScreen, mainTitle, StringUtils.newArrayList(list), currentValue, attributeName, allowContinuing, allowDynamicEditing, renderType, onUpdatedCallback, onAdjustDynamicEntry);
    }

    public SelectorGui(GuiScreen parentScreen, String mainTitle, List<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, ScrollableListControl.RenderType renderType, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        this(parentScreen, mainTitle, list, currentValue, attributeName, allowContinuing, allowDynamicEditing, renderType, null, onAdjustDynamicEntry);
    }

    public SelectorGui(GuiScreen parentScreen, String mainTitle, Set<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, ScrollableListControl.RenderType renderType, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        this(parentScreen, mainTitle, list, currentValue, attributeName, allowContinuing, allowDynamicEditing, renderType, null, onAdjustDynamicEntry);
    }

    public SelectorGui(GuiScreen parentScreen, String mainTitle, List<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        this(parentScreen, mainTitle, list, currentValue, attributeName, allowContinuing, allowDynamicEditing, ScrollableListControl.RenderType.None, onAdjustDynamicEntry);
    }

    public SelectorGui(GuiScreen parentScreen, String mainTitle, Set<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        this(parentScreen, mainTitle, list, currentValue, attributeName, allowContinuing, allowDynamicEditing, ScrollableListControl.RenderType.None, onAdjustDynamicEntry);
    }

    @Override
    public void initializeUi() {
        if (this.itemList != null && !this.itemList.isEmpty()) {
            this.scrollList = this.addList(new ScrollableListControl(this.getGameInstance(), (ExtendedScreen)this, this.getScreenWidth(), this.getScreenHeight(), 32, this.getScreenHeight() - 32, this.itemList, this.originalValue, this.renderType).setIdentifierType(this.identifierType));
            this.searchBox = this.addControl(new ExtendedTextControl(this.getFontRenderer(), 60, this.getScreenHeight() - 26, 120, 20));
            this.proceedButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 101, this.getScreenHeight() - 26, 95, 20, "gui.config.message.button.back", () -> {
                if (this.allowContinuing && this.scrollList.currentValue != null) {
                    if (this.originalValue != null) {
                        if (!this.scrollList.currentValue.equals(this.originalValue)) {
                            if (this.onUpdatedCallback != null) {
                                this.onUpdatedCallback.accept(this.attributeName, this.scrollList.currentValue);
                                this.openScreen(this.parentScreen);
                            } else {
                                this.openScreen(new MessageGui(this.parentScreen, StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.null", new Object[0]))));
                            }
                        } else {
                            this.openScreen(this.parentScreen);
                        }
                    } else if (this.allowDynamicEditing && this.onAdjustDynamicEntry != null) {
                        this.onAdjustDynamicEntry.accept(this.scrollList.currentValue, this.parentScreen);
                    } else {
                        this.openScreen(new MessageGui(this.parentScreen, StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.null", new Object[0]))));
                    }
                } else {
                    this.openScreen(this.parentScreen);
                }
            }, new String[0]));
            if (this.allowDynamicEditing && this.onAdjustDynamicEntry != null) {
                this.addControl(new ExtendedButtonControl(this.proceedButton.getLeft() - 100, this.getScreenHeight() - 26, 95, 20, "gui.config.message.button.add.new", () -> this.onAdjustDynamicEntry.accept(null, this.parentScreen), new String[0]));
            }
            super.initializeUi();
        } else {
            this.openScreen(new MessageGui(this.parentScreen, StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.empty.list", new Object[0]))));
        }
    }

    @Override
    public void preRender() {
        List<String> originalItems = StringUtils.newArrayList(this.originalList);
        List modifiedList = StringUtils.newArrayList();
        if (!this.searchBox.getControlMessage().isEmpty()) {
            if (!this.searchBox.getControlMessage().equals(this.searchTerm)) {
                this.searchTerm = this.searchBox.getControlMessage();
                block0: for (String item : originalItems) {
                    if (modifiedList.contains(item)) continue;
                    List<String> entriesToCheck = StringUtils.newArrayList(item);
                    if (this.scrollList.entryAliases.containsKey(item)) {
                        entriesToCheck.add(this.scrollList.entryAliases.get(item));
                    }
                    for (String entry : entriesToCheck) {
                        if (!entry.toLowerCase().contains(this.searchTerm.toLowerCase())) continue;
                        modifiedList.add(item);
                        continue block0;
                    }
                }
                this.itemList = modifiedList;
            }
        } else {
            this.itemList = originalItems;
        }
        if (!this.itemList.equals(originalItems) && !this.itemList.contains(this.scrollList.currentValue)) {
            this.scrollList.currentValue = this.originalValue != null && this.itemList.contains(this.originalValue) ? this.originalValue : null;
        } else if (this.scrollList.currentValue == null && this.originalValue != null) {
            this.scrollList.currentValue = this.originalValue;
        }
        this.scrollList.setList(this.itemList);
        this.proceedButton.setControlMessage(this.allowContinuing && this.scrollList.currentValue != null && (this.originalValue != null && !this.scrollList.currentValue.equals(this.originalValue) || StringUtils.isNullOrEmpty(this.originalValue)) ? "gui.config.message.button.continue" : "gui.config.message.button.back");
        super.preRender();
    }

    @Override
    public void renderExtra() {
        String searchText = Constants.TRANSLATOR.translate("gui.config.message.editor.search", new Object[0]);
        float renderY = (float)this.searchBox.getBottom() - (float)this.searchBox.getControlHeight() / 2.0f - (float)this.getFontHeight() / 2.0f;
        String extraText = this.isVerboseMode() ? Constants.TRANSLATOR.translate("gui.config.title.selector.extra", this.itemList.size(), this.originalList.size()) : "";
        String displayText = this.mainTitle + " " + extraText;
        this.renderCenteredString(searchText, 30.0f, renderY, 0xFFFFFF);
        this.renderCenteredString(displayText, (float)this.getScreenWidth() / 2.0f, 15.0f, 0xFFFFFF);
        super.renderExtra();
    }

    @Override
    public void postRender() {
        if (this.scrollList.currentHoverText != null && !this.scrollList.currentHoverText.isEmpty()) {
            this.drawMultiLineString(this.scrollList.currentHoverText);
            this.scrollList.currentHoverText.clear();
        }
        super.postRender();
    }

    public SelectorGui setIdentifierType(ScrollableListControl.IdentifierType type) {
        this.identifierType = type;
        return this;
    }
}

