/*
 * Decompiled with CFR 0.152.
 */
package external.net.lenni0451.reflect.stream.method;

import external.net.lenni0451.reflect.Methods;
import external.net.lenni0451.reflect.stream.general.ModifierWrapper;
import external.net.lenni0451.reflect.stream.method.MethodStream;
import java.lang.reflect.Method;

public class MethodWrapper {
    private final MethodStream parent;
    private final Method method;
    private final ModifierWrapper modifier;

    public MethodWrapper(MethodStream parent, Method method) {
        this.parent = parent;
        this.method = method;
        this.modifier = new ModifierWrapper(method.getModifiers());
    }

    public MethodStream parent() {
        return this.parent;
    }

    public Method raw() {
        return this.method;
    }

    public String name() {
        return this.method.getName();
    }

    public Class<?> returnType() {
        return this.method.getReturnType();
    }

    public Class<?>[] parameterTypes() {
        return this.method.getParameterTypes();
    }

    public int parameterCount() {
        return this.method.getParameterCount();
    }

    public Class<?> owner() {
        return this.method.getDeclaringClass();
    }

    public ModifierWrapper modifier() {
        return this.modifier;
    }

    public <T> T invoke() {
        return this.invokeArgs(new Object[0]);
    }

    public <T> T invokeArgs(Object ... args) {
        if (!this.modifier.isStatic() && this.parent.parent().instance() == null) {
            throw new IllegalStateException("Can not invoke non-static method if no instance is provided");
        }
        return Methods.invoke(this.parent.parent().instance(), this.method, args);
    }

    public <T> T invokeInstance(Object instance, Object ... args) {
        return Methods.invoke(instance, this.method, args);
    }
}

