/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public abstract class TagNearbyPlayer
extends Tag {
    public static final int MAXIMUM_INDEX = 16;
    private static final Comparator<EntityPlayer> PLAYER_DISTANCE_COMPARATOR = (playerA, playerB) -> {
        double distanceB;
        if (Tag.player == null) {
            return 0;
        }
        double distanceA = Tag.player.func_70068_e((Entity)playerA);
        if (distanceA > (distanceB = Tag.player.func_70068_e((Entity)playerB))) {
            return 1;
        }
        if (distanceA < distanceB) {
            return -1;
        }
        return 0;
    };
    protected static EntityPlayer[] nearbyPlayers = null;
    protected final int index;

    public TagNearbyPlayer(int index) {
        this.index = index;
    }

    @Override
    public String getName() {
        return super.getName() + this.index;
    }

    @Override
    public String[] getAliases() {
        String[] aliases = super.getAliases();
        String[] aliasesIndexed = new String[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            aliasesIndexed[i] = aliases[i] + this.index;
        }
        return aliasesIndexed;
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public int getMaximumIndex() {
        return 15;
    }

    @Override
    public String getCategory() {
        return "nearbyplayer";
    }

    protected static void updateNearbyPlayers() {
        if (nearbyPlayers == null) {
            ArrayList<EntityPlayer> playerList = new ArrayList<EntityPlayer>();
            for (Object o : TagNearbyPlayer.world.field_73010_i) {
                EntityPlayer entityPlayer;
                if (!(o instanceof EntityPlayer) || (entityPlayer = (EntityPlayer)o) == Tag.player || entityPlayer.func_70093_af()) continue;
                playerList.add(entityPlayer);
            }
            playerList.sort(PLAYER_DISTANCE_COMPARATOR);
            nearbyPlayers = playerList.toArray(new EntityPlayer[0]);
        }
    }

    public static void register() {
        for (int i = 0; i < 16; ++i) {
            TagRegistry.INSTANCE.register(new Name(i).setName("nearbyplayername"));
            TagRegistry.INSTANCE.register(new Distance(i).setName("nearbyplayerdistance"));
        }
    }

    public static void releaseResources() {
        nearbyPlayers = null;
    }

    public static class Distance
    extends TagNearbyPlayer {
        public Distance(int index) {
            super(index);
        }

        @Override
        public String getValue() {
            Distance.updateNearbyPlayers();
            if (nearbyPlayers.length > this.index) {
                return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(nearbyPlayers[this.index].func_70032_d((Entity)player)));
            }
            return "-1";
        }
    }

    public static class Name
    extends TagNearbyPlayer {
        public Name(int index) {
            super(index);
        }

        @Override
        public String getValue() {
            Name.updateNearbyPlayers();
            if (nearbyPlayers.length > this.index) {
                return nearbyPlayers[this.index].func_145748_c_().func_150254_d();
            }
            return "";
        }
    }
}

