/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.items;

import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.Pair;
import goodgenerator.util.CharExchanger;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TextureSet;

public class MyMaterial
implements Runnable {
    protected static final int OffsetID = 10001;
    public static final Werkstoff graphiteUraniumMixture = new Werkstoff(new short[]{58, 119, 61}, "Graphite-Uranium Mixture", BW_Util.subscriptNumbers((String)"C3U"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addMixerRecipes().onlyDust(), 10001, TextureSet.SET_DULL, new Pair[]{new Pair((Object)Materials.Graphite, (Object)3), new Pair((Object)Materials.Uranium, (Object)1)});
    public static final Werkstoff uraniumBasedLiquidFuel = new Werkstoff(new short[]{0, 255, 0}, "Uranium Based Liquid Fuel", BW_Util.subscriptNumbers((String)"U36K8Qt4Rn"), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10002, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff uraniumBasedLiquidFuelExcited = new Werkstoff(new short[]{0, 255, 0}, "Uranium Based Liquid Fuel (Excited State)", BW_Util.subscriptNumbers((String)"*(U36K8Qt4Rn)*"), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10003, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff uraniumBasedLiquidFuelDepleted = new Werkstoff(new short[]{110, 139, 61}, "Uranium Based Liquid Fuel (Depleted)", BW_Util.subscriptNumbers((String)"Pb?Bi?Ba?Xe?"), new Werkstoff.Stats().setToxic(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10004, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff uraniumCarbideThoriumMixture = new Werkstoff(new short[]{22, 50, 7}, "Uranium Carbide-Thorium Mixture", Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addMixerRecipes().onlyDust(), 10005, TextureSet.SET_DULL, new Pair[]{new Pair((Object)Materials.Thorium, (Object)11), new Pair((Object)WerkstoffLoader.Thorium232, (Object)1), new Pair((Object)Materials.Uranium235, (Object)1), new Pair((Object)Materials.Carbon, (Object)3)});
    public static final Werkstoff thoriumBasedLiquidFuel = new Werkstoff(new short[]{80, 50, 102}, "Thorium Based Liquid Fuel", BW_Util.subscriptNumbers((String)"Th432Li4D2Hg"), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10006, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff thoriumBasedLiquidFuelExcited = new Werkstoff(new short[]{80, 50, 102}, "Thorium Based Liquid Fuel (Excited State)", BW_Util.subscriptNumbers((String)"*(Th432Li4D2Hg)*"), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10007, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff thoriumBasedLiquidFuelDepleted = new Werkstoff(new short[]{125, 108, 138}, "Thorium Based Liquid Fuel (Depleted)", BW_Util.subscriptNumbers((String)"Th?Pr?B?In?"), new Werkstoff.Stats().setToxic(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10008, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff plutoniumOxideUraniumMixture = new Werkstoff(new short[]{209, 31, 74}, "Plutonium Oxide-Uranium Mixture", Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addMixerRecipes().onlyDust(), 10009, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)Materials.Plutonium, (Object)10), new Pair((Object)Materials.Oxygen, (Object)12), new Pair((Object)Materials.Uranium, (Object)2), new Pair((Object)Materials.Carbon, (Object)8)});
    public static final Werkstoff plutoniumBasedLiquidFuel = new Werkstoff(new short[]{239, 21, 21}, "Plutonium Based Liquid Fuel", BW_Util.subscriptNumbers((String)"Pu45Nt8Cs16Nq2"), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10010, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff plutoniumBasedLiquidFuelExcited = new Werkstoff(new short[]{239, 21, 21}, "Plutonium Based Liquid Fuel (Excited State)", BW_Util.subscriptNumbers((String)"*(Pu45Nt8Cs16Nq2)*"), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10011, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff plutoniumBasedLiquidFuelDepleted = new Werkstoff(new short[]{103, 25, 25}, "Plutonium Based Liquid Fuel (Depleted)", BW_Util.subscriptNumbers((String)"Tn?Ce?Au?Kr?"), new Werkstoff.Stats().setToxic(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10012, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff oxalate = new Werkstoff(new short[]{121, 216, 85}, "Oxalate", Werkstoff.Types.BIOLOGICAL, new Werkstoff.GenerationFeatures().disable().addCells(), 10013, TextureSet.SET_FLUID, new Pair[]{new Pair((Object)Materials.Hydrogen, (Object)2), new Pair((Object)Materials.Carbon, (Object)2), new Pair((Object)Materials.Oxygen, (Object)4)});
    public static final Werkstoff vanadiumPentoxide = new Werkstoff(new short[]{222, 141, 18}, "Vanadium Pentoxide", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10014, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)Materials.Vanadium, (Object)2), new Pair((Object)Materials.Oxygen, (Object)5)});
    public static final Werkstoff thoriumNitrate = new Werkstoff(new short[]{186, 232, 38}, "Thorium Nitrate", BW_Util.subscriptNumbers((String)"Th(NO3)4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10015, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff thoriumOxalate = new Werkstoff(new short[]{80, 99, 19}, "Thorium Oxalate", BW_Util.subscriptNumbers((String)"Th(C2O4)2"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10016, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff thoriumHydroxide = new Werkstoff(new short[]{146, 174, 137}, "Thorium Hydroxide", BW_Util.subscriptNumbers((String)"Th(OH)4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10017, TextureSet.SET_SHINY, new Pair[0]);
    public static final Werkstoff sodiumOxalate = new Werkstoff(new short[]{228, 248, 155}, "Sodium Oxalate", BW_Util.subscriptNumbers((String)"Na2C2O4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10018, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff thoriumTetrachloride = new Werkstoff(new short[]{19, 124, 22}, "Thorium Tetrachloride", BW_Util.subscriptNumbers((String)"ThCl4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10019, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff thoriumTetrafluoride = new Werkstoff(new short[]{21, 106, 106}, "Thorium Tetrafluoride", BW_Util.subscriptNumbers((String)"ThF4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10020, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff thorium232Tetrafluoride = new Werkstoff(new short[]{21, 106, 106}, "Thorium-232 Tetrafluoride", new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10021, TextureSet.SET_FLUID, new Pair[]{new Pair((Object)WerkstoffLoader.Thorium232, (Object)1), new Pair((Object)Materials.Fluorine, (Object)4)});
    public static final Werkstoff orundum = new Werkstoff(new short[]{205, 38, 38}, "Orundum", "Or", new Werkstoff.Stats().setProtons(120L).setMass(300L), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().addGems().addMolten(), 10023, TextureSet.SET_DIAMOND, new Pair[0]);
    public static final Werkstoff atomicSeparationCatalyst = new Werkstoff(new short[]{232, 94, 12}, "Atomic Separation Catalyst", "the melting core...", new Werkstoff.Stats().setMeltingPoint(5000).setBlastFurnace(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten().addMetalItems().addSimpleMetalWorkingItems().addCraftingMetalWorkingItems().addMultipleIngotMetalWorkingItems(), 10022, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)orundum, (Object)2), new Pair((Object)Materials.Plutonium, (Object)1), new Pair((Object)Materials.Naquadah, (Object)2)});
    public static final Werkstoff extremelyUnstableNaquadah = new Werkstoff(new short[]{6, 38, 5}, "Extremely Unstable Naquadah", "Nq" + CharExchanger.shifter(9734), new Werkstoff.Stats().setMeltingPoint(7000).setBlastFurnace(true).setProtons(200L).setMass(450L).setRadioactive(true), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten().addMetalItems().addSimpleMetalWorkingItems().addCraftingMetalWorkingItems().addMultipleIngotMetalWorkingItems(), 10024, TextureSet.SET_SHINY, new Pair[0]);
    public static final Werkstoff lightNaquadahFuel = new Werkstoff(new short[]{92, 203, 92}, "Light Naquadah Fuel", "far from enough", new Werkstoff.Stats().setToxic(true).setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10025, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff heavyNaquadahFuel = new Werkstoff(new short[]{54, 255, 54}, "Heavy Naquadah Fuel", "still need processing", new Werkstoff.Stats().setToxic(true).setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10026, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahGas = new Werkstoff(new short[]{93, 219, 0}, "Naquadah Gas", "Who need it?", new Werkstoff.Stats().setToxic(true).setRadioactive(true).setGas(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10027, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahAsphalt = new Werkstoff(new short[]{5, 37, 5}, "Naquadah Asphalt", "It will damage the reactor.", new Werkstoff.Stats().setToxic(true).setRadioactive(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10028, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ether = new Werkstoff(new short[]{235, 188, 47}, "Ether", BW_Util.subscriptNumbers((String)"CH3CH2OCH2CH3"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10029, TextureSet.SET_FLUID, new Pair[]{new Pair((Object)Materials.Carbon, (Object)4), new Pair((Object)Materials.Hydrogen, (Object)10), new Pair((Object)Materials.Oxygen, (Object)1)});
    public static final Werkstoff antimonyTrichloride = new Werkstoff(new short[]{15, 220, 52}, "Antimony Trichloride Solution", BW_Util.subscriptNumbers((String)"SbCl3"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10030, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff antimonyPentachlorideSolution = new Werkstoff(new short[]{21, 147, 44}, "Antimony Pentachloride Solution", BW_Util.subscriptNumbers((String)"SbCl5"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10031, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff antimonyPentachloride = new Werkstoff(new short[]{21, 147, 44}, "Antimony Pentachloride", BW_Util.subscriptNumbers((String)"SbCl5"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10032, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff antimonyPentafluoride = new Werkstoff(new short[]{22, 213, 226}, "Antimony Pentafluoride", BW_Util.subscriptNumbers((String)"SbF5"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10033, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff fluoroantimonicAcid = new Werkstoff(new short[]{22, 213, 226}, "Fluoroantimonic Acid", BW_Util.subscriptNumbers((String)"HSbF6"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10034, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff radioactiveSludge = new Werkstoff(new short[]{179, 73, 30}, "Radioactive Sludge", ">>> DANGER <<<", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10035, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff acidNaquadahEmulsion = new Werkstoff(new short[]{37, 34, 34}, "Acid Naquadah Emulsion", "??Nq??H" + CharExchanger.shifter(8314), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10036, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahEmulsion = new Werkstoff(new short[]{74, 70, 69}, "Naquadah Emulsion", "??Nq??", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10037, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahSolution = new Werkstoff(new short[]{132, 129, 128}, "Naquadah Solution", "~Nq~", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10038, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkI = new Werkstoff(new short[]{98, 92, 91}, "Naquadah Based Liquid Fuel MkI", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10039, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkIDepleted = new Werkstoff(new short[]{203, 195, 193}, "Naquadah Based Liquid Fuel MkI (Depleted)", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10040, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkII = new Werkstoff(new short[]{82, 78, 77}, "Naquadah Based Liquid Fuel MkII", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10041, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkIIDepleted = new Werkstoff(new short[]{181, 176, 174}, "Naquadah Based Liquid Fuel MkII (Depleted)", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10042, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkIII = new Werkstoff(new short[]{41, 34, 33}, "Naquadah Based Liquid Fuel MkIII", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10046, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkIIIDepleted = new Werkstoff(new short[]{102, 64, 56}, "Naquadah Based Liquid Fuel MkIII (Depleted)", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10047, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkIV = new Werkstoff(new short[]{14, 12, 12}, "Naquadah Based Liquid Fuel MkIV", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10048, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkIVDepleted = new Werkstoff(new short[]{142, 52, 34}, "Naquadah Based Liquid Fuel MkIV (Depleted)", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10049, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkV = new Werkstoff(new short[]{0, 0, 0}, "Naquadah Based Liquid Fuel MkV", "THE END", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10050, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkVDepleted = new Werkstoff(new short[]{255, 255, 255}, "Naquadah Based Liquid Fuel MkV (Depleted)", "THE END (literally)", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10051, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkVI = new Werkstoff(new short[]{48, 0, 0}, "Naquadah Based Liquid Fuel MkVI", "THE FUTURE", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10116, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahBasedFuelMkVIDepleted = new Werkstoff(new short[]{153, 51, 51}, "Naquadah Based Liquid Fuel MkVI (Depleted)", "THE FUTURE (achieved)", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10117, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff zincChloride = new Werkstoff(new short[]{115, 165, 252}, "Zinc Chloride", BW_Util.subscriptNumbers((String)"ZnCl2"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10052, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)Materials.Zinc, (Object)1), new Pair((Object)Materials.Chlorine, (Object)2)});
    public static final Werkstoff zincThoriumAlloy = new Werkstoff(new short[]{18, 52, 86}, "Zn-Th Alloy", BW_Util.subscriptNumbers((String)"ZnTh"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten().addMetalItems(), 10053, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)Materials.Zinc, (Object)1), new Pair((Object)Materials.Thorium, (Object)1)});
    public static final Werkstoff naquadahEarth = new Werkstoff(new short[]{76, 76, 76}, "Naquadah Oxide Mixture", BW_Util.subscriptNumbers((String)"??NqTiGaAd??"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 10054, TextureSet.SET_METALLIC, new Pair[0]);
    public static final Werkstoff titaniumTrifluoride = new Werkstoff(new short[]{192, 146, 168}, "Titanium Trifluoride", BW_Util.subscriptNumbers((String)"TiF3"), new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10055, TextureSet.SET_METALLIC, new Pair[]{new Pair((Object)Materials.Titanium, (Object)1), new Pair((Object)Materials.Fluorine, (Object)3)});
    public static final Werkstoff lowQualityNaquadahEmulsion = new Werkstoff(new short[]{76, 76, 76}, "Low Quality Naquadah Emulsion", BW_Util.subscriptNumbers((String)"??NqGaAd??"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10056, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff galliumHydroxide = new Werkstoff(new short[]{166, 166, 166}, "Gallium Hydroxide", BW_Util.subscriptNumbers((String)"Ga(OH)3"), new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10057, TextureSet.SET_DULL, new Pair[]{new Pair((Object)Materials.Gallium, (Object)1), new Pair((Object)Materials.Oxygen, (Object)3), new Pair((Object)Materials.Hydrogen, (Object)3)});
    public static final Werkstoff lowQualityNaquadahSolution = new Werkstoff(new short[]{113, 98, 98}, "Low Quality Naquadah Solution", BW_Util.subscriptNumbers((String)"~??NqAd??~"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10058, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff towEthyl1Hexanol = new Werkstoff(new short[]{128, 181, 87}, "2-Ethyl-1-Hexanol", BW_Util.subscriptNumbers((String)"C8H18O"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10059, TextureSet.SET_FLUID, new Pair[]{new Pair((Object)Materials.Carbon, (Object)8), new Pair((Object)Materials.Oxygen, (Object)1), new Pair((Object)Materials.Hydrogen, (Object)18)});
    public static final Werkstoff P507 = new Werkstoff(new short[]{41, 194, 42}, "P-507", BW_Util.subscriptNumbers((String)"(C8H17)2PO3H"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10060, TextureSet.SET_FLUID, new Pair[]{new Pair((Object)Materials.Carbon, (Object)16), new Pair((Object)Materials.Phosphorus, (Object)1), new Pair((Object)Materials.Oxygen, (Object)3), new Pair((Object)Materials.Hydrogen, (Object)35)});
    public static final Werkstoff naquadahAdamantiumSolution = new Werkstoff(new short[]{61, 56, 56}, "Naquadah-Adamantium Solution", BW_Util.subscriptNumbers((String)"~NqAd~"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10061, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahRichSolution = new Werkstoff(new short[]{51, 51, 51}, "Naquadah-Rich Solution", BW_Util.subscriptNumbers((String)"~?Nq?~"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10062, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadahine = new Werkstoff(new short[]{51, 51, 51}, "Naquadahine", BW_Util.subscriptNumbers((String)"NqO2"), new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10063, TextureSet.SET_METALLIC, new Pair[]{new Pair((Object)Materials.Naquadah, (Object)1), new Pair((Object)Materials.Oxygen, (Object)2)});
    public static final Werkstoff fluorineRichWasteLiquid = new Werkstoff(new short[]{19, 104, 98}, "Fluorine-Rich Waste Liquid", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10064, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff wasteLiquid = new Werkstoff(new short[]{20, 28, 104}, "Waste Liquid", new Werkstoff.Stats().setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10065, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff adamantine = new Werkstoff(new short[]{183, 183, 183}, "Adamantine", BW_Util.subscriptNumbers((String)"Ad2O3"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10066, TextureSet.SET_DULL, new Pair[]{new Pair((Object)Materials.Adamantium, (Object)2), new Pair((Object)Materials.Oxygen, (Object)3)});
    public static final Werkstoff enrichedNaquadahEarth = new Werkstoff(new short[]{130, 104, 104}, "Enriched-Naquadah Oxide Mixture", BW_Util.subscriptNumbers((String)"??KeNq") + CharExchanger.shifter(8314) + "??", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 10067, TextureSet.SET_METALLIC, new Pair[0]);
    public static final Werkstoff triniumSulphate = new Werkstoff(new short[]{218, 218, 218}, "Trinium Sulphate", BW_Util.subscriptNumbers((String)"KeSO4"), new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10068, TextureSet.SET_METALLIC, new Pair[]{new Pair((Object)Materials.Trinium, (Object)1), new Pair((Object)Materials.Sulfur, (Object)1), new Pair((Object)Materials.Oxygen, (Object)4)});
    public static final Werkstoff enrichedNaquadahRichSolution = new Werkstoff(new short[]{82, 57, 57}, "Enriched-Naquadah-Rich Solution", BW_Util.subscriptNumbers((String)"~?Nq") + CharExchanger.shifter(8314) + "?~", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10069, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff concentratedEnrichedNaquadahSludge = new Werkstoff(new short[]{82, 57, 57}, "Concentrated Enriched-Naquadah Sludge", BW_Util.subscriptNumbers((String)"?Nq") + CharExchanger.shifter(8314) + "?", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10070, TextureSet.SET_METALLIC, new Pair[0]);
    public static final Werkstoff enrichedNaquadahSulphate = new Werkstoff(new short[]{82, 57, 57}, "Enriched-Naquadah Sulphate", "Nq" + CharExchanger.shifter(8314) + BW_Util.subscriptNumbers((String)"(SO4)2"), new Werkstoff.Stats().setRadioactive(true).setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10071, TextureSet.SET_DULL, new Pair[]{new Pair((Object)Materials.NaquadahEnriched, (Object)1), new Pair((Object)Materials.Sulfur, (Object)2), new Pair((Object)Materials.Oxygen, (Object)8)});
    public static final Werkstoff naquadriaEarth = new Werkstoff(new short[]{77, 77, 85}, "Naquadria Oxide Mixture", BW_Util.subscriptNumbers((String)"??Nq*BaIn??"), new Werkstoff.Stats().setRadioactive(true).setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 10072, TextureSet.SET_METALLIC, new Pair[0]);
    public static final Werkstoff indiumPhosphate = new Werkstoff(new short[]{43, 46, 112}, "Indium Phosphate", BW_Util.subscriptNumbers((String)"InPO4"), new Werkstoff.Stats().setToxic(true).setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10073, TextureSet.SET_DULL, new Pair[]{new Pair((Object)Materials.Indium, (Object)1), new Pair((Object)Materials.Phosphorus, (Object)1), new Pair((Object)Materials.Oxygen, (Object)4)});
    public static final Werkstoff lowQualityNaquadriaPhosphate = new Werkstoff(new short[]{77, 77, 85}, "Low Quality Naquadria Phosphate", BW_Util.subscriptNumbers((String)"??Nq*3(PO4)4??"), new Werkstoff.Stats().setRadioactive(true).setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10074, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff naquadriaRichSolution = new Werkstoff(new short[]{31, 30, 51}, "Naquadria-Rich Solution", BW_Util.subscriptNumbers((String)"~?Nq*?~"), new Werkstoff.Stats().setRadioactive(true).setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10075, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff lowQualityNaquadriaSulphate = new Werkstoff(new short[]{115, 114, 132}, "Low Quality Naquadria Sulphate", BW_Util.subscriptNumbers((String)"??Nq*(SO4)2??"), new Werkstoff.Stats().setRadioactive(true).setToxic(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10076, TextureSet.SET_METALLIC, new Pair[0]);
    public static final Werkstoff lowQualityNaquadriaSolution = new Werkstoff(new short[]{115, 114, 132}, "Low Quality Naquadria Sulphate", BW_Util.subscriptNumbers((String)"~??Nq*??~"), new Werkstoff.Stats().setRadioactive(true).setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10077, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadriaSulphate = new Werkstoff(new short[]{31, 30, 51}, "Naquadria Sulphate", BW_Util.subscriptNumbers((String)"Nq*(SO4)2"), new Werkstoff.Stats().setRadioactive(true).setToxic(true).setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10078, TextureSet.SET_METALLIC, new Pair[]{new Pair((Object)Materials.Naquadria, (Object)1), new Pair((Object)Materials.Sulfur, (Object)2), new Pair((Object)Materials.Oxygen, (Object)8)});
    public static final Werkstoff naquadahGoo = new Werkstoff(new short[]{76, 76, 76}, "Naquadah Goo", BW_Util.subscriptNumbers((String)"??NqTiGaAd??"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10079, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff enrichedNaquadahGoo = new Werkstoff(new short[]{130, 104, 104}, "Enriched Naquadah Goo", BW_Util.subscriptNumbers((String)"??KeNq") + CharExchanger.shifter(8314) + "??", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10080, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff naquadriaGoo = new Werkstoff(new short[]{77, 77, 85}, "Naquadria Goo", BW_Util.subscriptNumbers((String)"??Nq*BaIn??"), new Werkstoff.Stats().setRadioactive(true).setToxic(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10081, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff zircaloy4 = new Werkstoff(new short[]{138, 110, 104}, "Zircaloy-4", BW_Util.subscriptNumbers((String)"Zr34Sn5Fe2Cr"), new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(2800), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMixerRecipes((short)4), 10082, TextureSet.SET_METALLIC, new Pair[]{new Pair((Object)WerkstoffLoader.Zirconium, (Object)34), new Pair((Object)Materials.Tin, (Object)5), new Pair((Object)Materials.Iron, (Object)2), new Pair((Object)Materials.Chrome, (Object)1)});
    public static final Werkstoff zircaloy2 = new Werkstoff(new short[]{164, 143, 139}, "Zircaloy-2", BW_Util.subscriptNumbers((String)"Zr34Sn4FeCrNi"), new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(2800), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMixerRecipes((short)2), 10083, TextureSet.SET_METALLIC, new Pair[]{new Pair((Object)WerkstoffLoader.Zirconium, (Object)34), new Pair((Object)Materials.Tin, (Object)4), new Pair((Object)Materials.Iron, (Object)1), new Pair((Object)Materials.Chrome, (Object)1), new Pair((Object)Materials.Nickel, (Object)1)});
    public static final Werkstoff incoloy903 = new Werkstoff(new short[]{164, 143, 139}, "Incoloy-903", BW_Util.subscriptNumbers((String)"Fe12Ni10Co8Ti4Mo2Al"), new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(3700), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMixerRecipes((short)6), 10084, TextureSet.SET_METALLIC, new Pair[]{new Pair((Object)Materials.Iron, (Object)12), new Pair((Object)Materials.Nickel, (Object)10), new Pair((Object)Materials.Cobalt, (Object)8), new Pair((Object)Materials.Titanium, (Object)4), new Pair((Object)Materials.Molybdenum, (Object)2), new Pair((Object)Materials.Aluminium, (Object)1)});
    public static final Werkstoff adamantiumAlloy = new Werkstoff(new short[]{160, 160, 160}, "Adamantium Alloy", BW_Util.subscriptNumbers((String)"Ad5Nq2La3"), new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(5500).setSpeedOverride(191.2f).setDurOverride(102400), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems().addMixerRecipes((short)3), 10085, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)Materials.Adamantium, (Object)5), new Pair((Object)Materials.Naquadah, (Object)2), new Pair((Object)Materials.Lanthanum, (Object)3)});
    public static final Werkstoff ethanolGasoline = new Werkstoff(new short[]{228, 198, 97}, "Ethanol Gasoline", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10086, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff cyclopentadiene = new Werkstoff(new short[]{255, 246, 189}, "Cyclopentadiene", BW_Util.subscriptNumbers((String)"C5H6"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10087, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ferrousChloride = new Werkstoff(new short[]{91, 91, 91}, "Iron II Chloride", BW_Util.subscriptNumbers((String)"FeCl2"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10088, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff diethylamine = new Werkstoff(new short[]{105, 119, 202}, "Diethylamine", BW_Util.subscriptNumbers((String)"C4H11N"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 10089, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff impureFerroceneMixture = new Werkstoff(new short[]{121, 85, 8}, "Impure Ferrocene Mixture", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10090, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ferroceneSolution = new Werkstoff(new short[]{222, 126, 28}, "Ferrocene Solution", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10091, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ferroceneWaste = new Werkstoff(new short[]{53, 29, 3}, "Ferrocene Waste", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10092, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ferrocene = new Werkstoff(new short[]{241, 143, 43}, "Ferrocene", BW_Util.subscriptNumbers((String)"Fe(C5H5)2"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10093, TextureSet.SET_SHINY, new Pair[0]);
    public static final Werkstoff ironedKerosene = new Werkstoff(new short[]{151, 0, 97}, "Jet Fuel No.3", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10094, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ironedFuel = new Werkstoff(new short[]{255, 152, 0}, "Jet Fuel A", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10095, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff marM200 = new Werkstoff(new short[]{81, 81, 81}, "MAR-M200 Steel", new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(5000), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems().addMixerRecipes((short)7), 10096, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)Materials.Niobium, (Object)2), new Pair((Object)Materials.Chrome, (Object)9), new Pair((Object)Materials.Aluminium, (Object)5), new Pair((Object)Materials.Titanium, (Object)2), new Pair((Object)Materials.Cobalt, (Object)10), new Pair((Object)Materials.Tungsten, (Object)13), new Pair((Object)Materials.Nickel, (Object)18)});
    public static final Werkstoff marCeM200 = new Werkstoff(new short[]{56, 48, 48}, "MAR-Ce-M200 Steel", new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(5000).setMass(1200L).setProtons(1000L).setSpeedOverride(150.0f).setDurOverride(204800), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems(), 10097, TextureSet.SET_METALLIC, new Pair[]{new Pair((Object)marM200, (Object)18), new Pair((Object)Materials.Cerium, (Object)1)});
    public static final Werkstoff lithiumChloride = new Werkstoff(new short[]{183, 226, 206}, "Lithium Chloride", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().enforceUnification(), 10098, TextureSet.SET_DULL, new Pair[]{new Pair((Object)Materials.Lithium, (Object)1), new Pair((Object)Materials.Chlorine, (Object)1)});
    public static final Werkstoff signalium = new Werkstoff(new short[]{212, 64, 0}, "Signalium", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(4000), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems(), 10099, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)Materials.AnnealedCopper, (Object)4), new Pair((Object)Materials.Ardite, (Object)2), new Pair((Object)Materials.RedAlloy, (Object)2)});
    public static final Werkstoff lumiinessence = new Werkstoff(new short[]{232, 242, 36}, "Lumiinessence", BW_Util.subscriptNumbers((String)"(Al??)2(PO4)4"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust(), 10100, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff lumiium = new Werkstoff(new short[]{232, 242, 36}, "Lumiium", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(4000), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems(), 10101, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)Materials.TinAlloy, (Object)4), new Pair((Object)Materials.SterlingSilver, (Object)2), new Pair((Object)lumiinessence, (Object)2)});
    public static final Werkstoff artheriumSn = new Werkstoff(new short[]{96, 54, 247}, "Artherium-Sn", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(6500).setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMixerRecipes((short)6), 10102, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)adamantiumAlloy, (Object)12), new Pair((Object)orundum, (Object)9), new Pair((Object)Materials.Tin, (Object)8), new Pair((Object)Materials.Arsenic, (Object)7), new Pair((Object)Materials.Caesium, (Object)4), new Pair((Object)Materials.Osmiridium, (Object)3)});
    public static final Werkstoff titaniumBetaC = new Werkstoff(new short[]{199, 47, 204}, "Tanmolyium Beta-C", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(5300).setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMixerRecipes((short)5), 10103, TextureSet.SET_METALLIC, new Pair[]{new Pair((Object)Materials.Titanium, (Object)5), new Pair((Object)Materials.Molybdenum, (Object)5), new Pair((Object)Materials.Vanadium, (Object)2), new Pair((Object)Materials.Chrome, (Object)3), new Pair((Object)Materials.Aluminium, (Object)1)});
    public static final Werkstoff dalisenite = new Werkstoff(new short[]{176, 184, 18}, "Dalisenite", new Werkstoff.Stats().setMeltingPoint(8700).setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMixerRecipes((short)6), 10104, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)titaniumBetaC, (Object)14), new Pair((Object)Materials.Tungsten, (Object)10), new Pair((Object)Materials.NiobiumTitanium, (Object)9), new Pair((Object)WerkstoffLoader.LuVTierMaterial, (Object)8), new Pair((Object)Materials.Quantium, (Object)7), new Pair((Object)Materials.Erbium, (Object)3)});
    public static final Werkstoff hikarium = new Werkstoff(new short[]{255, 214, 251}, "Hikarium", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(5400).setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMixerRecipes((short)3), 10105, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)lumiium, (Object)18), new Pair((Object)Materials.Silver, (Object)8), new Pair((Object)Materials.Sunnarium, (Object)4)});
    public static final Werkstoff tairitsu = new Werkstoff(new short[]{54, 54, 54}, "Tairitsu", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(7400).setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMixerRecipes((short)6), 10106, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)Materials.Tungsten, (Object)8), new Pair((Object)Materials.Naquadria, (Object)7), new Pair((Object)Materials.Bedrockium, (Object)4), new Pair((Object)Materials.Carbon, (Object)4), new Pair((Object)Materials.Vanadium, (Object)3), new Pair((Object)Materials.BlackPlutonium, (Object)1)});
    public static final Werkstoff antimonyPentafluorideSolution = new Werkstoff(new short[]{22, 213, 226}, "Antimony Pentafluoride Solution", BW_Util.subscriptNumbers((String)"SbF5"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 10107, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff magnesiumSulphate = new Werkstoff(new short[]{135, 116, 145}, "Magnesium Sulphate", BW_Util.subscriptNumbers((String)"MgSO4"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10108, TextureSet.SET_DULL, new Pair[]{new Pair((Object)Materials.Magnesium, (Object)1), new Pair((Object)Materials.Sulfur, (Object)1), new Pair((Object)Materials.Oxygen, (Object)4)});
    public static final Werkstoff preciousMetalAlloy = new Werkstoff(new short[]{157, 144, 198}, "Precious Metals Alloy", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(10000).setCentrifuge(true).setSpeedOverride(100.0f), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMultipleIngotMetalWorkingItems().addMixerRecipes((short)6), 10109, TextureSet.SET_SHINY, new Pair[]{new Pair((Object)WerkstoffLoader.Ruthenium, (Object)1), new Pair((Object)WerkstoffLoader.Rhodium, (Object)1), new Pair((Object)Materials.Palladium, (Object)1), new Pair((Object)Materials.Platinum, (Object)1), new Pair((Object)Materials.Osmium, (Object)1), new Pair((Object)Materials.Iridium, (Object)1)});
    public static final Werkstoff enrichedNaquadahAlloy = new Werkstoff(new short[]{22, 7, 64}, "Enriched Naquadah Alloy", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(11000).setCentrifuge(true).setSpeedOverride(180.0f), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems().addMixerRecipes((short)4), 10110, TextureSet.SET_METALLIC, new Pair[]{new Pair((Object)Materials.NaquadahEnriched, (Object)8), new Pair((Object)Materials.Tritanium, (Object)5), new Pair((Object)WerkstoffLoader.Californium, (Object)3), new Pair((Object)Materials.BlackPlutonium, (Object)2)});
    public static final Werkstoff metastableOganesson = new Werkstoff(new short[]{20, 57, 127}, "Metastable Oganesson", "Og*", new Werkstoff.Stats().setBlastFurnace(true).setProtons(118L).setMass(294L).setMeltingPoint(11000), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addMultipleIngotMetalWorkingItems(), 10111, TextureSet.SET_SHINY, new Pair[0]);
    public static final Werkstoff shirabon = new Werkstoff(new short[]{224, 21, 109}, "Shirabon", "Sh" + CharExchanger.shifter(9191), new Werkstoff.Stats().setBlastFurnace(true).setProtons(500L).setMass(750L).setMeltingPoint(13000).setSpeedOverride(640.0f).setDurOverride(0xF00000).setQualityOverride((byte)26), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems().addMetalCraftingSolidifierRecipes().addMetaSolidifierRecipes(), 10112, TextureSet.SET_SHINY, new Pair[0]);
    public static final Werkstoff inertNaquadah = new Werkstoff(new short[]{59, 59, 59}, "Inert Naquadah", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10113, TextureSet.SET_METALLIC, new Pair[]{new Pair((Object)Materials.Naquadah, (Object)1)});
    public static final Werkstoff inertEnrichedNaquadah = new Werkstoff(new short[]{97, 68, 68}, "Inert Enriched Naquadah", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10114, TextureSet.SET_METALLIC, new Pair[]{new Pair((Object)Materials.NaquadahEnriched, (Object)1)});
    public static final Werkstoff inertNaquadria = new Werkstoff(new short[]{0, 0, 0}, "Inert Naquadria", new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().onlyDust(), 10115, TextureSet.SET_METALLIC, new Pair[]{new Pair((Object)Materials.Naquadria, (Object)1)});

    @Override
    public void run() {
    }
}

