/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import java.util.Iterator;
import java.util.List;

public class RoundRobinIterator<T>
implements Iterable<T>,
Iterator<T> {
    private int index = -1;
    private int currentCount = 0;
    private final List<T> itOver;

    public RoundRobinIterator(List<T> itOver) {
        this.itOver = itOver;
    }

    @Override
    public Iterator<T> iterator() {
        this.currentCount = 0;
        return this;
    }

    @Override
    public boolean hasNext() {
        return !this.itOver.isEmpty() && this.currentCount < this.itOver.size();
    }

    @Override
    public T next() {
        if (this.itOver.isEmpty()) {
            return null;
        }
        ++this.currentCount;
        ++this.index;
        if (this.index >= this.itOver.size()) {
            this.index = 0;
        }
        return this.itOver.get(this.index);
    }

    @Override
    public void remove() {
    }
}

