/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.storage;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.api.storage.IEssentiaRepo;
import thaumicenergistics.common.storage.AspectStack;

public class EssentiaRepo
implements IEssentiaRepo {
    private final Map<Aspect, IAspectStack> cache = new ConcurrentHashMap<Aspect, IAspectStack>();

    @Override
    public Set<Aspect> aspectSet() {
        return this.cache.keySet();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public boolean containsAspect(Aspect aspect) {
        return this.cache.containsKey(aspect);
    }

    @Override
    public void copyFrom(Collection<IAspectStack> stacks) {
        this.clear();
        if (stacks == null) {
            return;
        }
        for (IAspectStack stack : stacks) {
            this.cache.put(stack.getAspect(), stack.copy());
        }
    }

    @Override
    public IAspectStack get(Aspect aspect) {
        return this.cache.getOrDefault(aspect, null);
    }

    @Override
    public Collection<IAspectStack> getAll() {
        return this.cache.values();
    }

    @Override
    public IAspectStack getOrDefault(Aspect aspect, IAspectStack defaultValue) {
        return this.cache.getOrDefault(aspect, defaultValue);
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public IAspectStack postChange(Aspect aspect, long change, Boolean isCraftableNullable) {
        if (aspect == null) {
            return null;
        }
        IAspectStack current = this.cache.get(aspect);
        if (current == null) {
            boolean isCraftable;
            AspectStack newStack = null;
            boolean bl = isCraftable = isCraftableNullable == null ? false : isCraftableNullable;
            if (change > 0L) {
                newStack = new AspectStack(aspect, change, isCraftable);
            } else if (isCraftable) {
                newStack = new AspectStack(aspect, 0L, isCraftable);
            }
            if (newStack != null) {
                this.cache.put(newStack.getAspect(), newStack);
            }
            return null;
        }
        IAspectStack previous = current.copy();
        boolean isCraftable = isCraftableNullable == null ? previous.getCraftable() : isCraftableNullable.booleanValue();
        long previousAmount = previous.getStackSize();
        long newAmount = Math.max(0L, previousAmount + change);
        if (newAmount == 0L && !isCraftable) {
            this.cache.remove(aspect);
        } else {
            current.setStackSize(newAmount);
            current.setCraftable(isCraftable);
        }
        return previous;
    }

    @Override
    public IAspectStack postChange(IAspectStack change) {
        if (change == null) {
            return null;
        }
        return this.postChange(change.getAspect(), change.getStackSize(), change.getCraftable());
    }

    @Override
    public IAspectStack remove(Aspect aspect) {
        return this.cache.remove(aspect);
    }

    @Override
    public IAspectStack setAspect(Aspect aspect, long amount, boolean isCraftable) {
        if (aspect == null) {
            return null;
        }
        return this.cache.put(aspect, new AspectStack(aspect, amount, isCraftable));
    }

    @Override
    public IAspectStack setAspect(IAspectStack stack) {
        if (stack == null) {
            return null;
        }
        return this.setAspect(stack.getAspect(), stack.getStackSize(), stack.getCraftable());
    }

    @Override
    public int size() {
        return this.cache.size();
    }
}

