/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.network.packet.client;

import appeng.api.config.RedstoneMode;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.client.gui.GuiEssentiaLevelEmitter;
import thaumicenergistics.common.network.NetworkHandler;
import thaumicenergistics.common.network.packet.client.ThEClientPacket;
import thaumicenergistics.common.registries.EnumCache;

public class Packet_C_EssentiaEmitter
extends ThEClientPacket {
    private static final byte MODE_UPDATE_WANTED = 1;
    private static final byte MODE_UPDATE_REDSTONE = 2;
    private RedstoneMode redstoneMode;
    private long threshold;

    private static Packet_C_EssentiaEmitter newPacket(EntityPlayer player, byte mode) {
        Packet_C_EssentiaEmitter packet = new Packet_C_EssentiaEmitter();
        packet.player = player;
        packet.mode = mode;
        return packet;
    }

    public static void sendRedstoneMode(RedstoneMode redstoneMode, EntityPlayer player) {
        Packet_C_EssentiaEmitter packet = Packet_C_EssentiaEmitter.newPacket(player, (byte)2);
        packet.redstoneMode = redstoneMode;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void sendThresholdValue(long threshold, EntityPlayer player) {
        Packet_C_EssentiaEmitter packet = Packet_C_EssentiaEmitter.newPacket(player, (byte)1);
        packet.threshold = threshold;
        NetworkHandler.sendPacketToClient(packet);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void wrappedExecute() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiEssentiaLevelEmitter) {
            switch (this.mode) {
                case 1: {
                    ((GuiEssentiaLevelEmitter)gui).onReceiveThresholdValue(this.threshold);
                    break;
                }
                case 2: {
                    ((GuiEssentiaLevelEmitter)gui).onReceiveRedstoneMode(this.redstoneMode);
                }
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 1: {
                this.threshold = stream.readLong();
                break;
            }
            case 2: {
                this.redstoneMode = EnumCache.AE_REDSTONE_MODES[stream.readInt()];
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 1: {
                stream.writeLong(this.threshold);
                break;
            }
            case 2: {
                stream.writeInt(this.redstoneMode.ordinal());
            }
        }
    }
}

