/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.items;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumicenergistics.api.items.IRestrictedEssentiaContainerItem;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.common.registries.ThEStrings;
import thaumicenergistics.common.storage.AspectStack;
import thaumicenergistics.common.tiles.abstraction.TileEVCBase;

public class ItemBlockEssentiaVibrationChamber
extends ItemBlock
implements IRestrictedEssentiaContainerItem {
    public ItemBlockEssentiaVibrationChamber(Block block) {
        super(block);
    }

    private IAspectStack getStoredAspectStack(ItemStack evcStack) {
        NBTTagCompound data = evcStack.func_77978_p();
        if (data == null || !data.func_74764_b("StoredEssentia")) {
            return null;
        }
        return AspectStack.loadAspectStackFromNBT(data.func_74775_l("StoredEssentia"));
    }

    private void setStoredAspectStack(ItemStack evcStack, IAspectStack aspectStack) {
        NBTTagCompound data = evcStack.func_77978_p();
        if (data == null) {
            data = new NBTTagCompound();
        }
        if (aspectStack == null) {
            data.func_82580_o("StoredEssentia");
        } else {
            NBTTagCompound storedTag = new NBTTagCompound();
            aspectStack.writeToNBT(storedTag);
            data.func_74782_a("StoredEssentia", (NBTBase)storedTag);
        }
        if (data.func_82582_d()) {
            data = null;
        }
        evcStack.func_77982_d(data);
    }

    @Override
    public boolean acceptsAspect(Aspect aspect) {
        return TileEVCBase.acceptsAspect(aspect);
    }

    public void func_77624_a(ItemStack evcStack, EntityPlayer player, List displayList, boolean advancedItemTooltips) {
        if (!evcStack.func_77942_o()) {
            return;
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            IAspectStack storedEssentia = this.getStoredAspectStack(evcStack);
            if (storedEssentia != null) {
                displayList.add(String.format("%s x %d", storedEssentia.getAspectName(), storedEssentia.getStackSize()));
            }
        } else {
            displayList.add(EnumChatFormatting.WHITE.toString() + EnumChatFormatting.ITALIC.toString() + ThEStrings.Tooltip_ItemStackDetails.getLocalized());
        }
    }

    public AspectList getAspects(ItemStack evcStack) {
        IAspectStack stored;
        AspectList list = new AspectList();
        if (evcStack.func_77942_o() && (stored = this.getStoredAspectStack(evcStack)) != null && !stored.isEmpty()) {
            list.add(stored.getAspect(), (int)stored.getStackSize());
        }
        return list;
    }

    public void setAspects(ItemStack evcStack, AspectList list) {
        AspectStack aspectStack = null;
        if (list.size() > 0) {
            Aspect aspect = list.getAspects()[0];
            aspectStack = new AspectStack(aspect, list.getAmount(aspect));
        }
        this.setStoredAspectStack(evcStack, aspectStack);
    }
}

