/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.gthandler.turboCharger;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.basic.GT_MetaTileEntity_Charger;
import net.minecraft.item.ItemStack;

public class GT_MetaTileEntity_TurboCharger
extends GT_MetaTileEntity_Charger {
    public GT_MetaTileEntity_TurboCharger(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aDescription, aSlotCount);
    }

    public GT_MetaTileEntity_TurboCharger(String aName, int aTier, String aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aDescription, aTextures, aSlotCount);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_TurboCharger(this.mName, this.mTier, this.mDescription, this.mTextures, this.mInventory.length);
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[2][17][];
        for (int b = -1; b < 16; b = (int)((byte)(b + 1))) {
            rTextures[0][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1]};
            rTextures[1][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_POWER[this.mTier]};
        }
        return rTextures;
    }

    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 1536L * (long)this.mInventory.length;
    }

    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 6144L * (long)this.mInventory.length;
    }

    public long maxAmperesIn() {
        return 16L * (long)this.mInventory.length;
    }

    public long maxAmperesOut() {
        return 4L * (long)this.mInventory.length;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            BaseMetaTileEntity mBaseMetaTileEntity;
            this.mCharge = aBaseMetaTileEntity.getStoredEU() / 2L > aBaseMetaTileEntity.getEUCapacity() / 3L || !aBaseMetaTileEntity.isAllowedToWork();
            this.mDecharge = aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity() / 3L && aBaseMetaTileEntity.isAllowedToWork();
            this.mBatteryCount = 0;
            this.mChargeableCount = 0;
            for (ItemStack tStack : this.mInventory) {
                if (!GT_ModHandler.isElectricItem((ItemStack)tStack, (byte)this.mTier)) continue;
                if (GT_ModHandler.isChargerItem((ItemStack)tStack)) {
                    ++this.mBatteryCount;
                }
                ++this.mChargeableCount;
            }
            if (this.getBaseMetaTileEntity() instanceof BaseMetaTileEntity && (mBaseMetaTileEntity = (BaseMetaTileEntity)this.getBaseMetaTileEntity()).getMetaTileEntity() instanceof MetaTileEntity) {
                int i;
                MetaTileEntity mMetaTileEntity = (MetaTileEntity)mBaseMetaTileEntity.getMetaTileEntity();
                if (mMetaTileEntity.dechargerSlotCount() > 0 && mBaseMetaTileEntity.getStoredEU() < mBaseMetaTileEntity.getEUCapacity()) {
                    int k = mMetaTileEntity.dechargerSlotCount() + i;
                    for (i = mMetaTileEntity.dechargerSlotStartIndex(); i < k; ++i) {
                        if (mMetaTileEntity.mInventory[i] == null || mBaseMetaTileEntity.getStoredEU() >= mBaseMetaTileEntity.getEUCapacity()) continue;
                        mBaseMetaTileEntity.increaseStoredEnergyUnits((long)GT_ModHandler.dischargeElectricItem((ItemStack)mMetaTileEntity.mInventory[i], (int)GT_Utility.safeInt((long)Math.min(GT_Values.V[this.mTier] * 120L, mBaseMetaTileEntity.getEUCapacity() - mBaseMetaTileEntity.getStoredEU())), (int)((int)Math.min(Integer.MAX_VALUE, mMetaTileEntity.getInputTier())), (boolean)true, (boolean)false, (boolean)false), true);
                        if (mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                        mMetaTileEntity.mInventory[i] = null;
                    }
                }
                if (mMetaTileEntity.rechargerSlotCount() > 0 && mBaseMetaTileEntity.getStoredEU() > 0L) {
                    int k = mMetaTileEntity.rechargerSlotCount() + i;
                    for (i = mMetaTileEntity.rechargerSlotStartIndex(); i < k; ++i) {
                        if (mBaseMetaTileEntity.getStoredEU() <= 0L || mMetaTileEntity.mInventory[i] == null) continue;
                        mBaseMetaTileEntity.decreaseStoredEU((long)GT_ModHandler.chargeElectricItem((ItemStack)mMetaTileEntity.mInventory[i], (int)GT_Utility.safeInt((long)Math.min(GT_Values.V[this.mTier] * 120L, mBaseMetaTileEntity.getStoredEU())), (int)((int)Math.min(Integer.MAX_VALUE, mMetaTileEntity.getOutputTier())), (boolean)true, (boolean)false), true);
                        if (mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                        mMetaTileEntity.mInventory[i] = null;
                    }
                }
            }
        }
    }
}

