/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.IMassiveBlock;
import de.katzenpapst.amunra.block.IMetaBlock;
import de.katzenpapst.amunra.block.SubBlock;
import de.katzenpapst.amunra.block.bush.SubBlockBush;
import de.katzenpapst.amunra.helper.BlockMassHelper;
import de.katzenpapst.amunra.item.ItemBlockMulti;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.block.IPlantableBlock;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBasicMeta
extends Block
implements IMetaBlock,
IDetectableResource,
IPlantableBlock,
ITerraformableBlock,
IMassiveBlock,
IPartialSealableBlock {
    protected SubBlock[] subBlocksArray;
    protected final Map<String, Integer> nameMetaMap = new HashMap<String, Integer>();
    protected boolean prefixOwnBlockName = false;
    protected String blockNameFU;

    public BlockBasicMeta(String name, Material mat, int numSubBlocks) {
        super(mat);
        this.subBlocksArray = new SubBlock[numSubBlocks];
        this.blockNameFU = name;
        this.func_149663_c(name);
    }

    public BlockBasicMeta setPrefixOwnBlockName(boolean set) {
        this.prefixOwnBlockName = set;
        return this;
    }

    public void func_149674_a(World worldIn, int x, int y, int z, Random random) {
        SubBlock sb;
        if (!worldIn.field_72995_K && (sb = this.getSubBlock(worldIn.func_72805_g(x, y, z))) != null) {
            sb.func_149674_a(worldIn, x, y, z, random);
        }
    }

    public BlockBasicMeta(String name, Material mat) {
        this(name, mat, 16);
    }

    @Override
    public int getMetaByName(String name) {
        if (this.nameMetaMap.containsKey(name)) {
            return this.nameMetaMap.get(name);
        }
        throw new IllegalArgumentException("Subblock " + name + " doesn't exist in " + this.blockNameFU);
    }

    @Override
    public BlockMetaPair addSubBlock(int meta, SubBlock sb) {
        if (meta >= this.subBlocksArray.length || meta < 0) {
            throw new IllegalArgumentException("Meta " + meta + " must be < " + this.subBlocksArray.length + " and >= 0");
        }
        if (this.subBlocksArray[meta] != null) {
            throw new IllegalArgumentException("Meta " + meta + " is already in use in " + this.blockNameFU);
        }
        if (this.nameMetaMap.containsKey(sb.func_149739_a())) {
            throw new IllegalArgumentException("Name " + sb.func_149739_a() + " is already in use in " + this.blockNameFU);
        }
        sb.setParent(this);
        this.nameMetaMap.put(sb.func_149739_a(), meta);
        this.subBlocksArray[meta] = sb;
        return new BlockMetaPair((Block)this, (byte)meta);
    }

    @Override
    public SubBlock getSubBlock(int meta) {
        return this.subBlocksArray[this.getDistinctionMeta(meta)];
    }

    @Override
    public int getNumPossibleSubBlocks() {
        return this.subBlocksArray.length;
    }

    @Override
    public void register() {
        GameRegistry.registerBlock((Block)this, ItemBlockMulti.class, (String)this.func_149739_a());
        for (int i = 0; i < this.subBlocksArray.length; ++i) {
            SubBlock sb = this.subBlocksArray[i];
            if (sb == null) continue;
            this.setHarvestLevel(sb.getHarvestTool(0), sb.getHarvestLevel(0), i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        for (SubBlock sb : this.subBlocksArray) {
            if (sb == null) continue;
            sb.func_149651_a(reg);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return AmunRa.arTab;
    }

    public float getExplosionResistance(Entity exploder, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        SubBlock sb = this.getSubBlock(world.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.getExplosionResistance(exploder, world, x, y, z, explosionX, explosionY, explosionZ);
        }
        return super.getExplosionResistance(exploder, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public float func_149712_f(World worldIn, int x, int y, int z) {
        SubBlock sb = this.getSubBlock(worldIn.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.func_149712_f(worldIn, x, y, z);
        }
        return super.func_149712_f(worldIn, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb != null) {
            return sb.func_149691_a(side, meta);
        }
        return super.func_149691_a(side, meta);
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb == null || sb.dropsSelf()) {
            return Item.func_150898_a((Block)this);
        }
        return sb.func_149650_a(0, random, fortune);
    }

    public int func_149692_a(int meta) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb == null || sb.dropsSelf()) {
            return this.getDistinctionMeta(meta);
        }
        return sb.func_149692_a(0);
    }

    public int func_149643_k(World worldIn, int x, int y, int z) {
        return this.getDistinctionMeta(worldIn.func_72805_g(x, y, z));
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb == null || sb.dropsSelf()) {
            return 1;
        }
        return sb.quantityDropped(meta, fortune, random);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < this.subBlocksArray.length; ++i) {
            if (this.subBlocksArray[i] == null) continue;
            list.add(new ItemStack(itemIn, 1, i));
        }
    }

    public boolean hasTileEntity(int meta) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb == null) {
            return super.hasTileEntity(meta);
        }
        return sb.hasTileEntity(meta);
    }

    public TileEntity createTileEntity(World world, int meta) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb == null) {
            return super.createTileEntity(world, meta);
        }
        return sb.createTileEntity(world, meta);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        if (this.getSubBlock(meta) != null) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, this.getDistinctionMeta(meta));
        }
        return super.getPickBlock(target, world, x, y, z, player);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getPickBlock(target, world, x, y, z, null);
    }

    public boolean func_149655_b(IBlockAccess worldIn, int x, int y, int z) {
        SubBlock sb = this.getSubBlock(worldIn.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.func_149655_b(worldIn, x, y, z);
        }
        return super.func_149655_b(worldIn, x, y, z);
    }

    public boolean func_149727_a(World worldIn, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        SubBlock sb = this.getSubBlock(worldIn.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.func_149727_a(worldIn, x, y, z, player, side, subX, subY, subZ);
        }
        return super.func_149727_a(worldIn, x, y, z, player, side, subX, subY, subZ);
    }

    public int getExpDrop(IBlockAccess world, int metadata, int fortune) {
        SubBlock sb = this.getSubBlock(metadata);
        if (sb != null) {
            return sb.getExpDrop(world, 0, fortune);
        }
        return super.getExpDrop(world, metadata, fortune);
    }

    public boolean isTerraformable(World world, int x, int y, int z) {
        SubBlock sb = this.getSubBlock(world.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.isTerraformable(world, x, y, z);
        }
        return false;
    }

    public int requiredLiquidBlocksNearby() {
        return 4;
    }

    public boolean isPlantable(int metadata) {
        SubBlock sb = this.getSubBlock(metadata);
        if (sb != null) {
            return sb.isPlantable(0);
        }
        return false;
    }

    public boolean isValueable(int metadata) {
        SubBlock sb = this.getSubBlock(metadata);
        if (sb != null) {
            return sb.isValueable(0);
        }
        return false;
    }

    public Material func_149688_o() {
        return this.field_149764_J;
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        if (plantable instanceof SubBlockBush) {
            SubBlockBush sbBush = (SubBlockBush)plantable;
            return sbBush.canPlaceOn(plantable.getPlant(world, x, y + 1, z), plantable.getPlantMetadata(world, x, y + 1, z), 0);
        }
        return super.canSustainPlant(world, x, y, z, direction, plantable);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        SubBlock sb = this.getSubBlock(world.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.func_149750_m();
        }
        return super.func_149750_m();
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        SubBlock sb = this.getSubBlock(metadata);
        if (sb == null || sb.dropsSelf()) {
            return super.getDrops(world, x, y, z, metadata, fortune);
        }
        return sb.getDrops(world, x, y, z, 0, fortune);
    }

    @Override
    public String getUnlocalizedSubBlockName(int meta) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb == null) {
            return this.blockNameFU;
        }
        if (this.prefixOwnBlockName) {
            return this.blockNameFU + "." + sb.func_149739_a();
        }
        return sb.func_149739_a();
    }

    public int func_149660_a(World worldIn, int x, int y, int z, int side, float subX, float subY, float subZ, int meta) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb != null) {
            return sb.func_149660_a(worldIn, x, y, z, side, subX, subY, subZ, meta);
        }
        return super.func_149660_a(worldIn, x, y, z, side, subX, subY, subZ, meta);
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block neighbor) {
        SubBlock sb = this.getSubBlock(worldIn.func_72805_g(x, y, z));
        if (sb != null) {
            sb.func_149695_a(worldIn, x, y, z, neighbor);
        }
    }

    @Override
    public float getMass(World w, int x, int y, int z, int meta) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb instanceof IMassiveBlock) {
            IMassiveBlock massiveBlock = (IMassiveBlock)((Object)sb);
            return massiveBlock.getMass(w, x, y, z, meta);
        }
        if (sb == null) {
            return 0.0f;
        }
        return BlockMassHelper.guessBlockMass(w, sb, meta, x, y, z);
    }

    public boolean isSealed(World world, int x, int y, int z, ForgeDirection direction) {
        SubBlock subBlock = this.getSubBlock(world.func_72805_g(x, y, z));
        if (subBlock instanceof IPartialSealableBlock) {
            IPartialSealableBlock psb = (IPartialSealableBlock)subBlock;
            return psb.isSealed(world, x, y, z, direction);
        }
        return true;
    }

    public void func_149749_a(World worldIn, int x, int y, int z, Block blockBroken, int meta) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb != null) {
            sb.func_149749_a(worldIn, x, y, z, blockBroken, meta);
        }
    }

    public boolean func_149718_j(World worldIn, int x, int y, int z) {
        SubBlock sb = this.getSubBlock(worldIn.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.func_149718_j(worldIn, x, y, z);
        }
        return super.func_149718_j(worldIn, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World worldIn, int x, int y, int z) {
        SubBlock sb = this.getSubBlock(worldIn.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.func_149668_a(worldIn, x, y, z);
        }
        return super.func_149668_a(worldIn, x, y, z);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb != null) {
            return sb.canHarvestBlock(player, meta);
        }
        return super.canHarvestBlock(player, meta);
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        SubBlock sb = this.getSubBlock(metadata);
        if (sb != null) {
            return sb.canSilkHarvest(world, player, x, y, z, metadata);
        }
        return super.canSilkHarvest(world, player, x, y, z, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World worldIn, int x, int y, int z) {
        SubBlock sb = this.getSubBlock(worldIn.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.func_149633_g(worldIn, x, y, z);
        }
        return super.func_149633_g(worldIn, x, y, z);
    }

    public boolean func_149678_a(int meta, boolean includeLiquid) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb != null) {
            return sb.func_149678_a(meta, includeLiquid);
        }
        return super.func_149678_a(meta, includeLiquid);
    }
}

