/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.crops;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import mods.natura.client.CropRender;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class CropBlock
extends BlockBush
implements IGrowable {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"barley_1", "barley_2", "barley_3", "barley_4", "cotton_1", "cotton_2", "cotton_3", "cotton_4", "cotton_5"};

    public CropBlock() {
        this.func_149675_a(true);
        float var3 = 0.5f;
        this.func_149676_a(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, 0.25f, 0.5f + var3);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149649_H();
    }

    public int getMaxGrowth(int meta) {
        return meta < 4 ? 3 : 8;
    }

    public int getStartGrowth(int meta) {
        return meta < 4 ? 0 : 4;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        float grow;
        int meta;
        this.func_149855_e(world, x, y, z);
        int light = world.func_72957_l(x, y, z);
        if (light >= 8 && this.getMaxGrowth(meta = world.func_72805_g(x, y, z)) != meta && random.nextInt((int)(60.0f / (grow = this.getGrowthRate(world, x, y, z, meta, light))) + 1) == 0) {
            world.func_72921_c(x, y, z, ++meta, 2);
        }
    }

    protected float getGrowthRate(World world, int x, int y, int z, int meta, int light) {
        float growth = 0.25f * (float)(light - 7);
        Block soil = world.func_147439_a(x, y - 1, z);
        if (world.func_72937_j(x, y, z) || !this.requiresSun(meta)) {
            growth += 2.0f;
        }
        if (soil != null && soil.isFertile(world, x, y - 1, z)) {
            growth *= 2.0f;
        }
        return 1.0f + growth;
    }

    boolean requiresSun(int meta) {
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        int meta;
        if (!world.field_72995_K && (meta = world.func_72805_g(x, y, z)) == 8) {
            world.func_147465_d(x, y, z, (Block)this, 6, 3);
            EntityItem entityitem = new EntityItem(world, player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v, new ItemStack(NContent.plantItem, 1, 3));
            world.func_72838_d((Entity)entityitem);
            entityitem.func_70100_b_(player);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 8) {
            if (world.field_72995_K) {
                return true;
            }
            world.func_147465_d(x, y, z, (Block)this, 6, 3);
            EntityItem entityitem = new EntityItem(world, player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v, new ItemStack(NContent.plantItem, 1, 3));
            world.func_72838_d((Entity)entityitem);
            entityitem.func_70100_b_(player);
            return true;
        }
        return false;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) > 3) {
            return 0.5f;
        }
        return this.field_149782_v;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("natura:" + this.textureNames[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[meta];
    }

    public int func_149645_b() {
        return CropRender.model;
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        if (meta == 3 || meta == 8) {
            return this.getCropItem(meta);
        }
        return this.getSeedItem(meta);
    }

    public Item getCropItem(int meta) {
        return NContent.plantItem;
    }

    public Item getSeedItem(int meta) {
        return NContent.seeds;
    }

    public int func_149692_a(int meta) {
        if (meta < 4) {
            return 0;
        }
        return 3;
    }

    public int seedDamageDropped(int meta) {
        if (meta < 4) {
            return 0;
        }
        return 1;
    }

    public void func_149690_a(World world, int par2, int par3, int par4, int par5, float par6, int par7) {
        super.func_149690_a(world, par2, par3, par4, par5, par6, 0);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (metadata == 3 || metadata == 8) {
            int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
            for (int i = 0; i < count; ++i) {
                Item id = this.func_149650_a(metadata, world.field_73012_v, 0);
                if (id == null) continue;
                ret.add(new ItemStack(id, 1, this.func_149692_a(metadata)));
            }
        }
        if (metadata >= 4) {
            ret.add(new ItemStack(this.getSeedItem(metadata), 1, this.seedDamageDropped(metadata)));
            if (metadata >= 5 && world.field_73012_v.nextBoolean()) {
                ret.add(new ItemStack(this.getSeedItem(metadata), 1, this.seedDamageDropped(metadata)));
            }
            if (metadata >= 7 && world.field_73012_v.nextBoolean()) {
                ret.add(new ItemStack(this.getSeedItem(metadata), 1, this.seedDamageDropped(metadata)));
            }
        } else {
            ret.add(new ItemStack(this.getSeedItem(metadata), 1, this.seedDamageDropped(metadata)));
            if (metadata >= 2 && world.field_73012_v.nextInt(3) == 0) {
                ret.add(new ItemStack(this.getSeedItem(metadata), 1, this.seedDamageDropped(metadata)));
            }
            if (metadata >= 3 && world.field_73012_v.nextInt(4) == 0) {
                ret.add(new ItemStack(this.getSeedItem(metadata), 1, this.seedDamageDropped(metadata)));
            }
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return this.getSeedItem(world.func_72805_g(x, y, z));
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return this.seedDamageDropped(world.func_72805_g(x, y, z));
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 3 || meta == 8) {
            return world.func_147439_a(x, y - 1, z) != Blocks.field_150350_a;
        }
        return super.func_149718_j(world, x, y, z);
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 4) {
            return 0;
        }
        return 4;
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isRemote) {
        int meta = world.func_72805_g(x, y, z);
        return this.getMaxGrowth(meta) != meta;
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (this.getMaxGrowth(meta) != meta) {
            int maxGrowth = this.getMaxGrowth(meta);
            int growthSpan = maxGrowth - this.getStartGrowth(meta);
            int output = random.nextInt(growthSpan) + 1 + meta;
            if (output > maxGrowth) {
                output = maxGrowth;
            }
            if (output != meta) {
                world.func_72921_c(x, y, z, output, 3);
            }
        }
    }
}

