/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.core;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import remoteio.common.lib.DimensionalCoords;

public class ChannelRegistry {
    private Map<Integer, DimensionalCoords> channelDataMap = Maps.newHashMap();
    private Set<Integer> dirtyChannels = Sets.newHashSet();

    public ChannelRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public DimensionalCoords getChannelData(int channel) {
        return this.channelDataMap.get(channel);
    }

    public void setChannelData(int channel, DimensionalCoords coords) {
        this.channelDataMap.put(channel, coords);
        this.dirtyChannels.add(channel);
    }

    public boolean pollDirty(int channel) {
        if (this.dirtyChannels.contains(channel)) {
            this.dirtyChannels.remove(channel);
            return true;
        }
        return false;
    }

    private File getFile(ISaveHandler saveHandler) {
        return new File(saveHandler.func_75765_b(), "channels.rio");
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_73011_w.field_76574_g != 0) {
            return;
        }
        File file = this.getFile(event.world.func_72860_G());
        if (!file.exists()) {
            return;
        }
        this.channelDataMap.clear();
        this.dirtyChannels.clear();
        try {
            NBTTagCompound nbtTagCompound = CompressedStreamTools.func_74797_a((File)file);
            if (nbtTagCompound != null) {
                NBTTagList nbtTagList = nbtTagCompound.func_150295_c("data", 10);
                for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                    NBTTagCompound dataTag = nbtTagList.func_150305_b(i);
                    this.channelDataMap.put(dataTag.func_74762_e("channel"), DimensionalCoords.fromNBT(dataTag.func_74775_l("coords")));
                    this.dirtyChannels.add(dataTag.func_74762_e("channel"));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (event.world.field_73011_w.field_76574_g != 0) {
            return;
        }
        File file = this.getFile(event.world.func_72860_G());
        try {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            NBTTagList nbtTagList = new NBTTagList();
            for (Map.Entry<Integer, DimensionalCoords> entry : this.channelDataMap.entrySet()) {
                NBTTagCompound dataTag = new NBTTagCompound();
                dataTag.func_74768_a("channel", entry.getKey().intValue());
                NBTTagCompound coordTag = new NBTTagCompound();
                entry.getValue().writeToNBT(coordTag);
                dataTag.func_74782_a("coords", (NBTBase)coordTag);
                nbtTagList.func_74742_a((NBTBase)dataTag);
            }
            nbtTagCompound.func_74782_a("data", (NBTBase)nbtTagList);
            CompressedStreamTools.func_74795_b((NBTTagCompound)nbtTagCompound, (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

