/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.IMachine;
import binnie.core.machines.inventory.ComponentInventory;
import binnie.core.machines.inventory.IInventoryMachine;
import binnie.core.machines.inventory.IInventorySlots;
import binnie.core.machines.inventory.InventorySlot;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ComponentInventorySlots
extends ComponentInventory
implements IInventoryMachine,
IInventorySlots {
    private Map<Integer, InventorySlot> inventory = new LinkedHashMap<Integer, InventorySlot>();

    public ComponentInventorySlots(IMachine machine) {
        super(machine);
    }

    public int func_70302_i_() {
        int size = 0;
        for (Integer index : this.inventory.keySet()) {
            size = Math.max(size, index + 1);
        }
        return size;
    }

    public ItemStack func_70301_a(int index) {
        if (this.inventory.containsKey(index)) {
            return this.inventory.get(index).getContent();
        }
        return null;
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (this.inventory.containsKey(index)) {
            ItemStack stack = this.inventory.get(index).decrStackSize(amount);
            this.func_70296_d();
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        if (this.inventory.containsKey(index) && (itemStack == null || this.inventory.get(index).isValid(itemStack))) {
            this.inventory.get(index).setContent(itemStack);
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("inventory")) {
            NBTTagList inventoryNBT = nbttagcompound.func_150295_c("inventory", 10);
            for (int i = 0; i < inventoryNBT.func_74745_c(); ++i) {
                NBTTagCompound slotNBT = inventoryNBT.func_150305_b(i);
                int index = slotNBT.func_74762_e("id");
                if (slotNBT.func_74764_b("Slot")) {
                    index = slotNBT.func_74771_c("Slot") & 0xFF;
                }
                if (!this.inventory.containsKey(index)) continue;
                this.inventory.get(index).readFromNBT(slotNBT);
            }
        }
        this.func_70296_d();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList inventoryNBT = new NBTTagList();
        for (Map.Entry<Integer, InventorySlot> entry : this.inventory.entrySet()) {
            NBTTagCompound slotNBT = new NBTTagCompound();
            slotNBT.func_74768_a("id", entry.getKey().intValue());
            entry.getValue().writeToNBT(slotNBT);
            inventoryNBT.func_74742_a((NBTBase)slotNBT);
        }
        nbttagcompound.func_74782_a("inventory", (NBTBase)inventoryNBT);
    }

    @Override
    public InventorySlot addSlot(int index, String unlocalizedName) {
        this.inventory.put(index, new InventorySlot(index, unlocalizedName));
        return this.getSlot(index);
    }

    @Override
    public InventorySlot[] addSlotArray(int[] indexes, String unlocalizedName) {
        for (int k : indexes) {
            this.addSlot(k, unlocalizedName);
        }
        return this.getSlots(indexes);
    }

    @Override
    public InventorySlot getSlot(int index) {
        if (this.inventory.containsKey(index)) {
            return this.inventory.get(index);
        }
        return null;
    }

    @Override
    public InventorySlot[] getAllSlots() {
        return this.inventory.values().toArray(new InventorySlot[0]);
    }

    @Override
    public InventorySlot[] getSlots(int[] indexes) {
        ArrayList<InventorySlot> list = new ArrayList<InventorySlot>();
        for (int i : indexes) {
            if (this.getSlot(i) == null) continue;
            list.add(this.getSlot(i));
        }
        return list.toArray(new InventorySlot[0]);
    }

    @Override
    public boolean isReadOnly(int slot) {
        InventorySlot iSlot = this.getSlot(slot);
        return iSlot == null || iSlot.isReadOnly();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        InventorySlot iSlot = this.getSlot(slot);
        return iSlot != null && iSlot.isValid(itemStack) && !this.isReadOnly(slot);
    }

    @Override
    public void onDestruction() {
        for (InventorySlot slot : this.inventory.values()) {
            ItemStack stack = slot.getContent();
            if (slot.isRecipe() || stack == null) continue;
            IMachine machine = this.getMachine();
            World world = machine.getWorld();
            Random rand = world.field_73012_v;
            TileEntity tileEntity = machine.getTileEntity();
            float xOffset = rand.nextFloat() * 0.8f + 0.1f;
            float yOffset = rand.nextFloat() * 0.8f + 0.1f;
            float zOffset = rand.nextFloat() * 0.8f + 0.1f;
            if (stack.field_77994_a == 0) {
                stack.field_77994_a = 1;
            }
            EntityItem entityItem = new EntityItem(world, (double)((float)tileEntity.field_145851_c + xOffset), (double)((float)tileEntity.field_145848_d + yOffset), (double)((float)tileEntity.field_145849_e + zOffset), stack.func_77946_l());
            float accel = 0.05f;
            entityItem.field_70159_w = (float)rand.nextGaussian() * accel;
            entityItem.field_70181_x = (float)rand.nextGaussian() * accel + 0.2f;
            entityItem.field_70179_y = (float)rand.nextGaussian() * accel;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public int[] func_94128_d(int var1) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (InventorySlot slot : this.inventory.values()) {
            if (!slot.canInsert() && !slot.canExtract()) continue;
            slots.add(slot.getIndex());
        }
        int[] ids = new int[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            ids[i] = (Integer)slots.get(i);
        }
        return ids;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int direction) {
        return this.func_94041_b(slot, itemstack) && this.getSlot(slot).canInsert(ForgeDirection.getOrientation((int)direction));
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int direction) {
        return this.getSlot(slot).canExtract(ForgeDirection.getOrientation((int)direction));
    }
}

