/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.utils.world;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Iterator;
import java.util.List;
import makeo.gadomancy.common.blocks.tiles.TileOverrideEldritchLock;
import makeo.gadomancy.common.utils.world.TCMazeHandler;
import makeo.gadomancy.common.utils.world.fake.FakeWorldTCGeneration;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.EntityPermanentItem;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;
import thaumcraft.common.tiles.TileCrystal;
import thaumcraft.common.tiles.TileEldritchCrabSpawner;
import thaumcraft.common.tiles.TileEldritchLock;
import thaumcraft.common.tiles.TileEldritchNothing;

public class ChunkProviderTCOuter
implements IChunkProvider {
    private static final Block[] blockArr = new Block[32768];
    private static final byte[] metaArr = new byte[blockArr.length];
    private static final byte[] biomeArr = new byte[256];
    private World worldObj;

    public ChunkProviderTCOuter(World p_i2006_1_, long p_i2006_2_, boolean p_i2006_4_) {
        this.worldObj = p_i2006_1_;
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    public Chunk func_73154_d(int x, int z) {
        Chunk chunk;
        long key = (long)x | (long)z << 32;
        if (TCMazeHandler.GEN.chunks.containsKey(key)) {
            Object te;
            FakeWorldTCGeneration.ChunkBuffer buf = TCMazeHandler.GEN.chunks.get(key);
            for (int i = 0; i < buf.blockData.length; ++i) {
                if (buf.blockData[i] != ConfigBlocks.blockEldritchNothing) continue;
                ConfigBlocks.blockEldritchNothing.func_149695_a((World)TCMazeHandler.GEN, i >> 11 & 0xF | x << 4, i & 0x7F, i >> 7 & 0xF | z << 4, ConfigBlocks.blockEldritchNothing);
            }
            TCMazeHandler.GEN.chunks.remove(key);
            chunk = new Chunk(this.worldObj, buf.blockData, buf.metaBuffer, x, z);
            byte[] abyte = chunk.func_76605_m();
            System.arraycopy(biomeArr, 0, abyte, 0, biomeArr.length);
            for (Integer[] pos : buf.tiles) {
                te = buf.blockData[pos[3]].createTileEntity(this.worldObj, (int)buf.metaBuffer[pos[3]]);
                if (te == null) continue;
                if (te instanceof TileEldritchLock) {
                    te = new TileOverrideEldritchLock();
                }
                this.worldObj.addTileEntity((TileEntity)te);
                chunk.func_150812_a(pos[0] & 0xF, pos[1].intValue(), pos[2] & 0xF, (TileEntity)te);
                ((TileEntity)te).field_145847_g = buf.metaBuffer[pos[3]];
            }
            Iterator<ChunkCoordinates> it = TCMazeHandler.GEN.gettedTE.keySet().iterator();
            while (it.hasNext()) {
                NBTTagCompound compound;
                ChunkCoordinates cc = it.next();
                te = TCMazeHandler.GEN.gettedTE.get(cc);
                if (((TileEntity)te).field_145851_c >> 4 != x || ((TileEntity)te).field_145849_e >> 4 != z) continue;
                ChunkPosition pos = new ChunkPosition(((TileEntity)te).field_145851_c & 0xF, ((TileEntity)te).field_145848_d, ((TileEntity)te).field_145849_e & 0xF);
                if (!chunk.field_150816_i.containsKey(pos)) {
                    System.out.println("INVALID TE at: " + ((TileEntity)te).field_145851_c + ", " + ((TileEntity)te).field_145848_d + ", " + ((TileEntity)te).field_145849_e + " --- Not found in its parent chunk " + chunk.field_76635_g + ", " + chunk.field_76647_h);
                    throw new IllegalStateException("INVALID TE");
                }
                TileEntity correspondingTE = (TileEntity)chunk.field_150816_i.get(pos);
                if (te instanceof TileEntityMobSpawner) {
                    if (!(correspondingTE instanceof TileEntityMobSpawner)) {
                        System.out.println("DATA INCONSISTENCY - TE at " + ((TileEntity)te).field_145851_c + ", " + ((TileEntity)te).field_145848_d + ", " + ((TileEntity)te).field_145849_e + " EXPECTED: " + te.getClass().getSimpleName() + " GIVEN " + correspondingTE.getClass().getSimpleName());
                        throw new IllegalStateException();
                    }
                    ((TileEntityMobSpawner)correspondingTE).func_145881_a().func_98272_a(((TileEntityMobSpawner)te).func_145881_a().func_98276_e());
                } else if (te instanceof TileEldritchLock) {
                    if (!(correspondingTE instanceof TileEldritchLock)) {
                        System.out.println("DATA INCONSISTENCY - TE at " + ((TileEntity)te).field_145851_c + ", " + ((TileEntity)te).field_145848_d + ", " + ((TileEntity)te).field_145849_e + " EXPECTED: " + te.getClass().getSimpleName() + " GIVEN " + correspondingTE.getClass().getSimpleName());
                        throw new IllegalStateException();
                    }
                    compound = new NBTTagCompound();
                    compound.func_74774_a("facing", ((TileEldritchLock)te).getFacing());
                    compound.func_74777_a("count", (short)-1);
                    ((TileEldritchLock)correspondingTE).readCustomNBT(compound);
                } else if (te instanceof TileCrystal) {
                    if (!(correspondingTE instanceof TileCrystal)) {
                        System.out.println("DATA INCONSISTENCY - TE at " + ((TileEntity)te).field_145851_c + ", " + ((TileEntity)te).field_145848_d + ", " + ((TileEntity)te).field_145849_e + " EXPECTED: " + te.getClass().getSimpleName() + " GIVEN " + correspondingTE.getClass().getSimpleName());
                        throw new IllegalStateException();
                    }
                    ((TileCrystal)correspondingTE).orientation = ((TileCrystal)te).orientation;
                } else if (te instanceof TileEldritchCrabSpawner) {
                    if (!(correspondingTE instanceof TileEldritchCrabSpawner)) {
                        System.out.println("DATA INCONSISTENCY - TE at " + ((TileEntity)te).field_145851_c + ", " + ((TileEntity)te).field_145848_d + ", " + ((TileEntity)te).field_145849_e + " EXPECTED: " + te.getClass().getSimpleName() + " GIVEN " + correspondingTE.getClass().getSimpleName());
                        throw new IllegalStateException();
                    }
                    compound = new NBTTagCompound();
                    compound.func_74774_a("facing", ((TileEldritchCrabSpawner)te).getFacing());
                    ((TileEldritchCrabSpawner)correspondingTE).readCustomNBT(compound);
                } else if (te instanceof TileEldritchNothing) {
                    if (!(correspondingTE instanceof TileEldritchNothing)) {
                        System.out.println("DATA INCONSISTENCY - TE at " + ((TileEntity)te).field_145851_c + ", " + ((TileEntity)te).field_145848_d + ", " + ((TileEntity)te).field_145849_e + " EXPECTED: " + te.getClass().getSimpleName() + " GIVEN " + correspondingTE.getClass().getSimpleName());
                        throw new IllegalStateException();
                    }
                } else {
                    throw new IllegalStateException("Unexpected TileEntity: " + te);
                }
                it.remove();
            }
            Iterator<Object> itEntity = TCMazeHandler.GEN.bufferedEntities.iterator();
            while (itEntity.hasNext()) {
                Object bufE = itEntity.next();
                if (bufE instanceof FakeWorldTCGeneration.EntityPermItem) {
                    FakeWorldTCGeneration.EntityPermItem i = (FakeWorldTCGeneration.EntityPermItem)bufE;
                    if ((int)i.x >> 4 != x || (int)i.z >> 4 != z) continue;
                    EntityPermanentItem item = new EntityPermanentItem(this.worldObj, i.x, i.y, i.z, i.buffItemStack);
                    item.field_70159_w = 0.0;
                    item.field_70181_x = 0.0;
                    item.field_70179_y = 0.0;
                    chunk.func_76612_a((Entity)item);
                    itEntity.remove();
                    continue;
                }
                if (bufE instanceof FakeWorldTCGeneration.EntityGuardianBuf) {
                    FakeWorldTCGeneration.EntityGuardianBuf b = (FakeWorldTCGeneration.EntityGuardianBuf)bufE;
                    if ((int)b.x >> 4 != x || (int)b.z >> 4 != z) continue;
                    EntityEldritchGuardian guardian = new EntityEldritchGuardian(this.worldObj);
                    guardian.func_70107_b(b.x, b.y, b.z);
                    guardian.func_110171_b(b.coordinates.field_71574_a, b.coordinates.field_71572_b, b.coordinates.field_71573_c, (int)b.dst);
                    chunk.func_76612_a((Entity)guardian);
                    itEntity.remove();
                    continue;
                }
                throw new IllegalStateException("Unexpected Entity: " + bufE);
            }
            for (int cX = 0; cX < 16; ++cX) {
                for (int cY = 50; cY < 64; ++cY) {
                    for (int cZ = 0; cZ < 16; ++cZ) {
                        int lightKey = ((cX & 0xF) << 4 | cZ & 0xF) << 7 | cY;
                        int lightVal = buf.lightData[lightKey];
                        if (lightVal <= 0) continue;
                        chunk.func_76633_a(EnumSkyBlock.Block, cX, cY, cZ, lightVal);
                    }
                }
            }
        } else {
            Block[] ablock = new Block[blockArr.length];
            System.arraycopy(blockArr, 0, ablock, 0, blockArr.length);
            byte[] meta = new byte[metaArr.length];
            System.arraycopy(metaArr, 0, meta, 0, metaArr.length);
            chunk = new Chunk(this.worldObj, ablock, meta, x, z);
            byte[] abyte = chunk.func_76605_m();
            System.arraycopy(biomeArr, 0, abyte, 0, biomeArr.length);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
        return true;
    }

    public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        BlockFalling.field_149832_M = true;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(p_73153_1_, this.worldObj, this.worldObj.field_73012_v, p_73153_2_, p_73153_3_, false));
        int k = p_73153_2_ * 16;
        int l = p_73153_3_ * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(k + 16, l + 16);
        biomegenbase.func_76728_a(this.worldObj, this.worldObj.field_73012_v, k, l);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(p_73153_1_, this.worldObj, this.worldObj.field_73012_v, p_73153_2_, p_73153_3_, false));
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return false;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType p_73155_1_, int p_73155_2_, int p_73155_3_, int p_73155_4_) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(p_73155_2_, p_73155_4_);
        return biomegenbase.func_76747_a(p_73155_1_);
    }

    public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int p_82695_1_, int p_82695_2_) {
    }

    public static int getKey(int x, int y, int z) {
        return (x << 4 | z) << 7 | y;
    }

    static {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 127; y >= 0; --y) {
                    int index = (x << 4 | z) << 7 | y;
                    ChunkProviderTCOuter.blockArr[index] = null;
                    ChunkProviderTCOuter.metaArr[index] = 0;
                }
            }
        }
        for (int i = 0; i < biomeArr.length; ++i) {
            ChunkProviderTCOuter.biomeArr[i] = (byte)ThaumcraftWorldGenerator.biomeEldritchLands.field_76756_M;
        }
    }
}

