/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;

public class Translation
extends Transformation<Translation, ITransformable.Translate> {
    protected float fromX;
    protected float fromY;
    protected float fromZ;
    protected float toX;
    protected float toY;
    protected float toZ;

    public Translation(float x, float y, float z) {
        this.to(x, y, z);
    }

    public Translation(float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        this.from(fromX, fromY, fromZ);
        this.to(toX, toY, toZ);
    }

    public Translation from(float x, float y, float z) {
        this.fromX = x;
        this.fromY = y;
        this.fromZ = z;
        return this;
    }

    public Translation to(float x, float y, float z) {
        this.toX = x;
        this.toY = y;
        this.toZ = z;
        return this;
    }

    @Override
    protected void doTransform(ITransformable.Translate transformable, float comp) {
        float fromX = this.reversed ? this.toX : this.fromX;
        float toX = this.reversed ? this.fromX : this.toX;
        float fromY = this.reversed ? this.toY : this.fromY;
        float toY = this.reversed ? this.fromY : this.toY;
        float fromZ = this.reversed ? this.toZ : this.fromZ;
        float toZ = this.reversed ? this.fromZ : this.toZ;
        transformable.translate(fromX + (toX - fromX) * comp, fromY + (toY - fromY) * comp, fromZ + (toZ - fromZ) * comp);
    }
}

