/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.api.definitions.IBlockDefinition;
import appeng.util.Platform;
import appeng.worldgen.meteorite.IMeteoriteWorld;
import appeng.worldgen.meteorite.MeteoriteBlockPutter;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class Fallout {
    private final MeteoriteBlockPutter putter;
    private final IBlockDefinition skyStoneDefinition;

    public Fallout(MeteoriteBlockPutter putter, IBlockDefinition skyStoneDefinition) {
        this.putter = putter;
        this.skyStoneDefinition = skyStoneDefinition;
    }

    public int adjustCrater() {
        return 0;
    }

    public void getRandomFall(double random, IMeteoriteWorld w, int x, int y, int z) {
        if (random > 0.9) {
            this.putter.put(w, x, y, z, Blocks.field_150348_b);
        } else if (random > 0.8) {
            this.putter.put(w, x, y, z, Blocks.field_150347_e);
        } else if (random > 0.7) {
            this.putter.put(w, x, y, z, Blocks.field_150346_d);
        } else {
            this.putter.put(w, x, y, z, Blocks.field_150351_n);
        }
    }

    public void getRandomInset(double random, IMeteoriteWorld w, int x, int y, int z) {
        if (random > 0.9) {
            this.putter.put(w, x, y, z, Blocks.field_150347_e);
        } else if (random > 0.8) {
            this.putter.put(w, x, y, z, Blocks.field_150348_b);
        } else if (random > 0.7) {
            this.putter.put(w, x, y, z, (Block)Blocks.field_150349_c);
        } else if (random > 0.6) {
            for (Block skyStoneBlock : this.skyStoneDefinition.maybeBlock().asSet()) {
                this.putter.put(w, x, y, z, skyStoneBlock);
            }
        } else if (random > 0.5) {
            this.putter.put(w, x, y, z, Blocks.field_150351_n);
        } else {
            this.putter.put(w, x, y, z, Platform.AIR_BLOCK);
        }
    }
}

