/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen;

import appeng.api.features.IWorldGen;
import appeng.core.AEConfig;
import appeng.core.features.registries.WorldGenRegistry;
import appeng.core.worlddata.WorldData;
import appeng.hooks.TickHandler;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import appeng.worldgen.MeteoritePlacer;
import appeng.worldgen.meteorite.ChunkOnly;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public final class MeteoriteWorldGen
implements IWorldGenerator {
    public void generate(Random rng, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (WorldGenRegistry.INSTANCE.isWorldGenEnabled(IWorldGen.WorldGenType.Meteorites, world)) {
            int gridCellSize = Math.max(8, AEConfig.instance.minMeteoriteDistance);
            int gridCellMargin = Math.max(1, gridCellSize / 10);
            int gridX = Math.floorDiv(chunkX << 4, gridCellSize);
            int gridZ = Math.floorDiv(chunkZ << 4, gridCellSize);
            Platform.seedFromGrid(rng, world.func_72905_C(), gridX, gridZ);
            boolean spawnSurfaceMeteor = rng.nextDouble() < AEConfig.instance.meteoriteSpawnChance;
            int meteorX = gridX * gridCellSize + rng.nextInt(gridCellSize - 2 * gridCellMargin) + gridCellMargin;
            int meteorZ = gridZ * gridCellSize + rng.nextInt(gridCellSize - 2 * gridCellMargin) + gridCellMargin;
            int meteorDepth = 180 + rng.nextInt(20);
            int meteorChunkX = meteorX >> 4;
            int meteorChunkZ = meteorZ >> 4;
            long meteorSeed = rng.nextLong();
            while (meteorSeed == 0L) {
                meteorSeed = rng.nextLong();
            }
            if (meteorChunkX == chunkX && meteorChunkZ == chunkZ) {
                TickHandler.INSTANCE.addCallable(world, new ExistingMeteoriteSpawn(chunkX, chunkZ));
                TickHandler.INSTANCE.addCallable(world, new MeteoriteSpawn(meteorX, spawnSurfaceMeteor ? meteorDepth : 128, meteorZ, meteorSeed));
            } else {
                TickHandler.INSTANCE.addCallable(world, new ExistingMeteoriteSpawn(chunkX, chunkZ));
            }
        } else {
            WorldData.instance().compassData().service().updateArea(world, chunkX, chunkZ);
        }
    }

    private static final class ExistingMeteoriteSpawn
    implements IWorldCallable<Object> {
        private final int chunkX;
        private final int chunkZ;

        public ExistingMeteoriteSpawn(int chunkX, int chunkZ) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }

        private Iterable<NBTTagCompound> getNearByMeteorites(World w, int chunkX, int chunkZ) {
            return WorldData.instance().spawnData().getNearByMeteorites(w.field_73011_w.field_76574_g, chunkX, chunkZ);
        }

        @Override
        public Object call(World world) throws Exception {
            for (NBTTagCompound data : this.getNearByMeteorites(world, this.chunkX, this.chunkZ)) {
                MeteoritePlacer mp = new MeteoritePlacer(new ChunkOnly(world, this.chunkX, this.chunkZ), data);
                mp.spawnMeteorite();
            }
            WorldData.instance().spawnData().setGenerated(world.field_73011_w.field_76574_g, this.chunkX, this.chunkZ);
            WorldData.instance().compassData().service().updateArea(world, this.chunkX, this.chunkZ);
            return null;
        }
    }

    private static final class MeteoriteSpawn
    implements IWorldCallable<Object> {
        private final int x;
        private final int z;
        private final int depth;
        private final long seed;

        public MeteoriteSpawn(int x, int depth, int z, long seed) {
            this.x = x;
            this.z = z;
            this.depth = depth;
            this.seed = seed;
        }

        private boolean tryMeteorite(World w) {
            int depth = this.depth;
            for (int tries = 0; tries < 20; ++tries) {
                MeteoritePlacer mp = new MeteoritePlacer(new ChunkOnly(w, this.x >> 4, this.z >> 4), this.seed, this.x, depth, this.z);
                if (mp.spawnMeteoriteCenter()) {
                    int px = this.x >> 4;
                    int pz = this.z >> 4;
                    for (int cx = px - 6; cx < px + 6; ++cx) {
                        for (int cz = pz - 6; cz < pz + 6; ++cz) {
                            if (!w.func_72863_F().func_73149_a(cx, cz) || px == cx && pz == cz || !WorldData.instance().spawnData().hasGenerated(w.field_73011_w.field_76574_g, cx, cz)) continue;
                            MeteoritePlacer mp2 = new MeteoritePlacer(new ChunkOnly(w, cx, cz), mp.getSettings());
                            mp2.spawnMeteorite();
                        }
                    }
                    return true;
                }
                if ((depth -= 15) >= 40) continue;
                return false;
            }
            return false;
        }

        @Override
        public Object call(World world) throws Exception {
            int chunkX = this.x >> 4;
            int chunkZ = this.z >> 4;
            this.tryMeteorite(world);
            WorldData.instance().spawnData().setGenerated(world.field_73011_w.field_76574_g, chunkX, chunkZ);
            WorldData.instance().compassData().service().updateArea(world, chunkX, chunkZ);
            return null;
        }
    }
}

