/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCompassRequest;
import appeng.hooks.CompassResult;
import java.util.HashMap;
import java.util.Iterator;

public class CompassManager {
    public static final CompassManager INSTANCE = new CompassManager();
    private final HashMap<CompassRequest, CompassResult> requests = new HashMap();

    public void postResult(long attunement, int x, int y, int z, CompassResult result) {
        CompassRequest r = new CompassRequest(attunement, x, y, z);
        this.requests.put(r, result);
    }

    public CompassResult getCompassDirection(long attunement, int x, int y, int z) {
        long now = System.currentTimeMillis();
        Iterator<CompassResult> i = this.requests.values().iterator();
        while (i.hasNext()) {
            CompassResult res = i.next();
            long diff = now - res.getTime();
            if (diff <= 20000L) continue;
            i.remove();
        }
        CompassRequest r = new CompassRequest(attunement, x, y, z);
        CompassResult res = this.requests.get(r);
        if (res == null) {
            res = new CompassResult(false, true, 0.0);
            this.requests.put(r, res);
            this.requestUpdate(r);
        } else if (now - res.getTime() > 3000L && !res.isRequested()) {
            res.setRequested(true);
            this.requestUpdate(r);
        }
        return res;
    }

    private void requestUpdate(CompassRequest r) {
        NetworkHandler.instance.sendToServer(new PacketCompassRequest(r.attunement, r.cx, r.cz, r.cdy));
    }

    private static class CompassRequest {
        private final int hash;
        private final long attunement;
        private final int cx;
        private final int cdy;
        private final int cz;

        public CompassRequest(long attunement, int x, int y, int z) {
            this.attunement = attunement;
            this.cx = x >> 4;
            this.cdy = y >> 5;
            this.cz = z >> 4;
            this.hash = Integer.valueOf(this.cx).hashCode() ^ Integer.valueOf(this.cdy).hashCode() ^ Integer.valueOf(this.cz).hashCode() ^ Long.valueOf(attunement).hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompassRequest other = (CompassRequest)obj;
            return this.attunement == other.attunement && this.cx == other.cx && this.cdy == other.cdy && this.cz == other.cz;
        }
    }
}

