/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.recipes.IRecipeHandler;
import appeng.core.AELog;
import appeng.recipes.CustomRecipeConfig;
import appeng.recipes.loader.ConfigLoader;
import appeng.recipes.loader.JarLoader;
import appeng.recipes.loader.RecipeResourceCopier;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;

public class RecipeLoader
implements Runnable {
    private static final String ASSETS_RECIPE_PATH = "/assets/appliedenergistics2/recipes/";
    @Nonnull
    private final IRecipeHandler handler;
    @Nonnull
    private final CustomRecipeConfig config;
    @Nonnull
    private final File recipeDirectory;

    public RecipeLoader(@Nonnull File recipeDirectory, @Nonnull CustomRecipeConfig config, @Nonnull IRecipeHandler handler) {
        this.recipeDirectory = (File)Preconditions.checkNotNull((Object)recipeDirectory);
        Preconditions.checkArgument((!recipeDirectory.isFile() ? 1 : 0) != 0);
        this.config = (CustomRecipeConfig)Preconditions.checkNotNull((Object)config);
        this.handler = (IRecipeHandler)Preconditions.checkNotNull((Object)handler);
    }

    @Override
    public final void run() {
        if (this.config.isEnabled()) {
            RecipeResourceCopier copier = new RecipeResourceCopier("assets/appliedenergistics2/recipes/");
            File generatedRecipesDir = new File(this.recipeDirectory, "generated");
            File userRecipesDir = new File(this.recipeDirectory, "user");
            try {
                FileUtils.forceMkdir((File)generatedRecipesDir);
                FileUtils.forceMkdir((File)userRecipesDir);
                FileUtils.cleanDirectory((File)generatedRecipesDir);
                copier.copyTo(".recipe", generatedRecipesDir);
                copier.copyTo(".html", this.recipeDirectory);
                this.handler.parseRecipes(new ConfigLoader(generatedRecipesDir, userRecipesDir), "index.recipe");
            }
            catch (IOException | URISyntaxException e) {
                AELog.debug(e);
                this.handler.parseRecipes(new JarLoader(ASSETS_RECIPE_PATH), "index.recipe");
            }
        } else {
            this.handler.parseRecipes(new JarLoader(ASSETS_RECIPE_PATH), "index.recipe");
        }
    }
}

