/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.compatibility.gtpp;

import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.IEMStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMTransformationRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.EMAtomDefinition;
import gregtech.api.enums.OrePrefixes;
import java.lang.reflect.Method;
import net.minecraftforge.fluids.FluidStack;

public class GtppAtomLoader {
    private Class<?> ELEMENT;
    private Object ELEMENT_INSTANCE;
    private Method getUnlocalizedName;
    private Method getFluid;
    private Method generate;

    private String getUnlocalizedName(String elementName) {
        try {
            return (String)this.getUnlocalizedName.invoke(this.ELEMENT.getField(elementName).get(this.ELEMENT_INSTANCE), new Object[0]);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private FluidStack getFluid(String elementName, int fluidAmount) {
        try {
            return (FluidStack)this.getFluid.invoke(this.ELEMENT.getField(elementName).get(this.ELEMENT_INSTANCE), fluidAmount);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private void generate(String elementName, boolean generateAll, boolean generateBlastRecipes) {
        try {
            this.generate.invoke(null, this.ELEMENT.getField(elementName).get(this.ELEMENT_INSTANCE), generateAll, generateBlastRecipes);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void setTransformations(EMTransformationRegistry transformationInfo) {
        try {
            this.ELEMENT = Class.forName("gtPlusPlus.core.material.ELEMENT");
            this.ELEMENT_INSTANCE = this.ELEMENT.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Class<?> clazz = Class.forName("gtPlusPlus.core.material.Material");
            this.getUnlocalizedName = clazz.getMethod("getUnlocalizedName", new Class[0]);
            try {
                this.getFluid = clazz.getMethod("getFluidStack", Integer.TYPE);
            }
            catch (Exception e) {
                this.getFluid = clazz.getMethod("getFluid", Integer.TYPE);
            }
            clazz = Class.forName("gtPlusPlus.core.material.MaterialGenerator");
            this.generate = clazz.getMethod("generate", Class.forName("gtPlusPlus.core.material.Material"), Boolean.TYPE, Boolean.TYPE);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        transformationInfo.addFluid(new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(10), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), this.getFluid("NEON", 144));
        this.generate("GERMANIUM", true, true);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(32), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("GERMANIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(34), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("SELENIUM"), 1);
        transformationInfo.addFluid(new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(35), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), this.getFluid("BROMINE", 144));
        transformationInfo.addFluid(new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(36), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), this.getFluid("KRYPTON", 144));
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(40), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("ZIRCONIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(43), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("TECHNETIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(44), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("RUTHENIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(45), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("RHODIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(53), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("IODINE"), 1);
        transformationInfo.addFluid(new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(54), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), this.getFluid("XENON", 144));
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(72), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("HAFNIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(75), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("RHENIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(81), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("THALLIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(84), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("POLONIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(85), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("ASTATINE"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(87), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("FRANCIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(88), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("RADIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(89), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("ACTINIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(91), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("PROTACTINIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(93), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("NEPTUNIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(96), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("CURIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(97), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("BERKELIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(98), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("CALIFORNIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(99), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("EINSTEINIUM"), 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(100), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, this.getUnlocalizedName("FERMIUM"), 1);
    }
}

