/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.api.IElevatorBlock;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityElevatorRotating;
import openmods.block.BlockRotationMode;
import openmods.utils.ColorUtils;

public class BlockElevatorRotating
extends OpenBlock
implements IElevatorBlock {
    public BlockElevatorRotating() {
        super(Material.field_151576_e);
        this.setRotationMode(BlockRotationMode.FOUR_DIRECTIONS);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister registry) {
        super.func_149651_a(registry);
        this.setTexture(ForgeDirection.UP, registry.func_94245_a("openblocks:elevator_rot"));
    }

    private static ColorUtils.ColorMeta getColorMeta(IBlockAccess world, int x, int y, int z) {
        TileEntityElevatorRotating te = (TileEntityElevatorRotating)((Object)BlockElevatorRotating.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityElevatorRotating.class));
        return te != null ? te.getColor() : ColorUtils.ColorMeta.WHITE;
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return BlockElevatorRotating.getColorMeta((IBlockAccess)world, (int)x, (int)y, (int)z).rgb;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int damage) {
        return ColorUtils.vanillaBlockToColor((int)damage).rgb;
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        ColorUtils.ColorMeta next;
        ColorUtils.ColorMeta current;
        if (world.field_72995_K) {
            return false;
        }
        TileEntityElevatorRotating te = (TileEntityElevatorRotating)((Object)BlockElevatorRotating.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityElevatorRotating.class));
        if (te != null && (current = te.getColor()) != (next = ColorUtils.vanillaBlockToColor((int)colour))) {
            te.setColor(next);
            return true;
        }
        return false;
    }

    @Override
    public int getColor(World world, int x, int y, int z) {
        return BlockElevatorRotating.getColorMeta((IBlockAccess)world, (int)x, (int)y, (int)z).vanillaBlockId;
    }

    @Override
    public IElevatorBlock.PlayerRotation getRotation(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        ForgeDirection rot = this.getOrientation(meta).north();
        switch (rot) {
            case NORTH: {
                return IElevatorBlock.PlayerRotation.NORTH;
            }
            case SOUTH: {
                return IElevatorBlock.PlayerRotation.SOUTH;
            }
            case WEST: {
                return IElevatorBlock.PlayerRotation.WEST;
            }
            case EAST: {
                return IElevatorBlock.PlayerRotation.EAST;
            }
        }
        return IElevatorBlock.PlayerRotation.NONE;
    }
}

