/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon;

import chylex.hee.block.BlockRavagedBrick;
import chylex.hee.init.BlockList;
import chylex.hee.system.collections.WeightedList;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.collections.weight.ObjectWeightPair;
import chylex.hee.system.util.CollectionUtil;
import chylex.hee.tileentity.TileEntityCustomSpawner;
import chylex.hee.tileentity.spawner.LouseRavagedSpawnerLogic;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonDir;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonElement;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.RavagedDungeonLoot;
import chylex.hee.world.structure.util.Facing;
import chylex.hee.world.structure.util.pregen.ITileEntityGenerator;
import chylex.hee.world.structure.util.pregen.LargeStructureWorld;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFlowerPot;

public final class RavagedDungeonPlacer
implements ITileEntityGenerator {
    private static final byte radEntrance = 2;
    private static final byte radHallway = 2;
    private static final byte radRoom = 7;
    private final byte hallHeight;
    private byte level;
    private static final WeightedList<ObjectWeightPair<EnumDescendDesign>> descendDesignList = new WeightedList((IWeightProvider[])new ObjectWeightPair[]{ObjectWeightPair.of(EnumDescendDesign.PILLARS_WITH_SPAWNER, 50), ObjectWeightPair.of(EnumDescendDesign.FENCE_LIGHTS, 42), ObjectWeightPair.of(EnumDescendDesign.GOO_CORNERS, 35), ObjectWeightPair.of(EnumDescendDesign.CORNER_LIGHTS, 25)});
    private static final WeightedList<ObjectWeightPair<EnumHallwayDesign>> hallwayDesignList = new WeightedList((IWeightProvider[])new ObjectWeightPair[]{ObjectWeightPair.of(EnumHallwayDesign.NONE, 88), ObjectWeightPair.of(EnumHallwayDesign.DEAD_END_CHEST, 45), ObjectWeightPair.of(EnumHallwayDesign.DESTROYED_WALLS, 44), ObjectWeightPair.of(EnumHallwayDesign.EMBEDDED_CHEST, 33), ObjectWeightPair.of(EnumHallwayDesign.STAIR_PATTERN, 32), ObjectWeightPair.of(EnumHallwayDesign.COBWEBS, 24), ObjectWeightPair.of(EnumHallwayDesign.SPAWNERS_IN_WALLS, 24), ObjectWeightPair.of(EnumHallwayDesign.FLOOR_CEILING_SLABS, 21), ObjectWeightPair.of(EnumHallwayDesign.WALL_MOUNTED_SPAWNERS, 19), ObjectWeightPair.of(EnumHallwayDesign.FLOWER_POT, 16), ObjectWeightPair.of(EnumHallwayDesign.LAPIS_BLOCK, 4)});
    private static final WeightedList<ObjectWeightPair<EnumRoomDesign>> roomDesignList = new WeightedList((IWeightProvider[])new ObjectWeightPair[]{ObjectWeightPair.of(EnumRoomDesign.GOO_FOUNTAINS, 56), ObjectWeightPair.of(EnumRoomDesign.RUINS, 56), ObjectWeightPair.of(EnumRoomDesign.BOWLS, 54), ObjectWeightPair.of(EnumRoomDesign.FOUR_SPAWNERS, 51), ObjectWeightPair.of(EnumRoomDesign.SCATTERED_SPAWNERS_WITH_COAL, 44), ObjectWeightPair.of(EnumRoomDesign.GLOWING_ROOM, 35), ObjectWeightPair.of(EnumRoomDesign.CARPET_TARGET, 26), ObjectWeightPair.of(EnumRoomDesign.ENCASED_CUBICLE, 20), ObjectWeightPair.of(EnumRoomDesign.TERRARIUM, 17)});

    public RavagedDungeonPlacer(int hallHeight) {
        this.hallHeight = (byte)hallHeight;
    }

    public void setDungeonLevel(int level) {
        this.level = (byte)level;
    }

    public void generateEntrance(LargeStructureWorld world, Random rand, int x, int y, int z, int maxEntranceHeight, DungeonElement entrance) {
        int surfaceY = y - maxEntranceHeight - 1;
        while (++surfaceY <= y && world.getBlock(x, surfaceY, z) != IslandBiomeBase.getTopBlock()) {
        }
        for (int yy = surfaceY + 5; yy >= y - maxEntranceHeight; --yy) {
            for (int xx = x - 2; xx <= x + 2; ++xx) {
                for (int zz = z - 2; zz <= z + 2; ++zz) {
                    if (yy > surfaceY || Math.abs(xx - x) <= 1 && Math.abs(zz - z) <= 1 && yy != y - maxEntranceHeight) {
                        world.setBlock(xx, yy, zz, Blocks.field_150350_a);
                        continue;
                    }
                    world.setBlock(xx, yy, zz, BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                }
            }
        }
    }

    public void generateDescend(LargeStructureWorld world, Random rand, int x, int y, int z, DungeonElement descend) {
        this.generateRoomLayout(world, rand, x, y, z);
        Block coverBlock = rand.nextInt(3) == 0 ? Blocks.field_150359_w : Blocks.field_150350_a;
        for (int yy = y; yy >= y - this.hallHeight - 2; --yy) {
            for (int xx = x - 2; xx <= x + 2; ++xx) {
                for (int zz = z - 2; zz <= z + 2; ++zz) {
                    if (Math.abs(xx - x) <= 1 && Math.abs(zz - z) <= 1 && yy != y - this.hallHeight - 2) {
                        world.setBlock(xx, yy, zz, yy == y ? coverBlock : Blocks.field_150350_a);
                        continue;
                    }
                    world.setBlock(xx, yy, zz, BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                }
            }
        }
        boolean hasGenerated = false;
        block9: while (!hasGenerated) {
            hasGenerated = true;
            EnumDescendDesign design = descendDesignList.getRandomItem(rand).getObject();
            switch (design) {
                case PILLARS_WITH_SPAWNER: {
                    int b;
                    int a;
                    for (a = 0; a < 2; ++a) {
                        for (b = 0; b < 2; ++b) {
                            for (int py = 0; py < this.hallHeight - 1; ++py) {
                                world.setBlock(x - 4 + 8 * a, y + 1 + py, z - 4 + 8 * b, py == 2 ? BlockList.ravaged_brick_glow : BlockList.ravaged_brick);
                            }
                        }
                    }
                    world.setBlock(x, y + this.hallHeight, z, BlockList.ravaged_brick);
                    world.setBlock(x, y + this.hallHeight - 1, z, BlockList.custom_spawner, 2);
                    world.setTileEntityGenerator(x, y + this.hallHeight - 1, z, "louseSpawner", this);
                    break;
                }
                case GOO_CORNERS: {
                    int b;
                    int a;
                    for (a = 0; a < 2; ++a) {
                        for (b = 0; b < 2; ++b) {
                            world.setBlock(x - 6 + 12 * a, y + 1, z - 6 + 12 * b, BlockList.ender_goo);
                            world.setBlock(x - 5 + 10 * a, y + 1, z - 6 + 12 * b, BlockList.ender_goo);
                            world.setBlock(x - 4 + 8 * a, y + 1, z - 6 + 12 * b, BlockList.ender_goo);
                            world.setBlock(x - 6 + 12 * a, y + 1, z - 5 + 10 * b, BlockList.ender_goo);
                            world.setBlock(x - 6 + 12 * a, y + 1, z - 4 + 8 * b, BlockList.ender_goo);
                            world.setBlock(x - 6 + 12 * a, y + 1, z - 3 + 6 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 6 + 12 * a, y + 2, z - 3 + 6 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 6 + 12 * a, y + 3, z - 3 + 6 * b, BlockList.ravaged_brick_glow);
                            world.setBlock(x - 6 + 12 * a, y + 4, z - 3 + 6 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 3 + 6 * a, y + 1, z - 6 + 12 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 3 + 6 * a, y + 2, z - 6 + 12 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 3 + 6 * a, y + 3, z - 6 + 12 * b, BlockList.ravaged_brick_glow);
                            world.setBlock(x - 3 + 6 * a, y + 4, z - 6 + 12 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 5 + 10 * a, y + 1, z - 5 + 10 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 4 + 8 * a, y + 1, z - 5 + 10 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 3 + 6 * a, y + 1, z - 5 + 10 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 5 + 10 * a, y + 1, z - 4 + 8 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 5 + 10 * a, y + 1, z - 3 + 6 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 4 + 8 * a, y + 1, z - 4 + 8 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 3 + 6 * a, y + 1, z - 4 + 8 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 2 + 4 * a, y + 1, z - 4 + 8 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 4 + 8 * a, y + 1, z - 3 + 6 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 4 + 8 * a, y + 1, z - 2 + 4 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 2 + 4 * a, y + 1, z - 5 + 10 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 2 + 4 * a, y + 1, z - 6 + 12 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 5 + 10 * a, y + 1, z - 2 + 4 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 6 + 12 * a, y + 1, z - 2 + 4 * b, BlockList.ravaged_brick_slab);
                        }
                    }
                    continue block9;
                }
                case FENCE_LIGHTS: {
                    int xx = x - 5 + rand.nextInt(4);
                    int zz = z - 5 + rand.nextInt(4);
                    world.setBlock(xx, y + this.hallHeight, zz, BlockList.ravaged_brick_fence);
                    world.setBlock(xx, y + this.hallHeight - 1, zz, BlockList.ravaged_brick_glow);
                    xx = x + 5 - rand.nextInt(4);
                    zz = z - 5 + rand.nextInt(4);
                    world.setBlock(xx, y + this.hallHeight, zz, BlockList.ravaged_brick_fence);
                    world.setBlock(xx, y + this.hallHeight - 1, zz, BlockList.ravaged_brick_glow);
                    xx = x - 5 + rand.nextInt(4);
                    zz = z + 5 - rand.nextInt(4);
                    world.setBlock(xx, y + this.hallHeight, zz, BlockList.ravaged_brick_fence);
                    world.setBlock(xx, y + this.hallHeight - 1, zz, BlockList.ravaged_brick_glow);
                    xx = x + 5 - rand.nextInt(4);
                    zz = z + 5 - rand.nextInt(4);
                    world.setBlock(xx, y + this.hallHeight, zz, BlockList.ravaged_brick_fence);
                    world.setBlock(xx, y + this.hallHeight - 1, zz, BlockList.ravaged_brick_glow);
                    xx = x - 1 + rand.nextInt(3);
                    zz = z - 1 + rand.nextInt(3);
                    world.setBlock(xx, y + this.hallHeight, zz, BlockList.ravaged_brick_fence);
                    world.setBlock(xx, y + this.hallHeight - 1, zz, BlockList.ravaged_brick_glow);
                    break;
                }
                case CORNER_LIGHTS: {
                    for (int a = 0; a < 2; ++a) {
                        for (int b = 0; b < 2; ++b) {
                            world.setBlock(x - 5 + 10 * a, y + 1, z - 5 + 10 * b, BlockList.ravaged_brick_glow);
                            world.setBlock(x - 5 + 10 * a, y + 2, z - 5 + 10 * b, BlockList.ravaged_brick_slab);
                        }
                    }
                    continue block9;
                }
            }
        }
    }

    public void generateHallway(LargeStructureWorld world, Random rand, int x, int y, int z, DungeonElement hallway) {
        for (int yy = y; yy <= y + this.hallHeight + 1; ++yy) {
            for (int xx = x - 2; xx <= x + 2; ++xx) {
                for (int zz = z - 2; zz <= z + 2; ++zz) {
                    if (yy == y || yy == y + this.hallHeight + 1 || xx == x - 2 || xx == x + 2 || zz == z - 2 || zz == z + 2) {
                        world.setBlock(xx, yy, zz, BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                        continue;
                    }
                    world.setBlock(xx, yy, zz, Blocks.field_150350_a);
                }
            }
        }
        EnumHallwayDesign design = hallwayDesignList.getRandomItem(rand).getObject();
        if (design == EnumHallwayDesign.NONE) {
            return;
        }
        int connections = (hallway.checkConnection(DungeonDir.UP) ? 1 : 0) + (hallway.checkConnection(DungeonDir.DOWN) ? 1 : 0) + (hallway.checkConnection(DungeonDir.LEFT) ? 1 : 0) + (hallway.checkConnection(DungeonDir.RIGHT) ? 1 : 0);
        boolean isStraight = hallway.checkConnection(DungeonDir.UP) && hallway.checkConnection(DungeonDir.DOWN) && !hallway.checkConnection(DungeonDir.LEFT) && !hallway.checkConnection(DungeonDir.RIGHT) || hallway.checkConnection(DungeonDir.LEFT) && hallway.checkConnection(DungeonDir.RIGHT) && !hallway.checkConnection(DungeonDir.UP) && !hallway.checkConnection(DungeonDir.DOWN);
        boolean isFullyOpen = hallway.checkConnection(DungeonDir.UP) && hallway.checkConnection(DungeonDir.LEFT) && hallway.checkConnection(DungeonDir.DOWN) && hallway.checkConnection(DungeonDir.RIGHT);
        boolean isDeadEnd = connections == 1;
        switch (design) {
            case DESTROYED_WALLS: {
                int attempts = 80 + rand.nextInt(40 + rand.nextInt(30));
                for (int attempt = 0; attempt < attempts; ++attempt) {
                    int xx = x + rand.nextInt(3) - rand.nextInt(3);
                    int zz = z + rand.nextInt(3) - rand.nextInt(3);
                    int yy = y + 1 + rand.nextInt(this.hallHeight);
                    if (world.getBlock(xx, yy, zz) != BlockList.ravaged_brick) continue;
                    world.setBlock(xx, yy, zz, BlockList.ravaged_brick, BlockRavagedBrick.metaDamaged1 + rand.nextInt(1 + BlockRavagedBrick.metaDamaged4 - BlockRavagedBrick.metaDamaged1));
                }
                break;
            }
            case STAIR_PATTERN: {
                if (isFullyOpen) break;
                DungeonDir off = DungeonDir.values[rand.nextInt(DungeonDir.values.length)];
                while (hallway.checkConnection(off)) {
                    off = DungeonDir.values[rand.nextInt(DungeonDir.values.length)];
                }
                Facing offFacing = RavagedDungeonPlacer.dirToFacing(off);
                boolean isLR = off == DungeonDir.LEFT || off == DungeonDir.RIGHT;
                int metaStairsLeft = (isLR ? offFacing.getRotatedRight() : offFacing.getRotatedLeft()).getStairs() + (rand.nextBoolean() ? 0 : 4);
                int metaStairsRight = (isLR ? offFacing.getRotatedLeft() : offFacing.getRotatedRight()).getStairs() + (rand.nextBoolean() ? 0 : 4);
                for (int yy = y + 1; yy <= y + this.hallHeight; ++yy) {
                    for (int ax1 = -1; ax1 <= 1; ++ax1) {
                        for (int ax2 = 2; ax2 <= 3; ++ax2) {
                            if (ax2 == 2 && (ax1 == -1 || ax1 == 1)) {
                                world.setBlock(x + RavagedDungeonPlacer.rotX(off, ax1, 2), yy, z + RavagedDungeonPlacer.rotZ(off, ax1, 2), BlockList.ravaged_brick_stairs, ax1 == -1 ? metaStairsLeft : metaStairsRight);
                                continue;
                            }
                            if (ax2 == 3 && !RavagedDungeonPlacer.canReplaceBlock(world.getBlock(x + RavagedDungeonPlacer.rotX(off, ax1, ax2), yy, z + RavagedDungeonPlacer.rotZ(off, ax1, ax2)))) continue;
                            world.setBlock(x + RavagedDungeonPlacer.rotX(off, ax1, ax2), yy, z + RavagedDungeonPlacer.rotZ(off, ax1, ax2), ax2 == 2 ? Blocks.field_150350_a : BlockList.ravaged_brick, ax2 == 2 ? 0 : RavagedDungeonPlacer.getBrickMeta(rand));
                        }
                    }
                }
                break;
            }
            case EMBEDDED_CHEST: {
                DungeonDir off;
                if (!isStraight && !isDeadEnd) break;
                DungeonDir dungeonDir = off = hallway.checkConnection(DungeonDir.UP) || hallway.checkConnection(DungeonDir.DOWN) ? DungeonDir.LEFT : DungeonDir.UP;
                if (rand.nextBoolean()) {
                    off = off.reversed();
                }
                boolean isLR = off == DungeonDir.LEFT || off == DungeonDir.RIGHT;
                Facing offFacing = RavagedDungeonPlacer.dirToFacing(off);
                int sz = isDeadEnd ? 1 : 2;
                boolean canGenerate = true;
                for (int yy = y + 1; yy <= y + this.hallHeight && canGenerate; ++yy) {
                    for (int ax1 = -sz; ax1 <= sz && canGenerate; ++ax1) {
                        for (int ax2 = 2; ax2 <= 3 && canGenerate; ++ax2) {
                            if (ax2 == 3 && !RavagedDungeonPlacer.canReplaceBlock(world.getBlock(x + RavagedDungeonPlacer.rotX(off, ax1, ax2), yy, z + RavagedDungeonPlacer.rotZ(off, ax1, ax2)))) {
                                if (world.getBlock(x + RavagedDungeonPlacer.rotX(off, ax1, ax2), yy, z + RavagedDungeonPlacer.rotZ(off, ax1, ax2)) != Blocks.field_150486_ae) continue;
                                canGenerate = false;
                                continue;
                            }
                            world.setBlock(x + RavagedDungeonPlacer.rotX(off, ax1, ax2), yy, z + RavagedDungeonPlacer.rotZ(off, ax1, ax2), ax2 == 2 ? Blocks.field_150350_a : BlockList.ravaged_brick, ax2 == 2 ? 0 : RavagedDungeonPlacer.getBrickMeta(rand));
                        }
                        world.setBlock(x + RavagedDungeonPlacer.rotX(off, ax1, 2), y + this.hallHeight, z + RavagedDungeonPlacer.rotZ(off, ax1, 2), BlockList.ravaged_brick_stairs, 4 + offFacing.getStairs());
                    }
                }
                if (!canGenerate) break;
                if (sz == 2) {
                    world.setBlock(x + RavagedDungeonPlacer.rotX(off, -2, 2), y + 1, z + RavagedDungeonPlacer.rotZ(off, -2, 2), BlockList.ravaged_brick_stairs, 4 + (isLR ? offFacing.getRotatedRight() : offFacing.getRotatedLeft()).getStairs());
                    world.setBlock(x + RavagedDungeonPlacer.rotX(off, 2, 2), y + 1, z + RavagedDungeonPlacer.rotZ(off, 2, 2), BlockList.ravaged_brick_stairs, 4 + (isLR ? offFacing.getRotatedLeft() : offFacing.getRotatedRight()).getStairs());
                }
                for (int a = 0; a < 2; ++a) {
                    world.setBlock(x + RavagedDungeonPlacer.rotX(off, -1 + 2 * a, 2), y + 1, z + RavagedDungeonPlacer.rotZ(off, -1 + 2 * a, 2), BlockList.ravaged_brick_stairs, 4 + offFacing.getStairs());
                }
                world.setBlock(x + RavagedDungeonPlacer.rotX(off, 0, 2), y + 1, z + RavagedDungeonPlacer.rotZ(off, 0, 2), BlockList.ravaged_brick);
                world.setBlock(x + RavagedDungeonPlacer.rotX(off, 0, 2), y + 2, z + RavagedDungeonPlacer.rotZ(off, 0, 2), (Block)Blocks.field_150486_ae, offFacing.getReversed().get6Directional());
                world.setTileEntityGenerator(x + RavagedDungeonPlacer.rotX(off, 0, 2), y + 2, z + RavagedDungeonPlacer.rotZ(off, 0, 2), "hallwayEmbeddedChest", this);
                break;
            }
            case DEAD_END_CHEST: {
                if (!isDeadEnd) break;
                DungeonDir off = DungeonDir.DOWN;
                for (DungeonDir dir : DungeonDir.values) {
                    if (!hallway.checkConnection(dir)) continue;
                    off = dir;
                    break;
                }
                Facing offFacing = RavagedDungeonPlacer.dirToFacing(off);
                for (int ax1 = -1; ax1 <= 1; ++ax1) {
                    world.setBlock(x + RavagedDungeonPlacer.rotX(off, ax1, 1), y + this.hallHeight, z + RavagedDungeonPlacer.rotZ(off, ax1, 1), BlockList.ravaged_brick_stairs, 4 + offFacing.getStairs());
                    if (ax1 == 0) continue;
                    world.setBlock(x + RavagedDungeonPlacer.rotX(off, ax1, 1), y + 1, z + RavagedDungeonPlacer.rotZ(off, ax1, 1), BlockList.ravaged_brick_stairs, offFacing.getStairs());
                }
                world.setBlock(x + RavagedDungeonPlacer.rotX(off, 0, 1), y + 1, z + RavagedDungeonPlacer.rotZ(off, 0, 1), BlockList.ravaged_brick, offFacing.getStairs());
                world.setBlock(x + RavagedDungeonPlacer.rotX(off, 0, 1), y + 2, z + RavagedDungeonPlacer.rotZ(off, 0, 1), (Block)Blocks.field_150486_ae, offFacing.getReversed().get6Directional());
                world.setTileEntityGenerator(x + RavagedDungeonPlacer.rotX(off, 0, 1), y + 2, z + RavagedDungeonPlacer.rotZ(off, 0, 1), "hallwayDeadEndChest", this);
                break;
            }
            case COBWEBS: {
                int attempts = 2 + rand.nextInt(6 * (1 + rand.nextInt(2)));
                for (int attempt = 0; attempt < attempts; ++attempt) {
                    int xx = x + rand.nextInt(3) - rand.nextInt(3);
                    int zz = z + rand.nextInt(3) - rand.nextInt(3);
                    int yy = y + 1 + rand.nextInt(this.hallHeight);
                    if (!world.isAir(xx, yy, zz)) continue;
                    world.setBlock(xx, yy, zz, Blocks.field_150321_G);
                }
                break;
            }
            case FLOOR_CEILING_SLABS: {
                int attempts = 6 + rand.nextInt(7);
                for (int attempt = 0; attempt < attempts; ++attempt) {
                    int yy;
                    int xx = x + rand.nextInt(3) - rand.nextInt(3);
                    int zz = z + rand.nextInt(3) - rand.nextInt(3);
                    int n = yy = rand.nextBoolean() ? y + 1 : y + this.hallHeight;
                    if (!world.isAir(xx, yy, zz)) continue;
                    world.setBlock(xx, yy, zz, BlockList.ravaged_brick_slab, yy == y + 1 ? 0 : 8);
                }
                break;
            }
            case LAPIS_BLOCK: {
                world.setBlock(x, y, z, Blocks.field_150368_y);
                world.setBlock(x, y - 1, z, BlockList.ravaged_brick);
                break;
            }
            case WALL_MOUNTED_SPAWNERS: {
                ArrayList<DungeonDir> availableDirs = CollectionUtil.newList(DungeonDir.values);
                boolean placed = false;
                for (int attempt = 0; attempt < 1 + rand.nextInt(3) && !availableDirs.isEmpty(); ++attempt) {
                    DungeonDir off = (DungeonDir)((Object)availableDirs.remove(rand.nextInt(availableDirs.size())));
                    if (hallway.checkConnection(off)) {
                        if (placed) continue;
                        --attempt;
                        continue;
                    }
                    world.setBlock(x + RavagedDungeonPlacer.rotX(off, 0, -1), y + 2, z + RavagedDungeonPlacer.rotZ(off, 0, -1), BlockList.ravaged_brick_slab, 8);
                    world.setBlock(x + RavagedDungeonPlacer.rotX(off, 0, -1), y + 3, z + RavagedDungeonPlacer.rotZ(off, 0, -1), BlockList.custom_spawner, 2);
                    world.setTileEntityGenerator(x + RavagedDungeonPlacer.rotX(off, 0, -1), y + 3, z + RavagedDungeonPlacer.rotZ(off, 0, -1), "louseSpawner", this);
                    world.setBlock(x + RavagedDungeonPlacer.rotX(off, 0, -1), y + 4, z + RavagedDungeonPlacer.rotZ(off, 0, -1), BlockList.ravaged_brick_slab, 0);
                }
                break;
            }
            case SPAWNERS_IN_WALLS: {
                int spawnerMeta = rand.nextBoolean() ? 3 : 2;
                int placed = 0;
                int maxPlaced = 2 + this.level + rand.nextInt(3 + this.level);
                for (int attempt = 0; attempt < 22 && placed < maxPlaced; ++attempt) {
                    int yy;
                    int xx = x + rand.nextInt(3) - rand.nextInt(3);
                    int zz = z + rand.nextInt(3) - rand.nextInt(3);
                    int n = yy = rand.nextBoolean() ? y + 1 : y + this.hallHeight;
                    if (world.getBlock(xx, yy, zz) != BlockList.ravaged_brick) continue;
                    world.setBlock(xx, yy, zz, BlockList.custom_spawner, spawnerMeta);
                    if (spawnerMeta == 2) {
                        world.setTileEntityGenerator(xx, yy, zz, "louseSpawner", this);
                    }
                    ++placed;
                }
                for (DungeonDir dir : DungeonDir.values) {
                    if (hallway.checkConnection(dir)) continue;
                    for (int a = -1; a <= 1; ++a) {
                        for (int yy = y + 1; yy <= y + this.hallHeight; ++yy) {
                            if (!RavagedDungeonPlacer.canReplaceBlock(world.getBlock(x + RavagedDungeonPlacer.rotX(dir, a, 3), yy, z + RavagedDungeonPlacer.rotZ(dir, a, 3)))) continue;
                            world.setBlock(x + RavagedDungeonPlacer.rotX(dir, a, 3), yy, z + RavagedDungeonPlacer.rotZ(dir, a, 3), BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                        }
                    }
                }
                break;
            }
            case FLOWER_POT: {
                int type = rand.nextInt(6);
                if (type == 0) {
                    DungeonDir off;
                    if (!isStraight) break;
                    DungeonDir dungeonDir = off = hallway.checkConnection(DungeonDir.UP) || hallway.checkConnection(DungeonDir.DOWN) ? DungeonDir.LEFT : DungeonDir.UP;
                    if (rand.nextBoolean()) {
                        off = off.reversed();
                    }
                    for (int ax1 = -1; ax1 <= 1; ++ax1) {
                        if (RavagedDungeonPlacer.canReplaceBlock(world.getBlock(x + RavagedDungeonPlacer.rotX(off, ax1, 3), y + 2, z + RavagedDungeonPlacer.rotZ(off, ax1, 3)))) {
                            world.setBlock(x + RavagedDungeonPlacer.rotX(off, ax1, 3), y + 2, z + RavagedDungeonPlacer.rotZ(off, ax1, 3), BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                        }
                        world.setBlock(x + RavagedDungeonPlacer.rotX(off, ax1, 2), y + 2, z + RavagedDungeonPlacer.rotZ(off, ax1, 2), Blocks.field_150457_bL);
                        world.setTileEntityGenerator(x + RavagedDungeonPlacer.rotX(off, ax1, 2), y + 2, z + RavagedDungeonPlacer.rotZ(off, ax1, 2), "flowerPot", this);
                    }
                    break;
                }
                if (type == 1 || type == 2) {
                    int xx = x + rand.nextInt(3) - 1;
                    int zz = z + rand.nextInt(3) - 1;
                    world.setBlock(xx, y + 1, zz, Blocks.field_150457_bL);
                    world.setTileEntityGenerator(xx, y + 1, zz, "flowerPot", this);
                    break;
                }
                if (type != 3 && type != 4 || isFullyOpen) break;
                DungeonDir off = DungeonDir.values[rand.nextInt(DungeonDir.values.length)];
                while (hallway.checkConnection(off)) {
                    off = DungeonDir.values[rand.nextInt(DungeonDir.values.length)];
                }
                world.setBlock(x + RavagedDungeonPlacer.rotX(off, 0, -1), y + 2, z + RavagedDungeonPlacer.rotZ(off, 0, -1), BlockList.ravaged_brick_slab, 8);
                world.setBlock(x + RavagedDungeonPlacer.rotX(off, 0, -1), y + 3, z + RavagedDungeonPlacer.rotZ(off, 0, -1), Blocks.field_150457_bL);
                world.setTileEntityGenerator(x + RavagedDungeonPlacer.rotX(off, 0, -1), y + 3, z + RavagedDungeonPlacer.rotZ(off, 0, -1), "flowerPot", this);
                break;
            }
        }
        if (connections >= 3 && rand.nextInt(10) == 0) {
            world.setBlock(x, y + this.hallHeight, z, BlockList.ravaged_brick_glow);
        }
    }

    private void generateRoomLayout(LargeStructureWorld world, Random rand, int x, int y, int z) {
        for (int yy = y; yy <= y + this.hallHeight + 1; ++yy) {
            for (int xx = x - 7; xx <= x + 7; ++xx) {
                for (int zz = z - 7; zz <= z + 7; ++zz) {
                    if (yy == y || yy == y + this.hallHeight + 1 || xx == x - 7 || xx == x + 7 || zz == z - 7 || zz == z + 7) {
                        world.setBlock(xx, yy, zz, BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                        continue;
                    }
                    world.setBlock(xx, yy, zz, Blocks.field_150350_a);
                }
            }
        }
    }

    public void generateRoom(LargeStructureWorld world, Random rand, int x, int y, int z, DungeonElement room) {
        this.generateRoomLayout(world, rand, x, y, z);
        boolean isStraight = room.checkConnection(DungeonDir.UP) && room.checkConnection(DungeonDir.DOWN) && !room.checkConnection(DungeonDir.LEFT) && !room.checkConnection(DungeonDir.RIGHT) || room.checkConnection(DungeonDir.LEFT) && room.checkConnection(DungeonDir.RIGHT) && !room.checkConnection(DungeonDir.UP) && !room.checkConnection(DungeonDir.DOWN);
        boolean hasGenerated = false;
        block26: while (!hasGenerated) {
            hasGenerated = true;
            EnumRoomDesign design = roomDesignList.getRandomItem(rand).getObject();
            switch (design) {
                case GOO_FOUNTAINS: {
                    int b;
                    int a;
                    for (a = 0; a < 2; ++a) {
                        for (b = 0; b < 2; ++b) {
                            world.setBlock(x - 6 + 12 * a, y + this.hallHeight, z - 6 + 12 * b, BlockList.ender_goo);
                            world.setBlock(x - 6 + 12 * a, y + 1, z - 2 + 4 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 5 + 10 * a, y + 1, z - 3 + 6 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 4 + 8 * a, y + 1, z - 4 + 8 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 3 + 6 * a, y + 1, z - 5 + 10 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 2 + 4 * a, y + 1, z - 6 + 12 * b, BlockList.ravaged_brick_slab);
                        }
                    }
                    world.setBlock(x, y + this.hallHeight, z, BlockList.ender_goo);
                    world.setBlock(x, y + 1, z, BlockList.custom_spawner, 3);
                    for (a = 0; a < 2; ++a) {
                        for (b = 0; b < 2; ++b) {
                            world.setBlock(x - 2 + 4 * a, y + 1, z - 2 + 4 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 3 + 6 * a, y + 1, z - 1 + 2 * b, BlockList.ravaged_brick_slab);
                            world.setBlock(x - 1 + 2 * a, y + 1, z - 3 + 6 * b, BlockList.ravaged_brick_slab);
                        }
                        world.setBlock(x - 3 + 6 * a, y + 1, z, BlockList.ravaged_brick_slab);
                        world.setBlock(x, y + 1, z - 3 + 6 * a, BlockList.ravaged_brick_slab);
                    }
                    continue block26;
                }
                case CARPET_TARGET: {
                    int a;
                    int color;
                    switch (rand.nextInt(4)) {
                        case 0: {
                            color = 10;
                            break;
                        }
                        case 1: {
                            color = 14;
                            break;
                        }
                        case 2: {
                            color = 15;
                            break;
                        }
                        default: {
                            color = 0;
                        }
                    }
                    for (a = -6; a <= 6; ++a) {
                        world.setBlock(x + a, y + 1, z - 6, Blocks.field_150404_cg, color);
                        world.setBlock(x + a, y + 1, z + 6, Blocks.field_150404_cg, color);
                    }
                    for (a = -4; a <= 4; ++a) {
                        world.setBlock(x + a, y + 1, z - 4, Blocks.field_150404_cg, color);
                        world.setBlock(x + a, y + 1, z + 4, Blocks.field_150404_cg, color);
                    }
                    for (a = -2; a <= 2; ++a) {
                        world.setBlock(x + a, y + 1, z - 2, Blocks.field_150404_cg, color);
                        world.setBlock(x + a, y + 1, z + 2, Blocks.field_150404_cg, color);
                    }
                    for (a = -5; a <= 5; ++a) {
                        world.setBlock(x - 6, y + 1, z + a, Blocks.field_150404_cg, color);
                        world.setBlock(x + 6, y + 1, z + a, Blocks.field_150404_cg, color);
                    }
                    for (a = -3; a <= 3; ++a) {
                        world.setBlock(x - 4, y + 1, z + a, Blocks.field_150404_cg, color);
                        world.setBlock(x + 4, y + 1, z + a, Blocks.field_150404_cg, color);
                    }
                    for (a = -1; a <= 1; ++a) {
                        world.setBlock(x - 2, y + 1, z + a, Blocks.field_150404_cg, color);
                        world.setBlock(x + 2, y + 1, z + a, Blocks.field_150404_cg, color);
                    }
                    for (DungeonDir dir : DungeonDir.values) {
                        if (!room.checkConnection(dir)) continue;
                        for (int ax1 = -1; ax1 <= 1; ++ax1) {
                            for (int ax2 = 2; ax2 <= 6; ++ax2) {
                                world.setBlock(x + RavagedDungeonPlacer.rotX(dir, ax1, ax2), y + 1, z + RavagedDungeonPlacer.rotZ(dir, ax1, ax2), Blocks.field_150350_a);
                            }
                        }
                    }
                    continue block26;
                }
                case SCATTERED_SPAWNERS_WITH_COAL: {
                    int spawnerMeta;
                    int attemptAmount = rand.nextInt(3) + 4 + this.level * 2;
                    int n = spawnerMeta = rand.nextBoolean() ? 2 : 3;
                    for (int attempt = 0; attempt < attemptAmount; ++attempt) {
                        int xx = x + rand.nextInt(5) - rand.nextInt(5);
                        int zz = z + rand.nextInt(5) - rand.nextInt(5);
                        world.setBlock(xx, y + 1, zz, BlockList.custom_spawner, spawnerMeta);
                        if (spawnerMeta == 2) {
                            world.setTileEntityGenerator(xx, y + 1, zz, "louseSpawner", this);
                        }
                        world.setBlock(xx, y + 2, zz, Blocks.field_150402_ci);
                    }
                    continue block26;
                }
                case ENCASED_CUBICLE: {
                    if (this.level == 0) {
                        hasGenerated = false;
                        break;
                    }
                    for (int a = 0; a < 2; ++a) {
                        for (int b = 0; b < 2; ++b) {
                            world.setBlock(x - 6 + 12 * a, y + this.hallHeight, z - 6 + 12 * b, BlockList.ravaged_brick_glow);
                            world.setBlock(x - 6 + 12 * a, y + this.hallHeight - 1, z - 6 + 12 * b, BlockList.ravaged_brick_slab, 8);
                        }
                    }
                    for (int yy = y + 1; yy <= y + this.hallHeight; ++yy) {
                        for (int xx = x - 2; xx <= x + 2; ++xx) {
                            world.setBlock(xx, yy, z + 2, BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                            world.setBlock(xx, yy, z - 2, BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                        }
                        for (int zz = z - 1; zz <= z + 1; ++zz) {
                            world.setBlock(x + 2, yy, zz, BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                            world.setBlock(x - 2, yy, zz, BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                        }
                    }
                    world.setBlock(x, y + 1, z, (Block)Blocks.field_150486_ae);
                    world.setTileEntityGenerator(x, y + 1, z, "encasedCubicleChest", this);
                    int[] spawnerX = new int[]{-1, -1, -1, 0, 0, 1, 1, 1};
                    int[] spawnerZ = new int[]{-1, 0, 1, -1, 1, -1, 0, 1};
                    for (int a = 0; a < spawnerX.length; ++a) {
                        int spawnerMeta = rand.nextInt(3) == 0 ? 2 : 3;
                        world.setBlock(x + spawnerX[a], y + 1, z + spawnerZ[a], BlockList.custom_spawner, spawnerMeta);
                        if (spawnerMeta != 2) continue;
                        world.setTileEntityGenerator(x + spawnerX[a], y + 1, z + spawnerZ[a], "louseSpawner", this);
                    }
                    continue block26;
                }
                case TERRARIUM: {
                    for (int a = 0; a < 2; ++a) {
                        for (int b = 0; b < 2; ++b) {
                            for (int c = 6; c >= 2; --c) {
                                world.setBlock(x - c + 2 * c * a, y + 1, z - 6 + 12 * b, Blocks.field_150346_d, 2);
                                world.setBlock(x - c + 2 * c * a, y + 1, z - 5 + 10 * b, Blocks.field_150346_d, 2);
                                world.setBlock(x - c + 2 * c * a, y + 1, z - 4 + 8 * b, Blocks.field_150346_d, 2);
                            }
                            world.setBlock(x - 6 + 12 * a, y + 1, z - 3 + 6 * b, Blocks.field_150346_d, 2);
                            world.setBlock(x - 5 + 10 * a, y + 1, z - 3 + 6 * b, Blocks.field_150346_d, 2);
                            world.setBlock(x - 4 + 8 * a, y + 1, z - 3 + 6 * b, Blocks.field_150346_d, 2);
                            world.setBlock(x - 6 + 12 * a, y + 1, z - 2 + 4 * b, BlockList.ravaged_brick_glow);
                            world.setBlock(x - 5 + 10 * a, y + 1, z - 2 + 4 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 4 + 8 * a, y + 1, z - 2 + 4 * b, BlockList.ravaged_brick_glow);
                            world.setBlock(x - 3 + 6 * a, y + 1, z - 2 + 4 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 3 + 6 * a, y + 1, z - 3 + 6 * b, BlockList.ravaged_brick_glow);
                            world.setBlock(x - 2 + 4 * a, y + 1, z - 3 + 6 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 2 + 4 * a, y + 1, z - 4 + 8 * b, BlockList.ravaged_brick_glow);
                            world.setBlock(x - 2 + 4 * a, y + 1, z - 5 + 10 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 2 + 4 * a, y + 1, z - 6 + 12 * b, BlockList.ravaged_brick_glow);
                            for (int yy = y + 2; yy <= y + this.hallHeight; ++yy) {
                                for (int c = 3; c <= 6; ++c) {
                                    world.setBlock(x - c + 2 * c * a, yy, z - 2 + 4 * b, (Block)Blocks.field_150399_cn, 14);
                                    world.setBlock(x - 2 + 4 * a, yy, z - c + 2 * c * b, (Block)Blocks.field_150399_cn, 14);
                                }
                            }
                            int plants = 5 + rand.nextInt(9);
                            for (int plant = 0; plant < plants; ++plant) {
                                int zz;
                                int xx = x - 6 + 9 * a + rand.nextInt(4);
                                if (world.getBlock(xx, y + 1, zz = z - 6 + 9 * b + rand.nextInt(4)) != Blocks.field_150346_d) continue;
                                Block plantBlock = Blocks.field_150350_a;
                                int plantMeta = 0;
                                switch (rand.nextInt(11)) {
                                    case 0: 
                                    case 1: {
                                        plantBlock = Blocks.field_150345_g;
                                        plantMeta = rand.nextBoolean() ? 2 : 0;
                                        break;
                                    }
                                    case 2: {
                                        plantBlock = Blocks.field_150327_N;
                                        break;
                                    }
                                    case 3: 
                                    case 4: {
                                        plantBlock = Blocks.field_150329_H;
                                        plantMeta = rand.nextBoolean() ? 1 : 2;
                                        break;
                                    }
                                    case 5: {
                                        plantBlock = rand.nextBoolean() ? Blocks.field_150338_P : Blocks.field_150337_Q;
                                        break;
                                    }
                                    default: {
                                        plantBlock = Blocks.field_150328_O;
                                        plantMeta = rand.nextInt(5);
                                        if (plantMeta != 4) break;
                                        plantMeta = 8;
                                    }
                                }
                                world.setBlock(xx, y + 2, zz, plantBlock, plantMeta);
                            }
                        }
                    }
                    continue block26;
                }
                case RUINS: {
                    int attemptAmount = 28 + rand.nextInt(12);
                    int placedChests = 0;
                    for (int attempt = 0; attempt < attemptAmount; ++attempt) {
                        int zz;
                        int xx = x + rand.nextInt(7) - rand.nextInt(7);
                        if (!world.isAir(xx, y + 1, zz = z + rand.nextInt(7) - rand.nextInt(7))) continue;
                        int height = rand.nextInt(3);
                        for (int yy = y + 1; yy <= y + 1 + height; ++yy) {
                            if (rand.nextInt(8 - this.level) == 0) {
                                world.setBlock(xx, yy, zz, BlockList.custom_spawner, 3);
                                continue;
                            }
                            world.setBlock(xx, yy, zz, BlockList.ravaged_brick);
                        }
                        if (rand.nextInt(3) == 0) {
                            world.setBlock(xx, y + 2 + height, zz, BlockList.ravaged_brick_slab);
                            continue;
                        }
                        if (rand.nextInt(4) == 0) {
                            world.setBlock(xx, y + 2 + height, zz, BlockList.ravaged_brick_stairs, rand.nextInt(4));
                            continue;
                        }
                        if (placedChests >= 2 || height >= 2 || rand.nextInt(4 + placedChests * 2) != 0) continue;
                        world.setBlock(xx, y + 2 + height, zz, (Block)Blocks.field_150486_ae);
                        world.setTileEntityGenerator(xx, y + 2 + height, zz, "ruinChest", this);
                        ++placedChests;
                    }
                    continue block26;
                }
                case FOUR_SPAWNERS: {
                    if (!isStraight) {
                        hasGenerated = false;
                        break;
                    }
                    for (int a = 0; a < 2; ++a) {
                        for (int b = 0; b < 2; ++b) {
                            world.setBlock(x - 2 + 4 * a, y + 1, z - 2 + 4 * b, BlockList.custom_spawner, 2);
                            world.setTileEntityGenerator(x - 2 + 4 * a, y + 1, z - 2 + 4 * b, "louseSpawner", this);
                            world.setBlock(x - 2 + 4 * a, y + 2, z - 2 + 4 * b, BlockList.ravaged_brick_slab);
                        }
                    }
                    DungeonDir dir = room.checkConnection(DungeonDir.UP) ? DungeonDir.UP : DungeonDir.LEFT;
                    int[] zValues = new int[]{-5, 0, 5};
                    for (int a = 0; a < zValues.length; ++a) {
                        world.setBlock(x + RavagedDungeonPlacer.rotX(dir, 6, zValues[a]), y + 2, z + RavagedDungeonPlacer.rotZ(dir, 6, zValues[a]), BlockList.ravaged_brick_fence);
                        world.setBlock(x + RavagedDungeonPlacer.rotX(dir, 6, zValues[a]), y + 3, z + RavagedDungeonPlacer.rotZ(dir, 6, zValues[a]), BlockList.ravaged_brick_glow);
                        world.setBlock(x + RavagedDungeonPlacer.rotX(dir, -6, zValues[a]), y + 2, z + RavagedDungeonPlacer.rotZ(dir, -6, zValues[a]), BlockList.ravaged_brick_fence);
                        world.setBlock(x + RavagedDungeonPlacer.rotX(dir, -6, zValues[a]), y + 3, z + RavagedDungeonPlacer.rotZ(dir, -6, zValues[a]), BlockList.ravaged_brick_glow);
                    }
                    continue block26;
                }
                case GLOWING_ROOM: {
                    int[] pillarX = new int[]{-6, -2, 2, 6, -6, 6, -6, 6, -6, -2, 2, 6};
                    int[] pillarZ = new int[]{-6, -6, -6, -6, -2, -2, 2, 2, 6, 6, 6, 6};
                    for (int a = 0; a < pillarX.length; ++a) {
                        for (int yy = y + 1; yy <= y + this.hallHeight; ++yy) {
                            world.setBlock(x + pillarX[a], yy, z + pillarZ[a], BlockList.ravaged_brick_glow);
                        }
                    }
                    if (!rand.nextBoolean()) break;
                    for (int yy = y + 1; yy <= y + this.hallHeight; ++yy) {
                        for (int xx = x - 5; xx <= x + 5; ++xx) {
                            if (world.isAir(xx, yy, z - 6)) {
                                world.setBlock(xx, yy, z - 6, BlockList.ravaged_brick_fence);
                            }
                            if (!world.isAir(xx, yy, z + 6)) continue;
                            world.setBlock(xx, yy, z + 6, BlockList.ravaged_brick_fence);
                        }
                        for (int zz = z - 5; zz <= z + 5; ++zz) {
                            if (world.isAir(x - 6, yy, zz)) {
                                world.setBlock(x - 6, yy, zz, BlockList.ravaged_brick_fence);
                            }
                            if (!world.isAir(x + 6, yy, zz)) continue;
                            world.setBlock(x + 6, yy, zz, BlockList.ravaged_brick_fence);
                        }
                        for (DungeonDir checkDir : DungeonDir.values) {
                            if (!room.checkConnection(checkDir)) continue;
                            for (int ax1 = -1; ax1 <= 1; ++ax1) {
                                world.setBlock(x + RavagedDungeonPlacer.rotX(checkDir, ax1, -6), yy, z + RavagedDungeonPlacer.rotZ(checkDir, ax1, -6), Blocks.field_150350_a);
                            }
                        }
                    }
                    continue block26;
                }
                case BOWLS: {
                    int bowlFill = rand.nextInt(4);
                    for (int a = 0; a < 2; ++a) {
                        block66: for (int b = 0; b < 2; ++b) {
                            world.setBlock(x - 5 + 7 * a, y + 1, z - 5 + 7 * b, BlockList.ravaged_brick_glow);
                            world.setBlock(x - 4 + 7 * a, y + 1, z - 5 + 7 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 3 + 7 * a, y + 1, z - 5 + 7 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 2 + 7 * a, y + 1, z - 5 + 7 * b, BlockList.ravaged_brick_glow);
                            world.setBlock(x - 5 + 7 * a, y + 1, z - 4 + 7 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 5 + 7 * a, y + 1, z - 3 + 7 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 5 + 7 * a, y + 1, z - 2 + 7 * b, BlockList.ravaged_brick_glow);
                            world.setBlock(x - 3 + 7 * a, y + 1, z - 2 + 7 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 4 + 7 * a, y + 1, z - 2 + 7 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 2 + 7 * a, y + 1, z - 2 + 7 * b, BlockList.ravaged_brick_glow);
                            world.setBlock(x - 2 + 7 * a, y + 1, z - 3 + 7 * b, BlockList.ravaged_brick);
                            world.setBlock(x - 2 + 7 * a, y + 1, z - 4 + 7 * b, BlockList.ravaged_brick);
                            switch (bowlFill) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    world.setBlock(x - 4 + 7 * a, y + 1, z - 4 + 7 * b, bowlFill == 0 ? BlockList.ender_goo : (bowlFill == 1 ? BlockList.ravaged_brick_slab : Blocks.field_150343_Z));
                                    world.setBlock(x - 3 + 7 * a, y + 1, z - 4 + 7 * b, bowlFill == 0 ? BlockList.ender_goo : (bowlFill == 1 ? BlockList.ravaged_brick_slab : Blocks.field_150343_Z));
                                    world.setBlock(x - 3 + 7 * a, y + 1, z - 3 + 7 * b, bowlFill == 0 ? BlockList.ender_goo : (bowlFill == 1 ? BlockList.ravaged_brick_slab : Blocks.field_150343_Z));
                                    world.setBlock(x - 4 + 7 * a, y + 1, z - 3 + 7 * b, bowlFill == 0 ? BlockList.ender_goo : (bowlFill == 1 ? BlockList.ravaged_brick_slab : Blocks.field_150343_Z));
                                    continue block66;
                                }
                                case 3: {
                                    world.setBlock(x - 4 + 7 * a, y + 1, z - 4 + 7 * b, (a ^ b) == 1 ? BlockList.custom_spawner : Blocks.field_150402_ci, (a ^ b) == 1 ? 3 : 0);
                                    world.setBlock(x - 3 + 7 * a, y + 1, z - 4 + 7 * b, (a ^ b) == 0 ? BlockList.custom_spawner : Blocks.field_150402_ci, (a ^ b) == 0 ? 3 : 0);
                                    world.setBlock(x - 3 + 7 * a, y + 1, z - 3 + 7 * b, (a ^ b) == 1 ? BlockList.custom_spawner : Blocks.field_150402_ci, (a ^ b) == 1 ? 3 : 0);
                                    world.setBlock(x - 4 + 7 * a, y + 1, z - 3 + 7 * b, (a ^ b) == 0 ? BlockList.custom_spawner : Blocks.field_150402_ci, (a ^ b) == 0 ? 3 : 0);
                                }
                            }
                        }
                    }
                    continue block26;
                }
            }
        }
    }

    public void generateEndLayout(LargeStructureWorld world, Random rand, int[] x, int y, int[] z, List<DungeonElement> end) {
        int minX = x[0];
        int maxX = x[0];
        int minZ = z[0];
        int maxZ = z[0];
        for (int a = 1; a < x.length; ++a) {
            if (x[a] < minX) {
                minX = x[a];
            }
            if (x[a] > maxX) {
                maxX = x[a];
            }
            if (z[a] < minZ) {
                minZ = z[a];
            }
            if (z[a] <= maxZ) continue;
            maxZ = z[a];
        }
        for (int yy = y; yy <= y + this.hallHeight + 1; ++yy) {
            for (int xx = minX - 7; xx <= maxX + 7; ++xx) {
                for (int zz = minZ - 7; zz <= maxZ + 7; ++zz) {
                    if (yy == y || yy == y + this.hallHeight + 1 || xx == minX - 7 || xx == maxX + 7 || zz == minZ - 7 || zz == maxZ + 7) {
                        world.setBlock(xx, yy, zz, BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                        continue;
                    }
                    world.setBlock(xx, yy, zz, Blocks.field_150350_a);
                }
            }
        }
    }

    public void generateEndContent(LargeStructureWorld world, Random rand, int[] x, int y, int[] z, List<DungeonElement> end) {
        int a;
        int minX = x[0];
        int minZ = z[0];
        for (int a2 = 1; a2 < x.length; ++a2) {
            if (x[a2] < minX) {
                minX = x[a2];
            }
            if (z[a2] >= minZ) continue;
            minZ = z[a2];
        }
        int topLeftAirX = minX - 7 + 1;
        int topLeftAirZ = minZ - 7 + 1;
        int[] gooX = new int[]{2, 12, 22, 2, 22, 2, 12, 22};
        int[] gooZ = new int[]{2, 2, 2, 12, 12, 22, 22, 22};
        for (a = 0; a < gooX.length; ++a) {
            int pz;
            for (int px = 0; px < 2; ++px) {
                for (pz = 0; pz < 2; ++pz) {
                    world.setBlock(topLeftAirX + gooX[a] + 1 + px, y + this.hallHeight, topLeftAirZ + gooZ[a] + 1 + pz, BlockList.ender_goo);
                    world.setBlock(topLeftAirX + gooX[a] + 1 + px, y + this.hallHeight + 1, topLeftAirZ + gooZ[a] + 1 + pz, BlockList.ravaged_brick_glow);
                }
            }
            for (int py = 0; py < 2; ++py) {
                for (int px = 0; px < 4; ++px) {
                    world.setBlock(topLeftAirX + gooX[a] + px, y + 2 + py, topLeftAirZ + gooZ[a], Blocks.field_150350_a);
                    world.setBlock(topLeftAirX + gooX[a] + px, y + 1 + py * (this.hallHeight - 1), topLeftAirZ + gooZ[a], BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                    world.setBlock(topLeftAirX + gooX[a] + px, y + 2 + py, topLeftAirZ + gooZ[a] + 3, Blocks.field_150350_a);
                    world.setBlock(topLeftAirX + gooX[a] + px, y + 1 + py * (this.hallHeight - 1), topLeftAirZ + gooZ[a] + 3, BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                }
                for (pz = 0; pz < 2; ++pz) {
                    world.setBlock(topLeftAirX + gooX[a], y + 2 + py, topLeftAirZ + gooZ[a] + 1 + pz, Blocks.field_150350_a);
                    world.setBlock(topLeftAirX + gooX[a], y + 1 + py * (this.hallHeight - 1), topLeftAirZ + gooZ[a] + 1 + pz, BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                    world.setBlock(topLeftAirX + gooX[a] + 3, y + 2 + py, topLeftAirZ + gooZ[a] + 1 + pz, Blocks.field_150350_a);
                    world.setBlock(topLeftAirX + gooX[a] + 3, y + 1 + py * (this.hallHeight - 1), topLeftAirZ + gooZ[a] + 1 + pz, BlockList.ravaged_brick, RavagedDungeonPlacer.getBrickMeta(rand));
                }
            }
            for (int attempt = 0; attempt < 3 + rand.nextInt(4); ++attempt) {
                int yy;
                int xx = topLeftAirX + gooX[a] + rand.nextInt(4);
                int zz = topLeftAirZ + gooZ[a] + rand.nextInt(4);
                int n = yy = rand.nextBoolean() ? y + 1 : y + this.hallHeight;
                if (world.getBlock(xx, yy, zz) != BlockList.ravaged_brick) continue;
                world.setBlock(xx, yy, zz, BlockList.custom_spawner, 2);
                world.setTileEntityGenerator(xx, yy, zz, "louseSpawner", this);
            }
        }
        for (a = 0; a < 2; ++a) {
            for (int b = 0; b < 2; ++b) {
                for (int py = 0; py < 4; ++py) {
                    world.setBlock(topLeftAirX + 12 + 3 * a, y + 1 + py, topLeftAirZ + 12 + 3 * b, py == 0 || py == 3 ? BlockList.ravaged_brick_glow : BlockList.ravaged_brick);
                    if (py > 0) {
                        world.setBlock(topLeftAirX + 13 + a, y + 1 + py, topLeftAirZ + 13 + b, BlockList.custom_spawner, 2);
                        world.setTileEntityGenerator(topLeftAirX + 13 + a, y + 1 + py, topLeftAirZ + 13 + b, "louseSpawner", this);
                        continue;
                    }
                    world.setBlock(topLeftAirX + 13 + a, y + 1, topLeftAirZ + 13 + b, BlockList.ravaged_brick);
                }
            }
        }
        int[] chestX = new int[]{13, 14, 13, 14, 12, 12, 15, 15};
        int[] chestZ = new int[]{12, 12, 15, 15, 13, 14, 13, 14};
        for (int a3 = 0; a3 < chestX.length; ++a3) {
            world.setBlock(topLeftAirX + chestX[a3], y + 1, topLeftAirZ + chestZ[a3], (Block)Blocks.field_150486_ae);
            world.setTileEntityGenerator(topLeftAirX + chestX[a3], y + 1, topLeftAirZ + chestZ[a3], "endRoomChest", this);
        }
    }

    @Override
    public void onTileEntityRequested(String key, TileEntity tile, Random rand) {
        if (key.equals("hallwayEmbeddedChest")) {
            TileEntityChest chest = (TileEntityChest)tile;
            int attemptAmount = 4 + rand.nextInt(5) + rand.nextInt(4 + this.level);
            for (int attempt = 0; attempt < attemptAmount; ++attempt) {
                chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), (rand.nextInt(3) == 0 ? RavagedDungeonLoot.lootUncommon : RavagedDungeonLoot.lootGeneral).generateIS(rand));
            }
        } else if (key.equals("hallwayDeadEndChest")) {
            TileEntityChest chest = (TileEntityChest)tile;
            int attemptAmount = 7 + rand.nextInt(8 + this.level * 2);
            for (int attempt = 0; attempt < attemptAmount; ++attempt) {
                chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), (rand.nextInt(3) != 0 ? RavagedDungeonLoot.lootRare : RavagedDungeonLoot.lootGeneral).generateIS(rand));
            }
        } else if (key.equals("ruinChest")) {
            TileEntityChest chest = (TileEntityChest)tile;
            int attemptAmount = 5 + rand.nextInt(5 + this.level * 2);
            for (int attempt = 0; attempt < attemptAmount; ++attempt) {
                chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), RavagedDungeonLoot.lootGeneral.generateIS(rand));
            }
        } else if (key.equals("encasedCubicleChest")) {
            TileEntityChest chest = (TileEntityChest)tile;
            int attemptAmount = 10 + this.level + rand.nextInt(10 + this.level);
            for (int attempt = 0; attempt < attemptAmount; ++attempt) {
                chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), RavagedDungeonLoot.lootRare.generateIS(rand));
            }
        } else if (key.equals("endRoomChest")) {
            TileEntityChest chest = (TileEntityChest)tile;
            int attemptAmount = 3 + rand.nextInt(2 + rand.nextInt(2));
            for (int attempt = 0; attempt < attemptAmount; ++attempt) {
                chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), RavagedDungeonLoot.lootEnd.generateIS(rand));
            }
        } else if (key.equals("louseSpawner")) {
            LouseRavagedSpawnerLogic logic = (LouseRavagedSpawnerLogic)((TileEntityCustomSpawner)tile).getSpawnerLogic();
            logic.setLouseSpawnData(new LouseRavagedSpawnerLogic.LouseSpawnData(this.level, rand));
        } else if (key.equals("flowerPot")) {
            ItemStack is = RavagedDungeonLoot.flowerPotItems[rand.nextInt(RavagedDungeonLoot.flowerPotItems.length)].func_77946_l();
            if (is.func_77973_b() == Item.func_150898_a((Block)BlockList.death_flower)) {
                tile.func_145831_w().func_147465_d(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, BlockList.death_flower_pot, is.func_77960_j(), 3);
            } else {
                TileEntityFlowerPot flowerPot = (TileEntityFlowerPot)tile;
                flowerPot.func_145964_a(is.func_77973_b(), is.func_77960_j());
                flowerPot.func_70296_d();
                if (!flowerPot.func_145831_w().func_72921_c(flowerPot.field_145851_c, flowerPot.field_145848_d, flowerPot.field_145849_e, is.func_77960_j(), 2)) {
                    flowerPot.func_145831_w().func_147471_g(flowerPot.field_145851_c, flowerPot.field_145848_d, flowerPot.field_145849_e);
                }
            }
        }
    }

    private static boolean canReplaceBlock(Block block) {
        return block == Blocks.field_150377_bs || block == BlockList.end_terrain || block == Blocks.field_150350_a || block == BlockList.crossed_decoration || block == BlockList.stardust_ore || block == BlockList.end_powder_ore;
    }

    private static int getBrickMeta(Random rand) {
        return rand.nextInt(8) != 0 ? 0 : (rand.nextInt(12) == 0 ? (int)BlockRavagedBrick.metaCracked : BlockRavagedBrick.metaDamaged1 + rand.nextInt(1 + BlockRavagedBrick.metaDamaged4 - BlockRavagedBrick.metaDamaged1));
    }

    private static int rotX(DungeonDir dir, int x, int z) {
        switch (dir) {
            case UP: {
                return x;
            }
            case DOWN: {
                return -x;
            }
            case LEFT: {
                return z;
            }
            case RIGHT: {
                return -z;
            }
        }
        return 0;
    }

    private static int rotZ(DungeonDir dir, int x, int z) {
        switch (dir) {
            case UP: {
                return z;
            }
            case DOWN: {
                return -z;
            }
            case LEFT: {
                return x;
            }
            case RIGHT: {
                return -x;
            }
        }
        return 0;
    }

    private static Facing dirToFacing(DungeonDir dir) {
        switch (dir) {
            case UP: {
                return Facing.SOUTH_POSZ;
            }
            case DOWN: {
                return Facing.NORTH_NEGZ;
            }
            case LEFT: {
                return Facing.EAST_POSX;
            }
            case RIGHT: {
                return Facing.WEST_NEGX;
            }
        }
        return null;
    }

    private static enum EnumRoomDesign {
        GOO_FOUNTAINS,
        BOWLS,
        CARPET_TARGET,
        SCATTERED_SPAWNERS_WITH_COAL,
        GLOWING_ROOM,
        FOUR_SPAWNERS,
        ENCASED_CUBICLE,
        TERRARIUM,
        RUINS;

    }

    private static enum EnumHallwayDesign {
        NONE,
        DESTROYED_WALLS,
        STAIR_PATTERN,
        EMBEDDED_CHEST,
        COBWEBS,
        FLOOR_CEILING_SLABS,
        LAPIS_BLOCK,
        WALL_MOUNTED_SPAWNERS,
        DEAD_END_CHEST,
        FLOWER_POT,
        SPAWNERS_IN_WALLS;

    }

    private static enum EnumDescendDesign {
        PILLARS_WITH_SPAWNER,
        GOO_CORNERS,
        FENCE_LIGHTS,
        CORNER_LIGHTS;

    }
}

