/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.gui;

import chylex.hee.gui.helpers.GuiItemRenderHelper;
import chylex.hee.mechanics.misc.PlayerTransportBeacons;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.server.S04TransportBeaconTravel;
import chylex.hee.proxy.ModCommonProxy;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTransportBeacon
extends GuiScreen
implements GuiItemRenderHelper.ITooltipRenderer {
    private static final ResourceLocation guiResource = new ResourceLocation("hardcoreenderexpansion:textures/gui/transport_beacon.png");
    private static final int size = 176;
    public final int centerX;
    public final int centerY;
    public final int centerZ;
    private int selectedX;
    private int selectedZ;
    private byte status;
    private Set<PlayerTransportBeacons.LocationXZ> locs = new HashSet<PlayerTransportBeacons.LocationXZ>();
    private GuiButton buttonTravel;

    public GuiTransportBeacon(int centerX, int centerY, int centerZ) {
        this.centerX = this.selectedX = centerX;
        this.centerY = centerY;
        this.centerZ = this.selectedZ = centerZ;
    }

    public void loadOffsets(Set<PlayerTransportBeacons.LocationXZ> offsets) {
        this.locs.clear();
        for (PlayerTransportBeacons.LocationXZ offset : offsets) {
            this.locs.add(new PlayerTransportBeacons.LocationXZ(this.centerX + offset.x, this.centerZ + offset.z));
        }
    }

    public void setStatus(boolean hasEnergy, boolean noTampering) {
        this.status = 0;
        if (hasEnergy) {
            this.status = (byte)(this.status | 1);
        }
        if (noTampering) {
            this.status = (byte)(this.status | 2);
        }
        this.updateTravelButton();
    }

    public void updateStatusEvent(int eventId, boolean value) {
        if (eventId == 1) {
            this.status = (byte)(this.status & 0xFFFFFFFE);
            if (value) {
                this.status = (byte)(this.status | 1);
            }
        } else if (eventId == 0) {
            this.status = (byte)(this.status & 0xFFFFFFFD);
            if (value) {
                this.status = (byte)(this.status | 2);
            }
        }
        this.updateTravelButton();
    }

    public void func_73866_w_() {
        this.buttonTravel = new GuiButton(1, (this.field_146294_l >> 1) - 82, (this.field_146295_m >> 1) + 61, 80, 20, I18n.func_135052_a((String)"container.button.travel", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonTravel);
        this.field_146292_n.add(new GuiButton(2, (this.field_146294_l >> 1) + 2, (this.field_146295_m >> 1) + 61, 80, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.updateTravelButton();
    }

    private void updateTravelButton() {
        this.buttonTravel.field_146124_l = (this.status & 3) == 3 && (this.centerX != this.selectedX || this.centerZ != this.selectedZ);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 1) {
            PacketPipeline.sendToServer(new S04TransportBeaconTravel(this.centerX, this.centerY, this.centerZ, this.selectedX, this.selectedZ));
        }
        this.field_146297_k.func_147108_a(null);
    }

    private boolean checkMouseOver(PlayerTransportBeacons.LocationXZ loc, int x, int y) {
        int posX = (this.field_146294_l >> 1) - 1 + (loc.x - this.centerX >> 4);
        int posY = (this.field_146295_m >> 1) - 9 + (loc.z - this.centerZ >> 4);
        return Math.abs(x - posX) <= 1 && Math.abs(y - posY) <= 1;
    }

    protected void func_73864_a(int x, int y, int button) {
        if (button == 0) {
            for (PlayerTransportBeacons.LocationXZ loc : this.locs) {
                if (!this.checkMouseOver(loc, x, y)) continue;
                this.selectedX = loc.x;
                this.selectedZ = loc.z;
                this.updateTravelButton();
                return;
            }
        }
        super.func_73864_a(x, y, button);
    }

    public void func_73863_a(int x, int y, float renderPartialTicks) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiResource);
        int guiX = this.field_146294_l - 176 >> 1;
        int guiY = this.field_146295_m - 176 >> 1;
        this.func_73729_b(guiX, guiY, 0, 0, 176, 176);
        boolean changedColor = false;
        int hoverX = Integer.MIN_VALUE;
        int hoverZ = Integer.MIN_VALUE;
        for (PlayerTransportBeacons.LocationXZ loc : this.locs) {
            if (loc.x == this.centerX && loc.z == this.centerZ) {
                GL11.glColor4f((float)0.5f, (float)0.3f, (float)1.0f, (float)1.0f);
                changedColor = true;
            } else if (loc.x == this.selectedX && loc.z == this.selectedZ) {
                GL11.glColor4f((float)0.9f, (float)0.6f, (float)0.0f, (float)1.0f);
                changedColor = true;
            }
            if (hoverX == Integer.MIN_VALUE && hoverZ == Integer.MIN_VALUE && this.checkMouseOver(loc, x, y)) {
                hoverX = loc.x;
                hoverZ = loc.z;
            }
            this.func_73729_b((this.field_146294_l >> 1) - 1 + (loc.x - this.centerX >> 4), (this.field_146295_m >> 1) - 9 + (loc.z - this.centerZ >> 4), 176, 0, 2, 2);
            if (!changedColor) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        super.func_73863_a(x, y, renderPartialTicks);
        String s = I18n.func_135052_a((String)(ModCommonProxy.hardcoreEnderbacon ? "container.transportBeacon.bacon" : "container.transportBeacon"), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(s, (this.field_146294_l >> 1) - (this.field_146289_q.func_78256_a(s) >> 1), (this.field_146295_m >> 1) - 82, 0x404040);
        String locs = null;
        locs = hoverX != Integer.MIN_VALUE && hoverZ != Integer.MIN_VALUE ? hoverX + ", " + hoverZ : (this.selectedX != this.centerX && this.selectedZ != this.centerZ ? this.selectedX + ", " + this.selectedZ : this.centerX + ", " + this.centerZ);
        this.field_146289_q.func_78276_b(locs, (this.field_146294_l >> 1) + 88 - this.field_146289_q.func_78256_a(locs) - 6, (this.field_146295_m >> 1) + 52, 0x404040);
        if (!this.buttonTravel.field_146124_l && x >= this.buttonTravel.field_146128_h && y >= this.buttonTravel.field_146129_i && x < this.buttonTravel.field_146128_h + this.buttonTravel.func_146117_b() && y < this.buttonTravel.field_146129_i + this.buttonTravel.func_154310_c()) {
            if ((this.status & 2) == 0) {
                GuiItemRenderHelper.setupTooltip(x, y, I18n.func_135052_a((String)(this.field_146297_k.field_71441_e.field_73011_w.field_76574_g == 1 ? "container.transportBeacon.error.tamper" : "container.transportBeacon.error.dimension"), (Object[])new Object[0]));
            } else if (this.selectedX == this.centerX && this.selectedZ == this.centerZ) {
                GuiItemRenderHelper.setupTooltip(x, y, I18n.func_135052_a((String)"container.transportBeacon.error.nodestination", (Object[])new Object[0]));
            } else if ((this.status & 1) == 0) {
                GuiItemRenderHelper.setupTooltip(x, y, I18n.func_135052_a((String)"container.transportBeacon.error.noenergy", (Object[])new Object[0]));
            }
            GuiItemRenderHelper.drawTooltip(this, this.field_146289_q);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void setZLevel(float newZLevel) {
        this.field_73735_i = newZLevel;
    }

    @Override
    public void callDrawGradientRect(int x1, int y1, int x2, int y2, int color1, int color2) {
        this.func_73733_a(x1, y1, x2, y2, color1, color2);
    }
}

