/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.GTHandler.machines;

import com.github.bartimaeusnek.cropspp.items.CppItems;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.basic.GT_MetaTileEntity_Pump;
import ic2.core.Ic2Items;
import ic2.core.crop.TileEntityCrop;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class CropWeedPicker
extends GT_MetaTileEntity_Hatch {
    public CropWeedPicker(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{"Automatically picks Weeds", "Range = Tier", "Takes in 1A", "Needs a Weeding Trovel or a Spade in its Inventory", "Need to be supplied with 1L Lubricant per tick."}, new ITexture[0]);
    }

    public CropWeedPicker(String mName, byte mTier, String[] mDescriptionArray, ITexture[][][] mTextures) {
        super(mName, (int)mTier, 1, mDescriptionArray, mTextures);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new CropWeedPicker(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.getFluid().equals(Materials.Lubricant.getFluid(1L).getFluid()) || super.isFluidInputAllowed(aFluid);
    }

    public int getCapacity() {
        return 1000 * this.mTier;
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && (this.mInventory[aIndex] == null || GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.mInventory[aIndex])) && this.allowPutStack(this.getBaseMetaTileEntity(), aIndex, ForgeDirection.getOrientation((int)ordinalSide), aStack);
    }

    public boolean doesFillContainers() {
        return false;
    }

    public boolean doesEmptyContainers() {
        return true;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return false;
    }

    public boolean displaysItemStack() {
        return true;
    }

    public boolean displaysStackSize() {
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (!this.getBaseMetaTileEntity().isAllowedToWork() || !GT_Utility.areStacksEqual((ItemStack)this.mInventory[0], (ItemStack)CppItems.itemSpadeStack) && !GT_Utility.areStacksEqual((ItemStack)this.mInventory[0], (ItemStack)Ic2Items.weedingTrowel) || this.getFluid().amount < 20 || !this.getBaseMetaTileEntity().isUniversalEnergyStored(GT_MetaTileEntity_Pump.getEuUsagePerTier((int)this.mTier))) {
                return;
            }
            this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(GT_MetaTileEntity_Pump.getEuUsagePerTier((int)this.mTier), true);
            this.getFluid().amount -= 20;
            int xmin = this.getBaseMetaTileEntity().getXCoord() > 0 ? this.getBaseMetaTileEntity().getXCoord() - this.mTier : this.getBaseMetaTileEntity().getXCoord() + this.mTier;
            int xmax = this.getBaseMetaTileEntity().getXCoord() > 0 ? this.getBaseMetaTileEntity().getXCoord() + this.mTier : this.getBaseMetaTileEntity().getXCoord() - this.mTier;
            int zmin = this.getBaseMetaTileEntity().getZCoord() > 0 ? this.getBaseMetaTileEntity().getZCoord() - this.mTier : this.getBaseMetaTileEntity().getZCoord() + this.mTier;
            int zmax = this.getBaseMetaTileEntity().getZCoord() > 0 ? this.getBaseMetaTileEntity().getZCoord() + this.mTier : this.getBaseMetaTileEntity().getZCoord() - this.mTier;
            for (int x = xmin; x <= xmax; ++x) {
                for (int z = zmin; z <= zmax; ++z) {
                    TileEntityCrop cropTE;
                    TileEntity possibleCrop = this.getBaseMetaTileEntity().getWorld().func_147438_o(x, (int)this.getBaseMetaTileEntity().getYCoord(), z);
                    if (!(possibleCrop instanceof TileEntityCrop) || (cropTE = (TileEntityCrop)possibleCrop).getCrop() == null) continue;
                    if (cropTE.getCrop().tier() <= 0) {
                        cropTE.reset();
                    }
                    cropTE.weedlevel = 0;
                    cropTE.updateState();
                    cropTE.func_70296_d();
                }
            }
        }
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isOverclockerUpgradable() {
        return false;
    }

    public boolean isTransformerUpgradable() {
        return false;
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return true;
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return false;
    }

    public boolean isTeleporterCompatible() {
        return false;
    }

    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 16L;
    }

    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 64L;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public long maxSteamStore() {
        return this.maxEUStore();
    }

    public long maxAmperesIn() {
        return 1L;
    }

    public int getStackDisplaySlot() {
        return 2;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public int getTankPressure() {
        return 100;
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], side == ForgeDirection.DOWN || side == ForgeDirection.UP ? TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_OUT) : TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ADV_PUMP)};
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return this.getTexturesInactive(aBaseTexture);
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ADV_PUMP), TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ADV_PUMP), TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ADV_PUMP), TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ADV_PUMP)};
    }

    public boolean useModularUI() {
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(7, 16).setSize(71, 45))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.getInputSlot()).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_IN}).setPos(79, 16))).widget(new TextWidget("Liquid Amount").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 20))).widget(TextWidget.dynamicString(() -> GT_Utility.parseNumberToString((int)(this.mFluid != null ? this.mFluid.amount : 0))).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 30));
    }
}

