/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib.inventory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.inventory.IItemMap;

public class MappedItemsOrderedByTimeAdded
implements IItemMap {
    public String nbtKey;
    protected Map<HashableItemWithoutSize, Integer> map;

    public MappedItemsOrderedByTimeAdded(String key) {
        this.nbtKey = key;
        this.map = new LinkedHashMap<HashableItemWithoutSize, Integer>();
    }

    public MappedItemsOrderedByTimeAdded(MappedItemsOrderedByTimeAdded copySource) {
        this.nbtKey = copySource.nbtKey;
        this.map = new LinkedHashMap<HashableItemWithoutSize, Integer>(copySource.map);
    }

    public void add(ItemStack stack, boolean rearrange) {
        HashableItemWithoutSize item = new HashableItemWithoutSize(stack);
        Integer c = this.map.get(item);
        if (c == null) {
            this.map.put(item, stack.field_77994_a);
        } else {
            if (rearrange) {
                this.map.remove(item);
            }
            this.map.put(item, c + stack.field_77994_a);
        }
    }

    public void add(ItemStack stack) {
        this.add(stack, true);
    }

    public void subtract(ItemStack stack) {
        HashableItemWithoutSize item = new HashableItemWithoutSize(stack);
        Integer c = this.map.get(item);
        int newC = (c == null ? 0 : c) - stack.field_77994_a;
        if (newC > 0) {
            this.map.put(item, newC);
        } else if (c != null) {
            this.map.remove(item);
        }
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public Iterator<Map.Entry<HashableItemWithoutSize, Integer>> getIterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    public boolean containsKey(HashableItemWithoutSize item) {
        return this.map.containsKey(item);
    }

    @Override
    public int get(HashableItemWithoutSize item) {
        Integer c = this.map.get(item);
        return c == null ? 0 : c;
    }

    public void setAll(ArrayList<ItemStack> list) {
        this.map.clear();
        for (ItemStack stack : list) {
            this.map.put(new HashableItemWithoutSize(stack), stack.field_77994_a);
        }
    }

    public void set(HashableItemWithoutSize item, int count, boolean rearrange) {
        if (count != 0) {
            if (rearrange && this.map.containsKey(item)) {
                this.map.remove(item);
            }
            this.map.put(item, count);
        } else if (this.map.containsKey(item)) {
            this.map.remove(item);
        }
    }

    @Override
    public void set(HashableItemWithoutSize item, int count) {
        this.set(item, count, true);
    }

    @Override
    public ArrayList<ItemStack> getItemStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Map.Entry<HashableItemWithoutSize, Integer> entry : this.map.entrySet()) {
            stacks.add(entry.getKey().getItemStack(entry.getValue()));
        }
        return stacks;
    }

    @Override
    public MappedItemsOrderedByTimeAdded copy() {
        return new MappedItemsOrderedByTimeAdded(this);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.map.clear();
        NBTTagList nbttaglist = nbttagcompound.func_150295_c(this.nbtKey, 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound tagList = nbttaglist.func_150305_b(i);
            ItemStack stack = TjUtil.readLargeItemStackFromNBT(tagList);
            if (stack == null || stack.field_77994_a <= 0) continue;
            this.map.put(new HashableItemWithoutSize(stack), stack.field_77994_a);
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (Map.Entry<HashableItemWithoutSize, Integer> entry : this.map.entrySet()) {
            ItemStack stack = entry.getKey().getItemStack(entry.getValue());
            NBTTagCompound tagList = new NBTTagCompound();
            TjUtil.writeLargeItemStackToNBT(stack, tagList);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        nbttagcompound.func_74782_a(this.nbtKey, (NBTBase)nbttaglist);
    }
}

