/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.nei;

import binnie.Binnie;
import binnie.core.nei.NEIUtils;
import binnie.core.nei.PositionedFluidTank;
import binnie.core.nei.RecipeHandlerBase;
import binnie.extratrees.item.ExtraTreeItems;
import binnie.extratrees.machines.lumbermill.Lumbermill;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class NEIHandlerLumbermill
extends RecipeHandlerBase {
    @Override
    public void prepare() {
        if (Lumbermill.recipes.isEmpty()) {
            Lumbermill.calculateLumbermillProducts();
        }
    }

    public String getOverlayIdentifier() {
        return "extratrees.lumbermill";
    }

    public String getGuiTexture() {
        return "extratrees:textures/gui/nei/lumbermill.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"extratrees.machine.machine.lumbermill");
    }

    public void loadTransferRects() {
        this.addTransferRect(75, 27, 24, 17);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)74);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(75, 27, 176, 0, 24, 17, 40, 0);
    }

    @Override
    public void loadAllRecipes() {
        Lumbermill.recipes.forEach((wood, plank) -> this.arecipes.add(new CachedLumbermillRecipe((ItemStack)wood, Lumbermill.getPlankProduct(wood))));
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ExtraTreeItems.Sawdust.get(1), (ItemStack)result) || NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ExtraTreeItems.Bark.get(1), (ItemStack)result)) {
            this.loadAllRecipes();
        } else {
            for (Map.Entry<ItemStack, ItemStack> entry : Lumbermill.recipes.entrySet()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)entry.getValue(), (ItemStack)result)) continue;
                this.arecipes.add(new CachedLumbermillRecipe(entry.getKey(), Lumbermill.getPlankProduct(entry.getKey())));
            }
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        if (NEIUtils.areFluidsSameType(Binnie.Liquid.getLiquidStack("water", 0), ingredient)) {
            this.loadAllRecipes();
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<ItemStack, ItemStack> entry : Lumbermill.recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)entry.getKey(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedLumbermillRecipe(entry.getKey(), Lumbermill.getPlankProduct(entry.getKey())));
        }
    }

    public class CachedLumbermillRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedFluidTank waterTank;
        public PositionedStack bark;
        public PositionedStack sawDust;
        public PositionedStack wood;
        public PositionedStack plank;
        public List<PositionedStack> results;

        public CachedLumbermillRecipe(ItemStack wood, ItemStack plank) {
            super(NEIHandlerLumbermill.this);
            this.waterTank = new PositionedFluidTank(Binnie.Liquid.getLiquidStack("water", 300), 1000, new Rectangle(28, 6, 16, 58));
            this.bark = new PositionedStack((Object)ExtraTreeItems.Sawdust.get(1), 123, 6);
            this.sawDust = new PositionedStack((Object)ExtraTreeItems.Bark.get(1), 123, 48);
            this.results = new ArrayList<PositionedStack>();
            this.plank = new PositionedStack((Object)plank, 105, 27);
            this.wood = new PositionedStack((Object)wood, 53, 27);
            this.results.add(this.plank);
            this.results.add(this.bark);
            this.results.add(this.sawDust);
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.waterTank;
        }

        public PositionedStack getIngredient() {
            return this.wood;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.results;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

