/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.core.transformer;

import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusUtil;
import com.gtnewhorizon.gtnhlib.eventbus.MethodInfo;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.SideOnly;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class EventBusSubTransformer
implements IClassTransformer {
    private static final Logger LOGGER = LogManager.getLogger((String)"GTNHLib|EventBusSubTransformer");
    private static final String OPTIONAL_DESC = Type.getDescriptor(Optional.Method.class);
    private static final String SIDEONLY_DESC = Type.getDescriptor(SideOnly.class);
    private static final String SUBSCRIBE_DESC = Type.getDescriptor(SubscribeEvent.class);
    private static final String CONDITION_DESC = Type.getDescriptor(EventBusSubscriber.Condition.class);
    private static final List<String> ANNOTATIONS = Arrays.asList(OPTIONAL_DESC, SIDEONLY_DESC, SUBSCRIBE_DESC, CONDITION_DESC);
    private static final String CURRENT_SIDE = FMLLaunchHandler.side().name();
    private static final ObjectSet<String> classesToVisit = EventBusUtil.getClassesToVisit();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (classesToVisit.isEmpty() || !classesToVisit.contains(transformedName)) {
            return basicClass;
        }
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean changed = false;
        for (MethodNode mn : cn.methods) {
            Object2ObjectMap<String, AnnotationNode> usableAnnotations = EventBusSubTransformer.getUsableAnnotations(mn.visibleAnnotations);
            if (usableAnnotations.isEmpty()) continue;
            if (!this.matchesSide((AnnotationNode)usableAnnotations.get(SIDEONLY_DESC))) {
                if (!EventBusUtil.DEBUG_EVENT_BUS.booleanValue()) continue;
                LOGGER.info("Skipping method {} due to side mismatch", new Object[]{EventBusSubTransformer.getMethodKey(transformedName, mn)});
                continue;
            }
            AnnotationNode subscribe = (AnnotationNode)usableAnnotations.get(SUBSCRIBE_DESC);
            boolean condition = usableAnnotations.containsKey(CONDITION_DESC);
            if ((mn.access & 8) == 0) {
                if (condition || subscribe == null) continue;
                EventBusUtil.getInvalidMethods().add("Encountered unexpected non-static method: " + EventBusSubTransformer.getMethodKey(transformedName, mn));
                continue;
            }
            if (condition) {
                if (mn.desc.equals("()Z")) {
                    EventBusUtil.getConditionsToCheck().put(transformedName, mn.name + mn.desc);
                    changed |= EventBusSubTransformer.changeAccess(transformedName, mn);
                    continue;
                }
                EventBusUtil.getInvalidMethods().add("Invalid condition method: " + EventBusSubTransformer.getMethodKey(transformedName, mn) + ". Condition method must have no parameters and return a boolean.");
                continue;
            }
            if (subscribe == null) {
                if (!EventBusUtil.DEBUG_EVENT_BUS.booleanValue()) continue;
                LOGGER.info("Skipping method {} with annotations {}. No @SubscribeEvent found.", new Object[]{EventBusSubTransformer.getMethodKey(transformedName, mn), usableAnnotations.keySet()});
                continue;
            }
            changed |= EventBusSubTransformer.changeAccess(transformedName, mn);
            Object[] subscribeInfo = EventBusSubTransformer.getSubscribeInfo(subscribe);
            MethodInfo methodInfo = new MethodInfo(transformedName, mn.name, mn.desc, (Boolean)subscribeInfo[0], (EventPriority)subscribeInfo[1]);
            AnnotationNode optional = (AnnotationNode)usableAnnotations.get(OPTIONAL_DESC);
            if (optional != null) {
                List values = optional.values;
                methodInfo.setOptionalMod((String)values.get(1));
                if (EventBusUtil.DEBUG_EVENT_BUS.booleanValue()) {
                    LOGGER.info("Found optional mod {} for method {}", new Object[]{methodInfo.getOptionalMod(), methodInfo.getKey()});
                }
            }
            EventBusUtil.getMethodsToSubscribe().computeIfAbsent(transformedName, k -> new ObjectOpenHashSet()).add(methodInfo);
            if (!EventBusUtil.DEBUG_EVENT_BUS.booleanValue()) continue;
            LOGGER.info("Found subscribed method {}", new Object[]{methodInfo.getKey()});
        }
        if (changed) {
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return basicClass;
    }

    private static Object2ObjectMap<String, AnnotationNode> getUsableAnnotations(List<AnnotationNode> annotations) {
        if (annotations == null) {
            return Object2ObjectMaps.emptyMap();
        }
        Object2ObjectOpenHashMap<String, AnnotationNode> usable = new Object2ObjectOpenHashMap<String, AnnotationNode>();
        for (AnnotationNode ann : annotations) {
            if (!ANNOTATIONS.contains(ann.desc)) continue;
            usable.put(ann.desc, ann);
        }
        return usable;
    }

    private boolean matchesSide(AnnotationNode side) {
        if (side == null) {
            return true;
        }
        for (int x = 0; x < side.values.size() - 1; x += 2) {
            String[] array;
            Object key = side.values.get(x);
            Object value = side.values.get(x + 1);
            if (!(key instanceof String) || !key.equals("value") || !(value instanceof String[]) || (array = (String[])value)[1].equals(CURRENT_SIDE)) continue;
            return false;
        }
        return true;
    }

    private static Object[] getSubscribeInfo(AnnotationNode annotation) {
        Object[] info = new Object[]{false, EventPriority.NORMAL};
        if (annotation.values == null) {
            return info;
        }
        for (int i = 0; i < annotation.values.size() - 1; i += 2) {
            Object key = annotation.values.get(i);
            Object value = annotation.values.get(i + 1);
            if (!(key instanceof String)) continue;
            if (key.equals("receiveCanceled")) {
                info[0] = value;
                continue;
            }
            if (!key.equals("priority") || !(value instanceof String[])) continue;
            String[] array = (String[])value;
            info[1] = EventPriority.valueOf((String)array[1]);
        }
        return info;
    }

    private static boolean changeAccess(String className, MethodNode mn) {
        if ((mn.access & 1) == 0) {
            if (EventBusUtil.DEBUG_EVENT_BUS.booleanValue()) {
                LOGGER.info("Encountered condition or subscriber method with non-public access {}. Making it public.", new Object[]{EventBusSubTransformer.getMethodKey(className, mn)});
            }
            mn.access = (mn.access | 1) & 0xFFFFFFF9;
            return true;
        }
        return false;
    }

    private static String getMethodKey(String className, MethodNode mn) {
        return className + " " + mn.name + mn.desc;
    }
}

