/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer.rotations;

import net.minecraft.client.renderer.RenderBlocks;
import openmods.geometry.Orientation;
import openmods.reflection.ClonerFactory;
import openmods.renderer.FixedRenderBlocks;
import openmods.renderer.TweakedRenderBlocks;
import openmods.renderer.rotations.IRendererSetup;
import openmods.renderer.rotations.SideRotationConfigurator;

public abstract class ClonerSetup
implements IRendererSetup {
    static final IRendererSetup fixedSetup = new ClonerSetup(){

        @Override
        protected RenderBlocks createRenderer() {
            return new FixedRenderBlocks();
        }
    };
    static final IRendererSetup tweakedSetup = new ClonerSetup(){

        @Override
        protected RenderBlocks createRenderer() {
            return new TweakedRenderBlocks();
        }
    };
    private final SideRotationConfigurator configurator = new SideRotationConfigurator();
    private static final ClonerFactory.ICloner<RenderBlocks> CLONER = ClonerFactory.instance.getCloner(RenderBlocks.class);

    ClonerSetup() {
    }

    protected abstract RenderBlocks createRenderer();

    @Override
    public RenderBlocks enter(Orientation orientation, int metadata, RenderBlocks renderer) {
        RenderBlocks tweakedRenderer = this.createRenderer();
        CLONER.clone(renderer, tweakedRenderer);
        this.configurator.setupFaces(tweakedRenderer, orientation);
        return tweakedRenderer;
    }

    @Override
    public void exit(RenderBlocks renderer) {
    }
}

