/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import openmods.calc.Compilers;
import openmods.calc.Environment;
import openmods.calc.ExecutableList;
import openmods.calc.ExprType;
import openmods.calc.Frame;
import openmods.calc.ICompilerMapFactory;
import openmods.calc.IExecutable;
import openmods.calc.OperatorDictionary;
import openmods.calc.Value;
import openmods.calc.parsing.AstCompiler;
import openmods.calc.parsing.BracketPostfixCompilerStateBase;
import openmods.calc.parsing.DefaultExecutableListBuilder;
import openmods.calc.parsing.DefaultExprNodeFactory;
import openmods.calc.parsing.DefaultPostfixCompiler;
import openmods.calc.parsing.DummyNode;
import openmods.calc.parsing.IAstParser;
import openmods.calc.parsing.ICompilerState;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.IExprNodeFactory;
import openmods.calc.parsing.IPostfixCompilerState;
import openmods.calc.parsing.ISymbolCallStateTransition;
import openmods.calc.parsing.ITokenStreamCompiler;
import openmods.calc.parsing.IValueParser;
import openmods.calc.parsing.InfixParser;
import openmods.calc.parsing.MappedCompilerState;
import openmods.calc.parsing.PrefixParser;
import openmods.calc.parsing.SymbolGetPostfixCompilerState;
import openmods.calc.parsing.TokenIterator;
import openmods.calc.parsing.Tokenizer;

public class BasicCompilerMapFactory<E>
implements ICompilerMapFactory<E, ExprType> {
    public static final String BRACKET_CONSTANT_EVALUATE = "[";
    public static final String MODIFIER_SYMBOL_GET = "@";
    public static final String SYMBOL_PREFIX = "prefix";
    public static final String SYMBOL_INFIX = "infix";

    @Override
    public Compilers<E, ExprType> create(E nullValue, IValueParser<E> valueParser, OperatorDictionary<E> operators, Environment<E> environment) {
        Tokenizer prefixTokenizer = new Tokenizer();
        Tokenizer infixTokenizer = new Tokenizer();
        Tokenizer postfixTokenizer = new Tokenizer();
        for (String operator : operators.allOperators()) {
            prefixTokenizer.addOperator(operator);
            infixTokenizer.addOperator(operator);
            postfixTokenizer.addOperator(operator);
        }
        this.setupPrefixTokenizer(prefixTokenizer);
        this.setupInfixTokenizer(infixTokenizer);
        this.setupPostfixTokenizer(postfixTokenizer);
        DefaultExprNodeFactory<E> exprNodeFactory = this.createExprNodeFactory(valueParser);
        MappedCompilerState<E> prefixCompilerState = this.createPrefixCompilerState(operators, exprNodeFactory);
        MappedCompilerState<E> infixCompilerState = this.createInfixCompilerState(operators, exprNodeFactory);
        prefixCompilerState.addStateTransition(SYMBOL_INFIX, new ParserSwitchTransition<E>(infixCompilerState));
        prefixCompilerState.addStateTransition(SYMBOL_PREFIX, new ParserSwitchTransition<E>(prefixCompilerState));
        infixCompilerState.addStateTransition(SYMBOL_INFIX, new ParserSwitchTransition<E>(infixCompilerState));
        infixCompilerState.addStateTransition(SYMBOL_PREFIX, new ParserSwitchTransition<E>(prefixCompilerState));
        this.configureCompilerStateCommon(prefixCompilerState, environment);
        this.configureCompilerStateCommon(infixCompilerState, environment);
        HashMap compilers = Maps.newHashMap();
        compilers.put(ExprType.PREFIX, new WrappedCompiler(prefixTokenizer, this.createPrefixParser(prefixCompilerState)));
        compilers.put(ExprType.INFIX, new WrappedCompiler(infixTokenizer, this.createInfixParser(infixCompilerState)));
        compilers.put(ExprType.POSTFIX, new WrappedCompiler(postfixTokenizer, this.createPostfixParser(valueParser, operators, environment)));
        return new Compilers(compilers);
    }

    protected void setupPrefixTokenizer(Tokenizer tokenizer) {
    }

    protected MappedCompilerState<E> createCompilerState(IAstParser<E> parser) {
        return new MappedCompilerState<E>(parser);
    }

    protected MappedCompilerState<E> createPrefixCompilerState(OperatorDictionary<E> operators, IExprNodeFactory<E> exprNodeFactory) {
        PrefixParser<E> prefixParser = new PrefixParser<E>(operators, exprNodeFactory);
        return this.createCompilerState(prefixParser);
    }

    protected ITokenStreamCompiler<E> createPrefixParser(ICompilerState<E> compilerState) {
        return new AstCompiler<E>(compilerState);
    }

    protected void setupInfixTokenizer(Tokenizer tokenizer) {
    }

    protected MappedCompilerState<E> createInfixCompilerState(OperatorDictionary<E> operators, IExprNodeFactory<E> exprNodeFactory) {
        InfixParser<E> infixParser = new InfixParser<E>(operators, exprNodeFactory);
        return this.createCompilerState(infixParser);
    }

    protected ITokenStreamCompiler<E> createInfixParser(ICompilerState<E> compilerState) {
        return new AstCompiler<E>(compilerState);
    }

    protected void setupPostfixTokenizer(Tokenizer tokenizer) {
        tokenizer.addModifier(MODIFIER_SYMBOL_GET);
    }

    protected ITokenStreamCompiler<E> createPostfixParser(IValueParser<E> valueParser, OperatorDictionary<E> operators, Environment<E> env) {
        DefaultPostfixCompiler<E> compiler = new DefaultPostfixCompiler<E>(valueParser, operators);
        return BasicCompilerMapFactory.addSymbolGetState(BasicCompilerMapFactory.addConstantEvaluatorState(valueParser, operators, env, compiler));
    }

    public static <E> DefaultPostfixCompiler<E> addConstantEvaluatorState(IValueParser<E> valueParser, OperatorDictionary<E> operators, Environment<E> env, DefaultPostfixCompiler<E> compiler) {
        return compiler.addBracketStateProvider(BRACKET_CONSTANT_EVALUATE, BasicCompilerMapFactory.createConstantEvaluatorStateProvider(valueParser, operators, env, BRACKET_CONSTANT_EVALUATE));
    }

    public static <E> DefaultPostfixCompiler.IStateProvider<E> createConstantEvaluatorStateProvider(final IValueParser<E> valueParser, final OperatorDictionary<E> operators, final Environment<E> env, final String openingBracket) {
        return new DefaultPostfixCompiler.IStateProvider<E>(){

            @Override
            public IPostfixCompilerState<E> createState() {
                final DefaultExecutableListBuilder listBuilder = new DefaultExecutableListBuilder(valueParser, operators);
                class ConstantEvaluatorState
                extends BracketPostfixCompilerStateBase<E> {
                    ConstantEvaluatorState() {
                        super(iExecutableListBuilder, openingBracket);
                    }

                    @Override
                    protected IExecutable<E> processCompiledBracket(IExecutable<E> compiledExpr) {
                        Frame resultFrame = env.executeIsolated(compiledExpr);
                        ArrayList computedValues = Lists.newArrayList();
                        for (Object value : resultFrame.stack()) {
                            computedValues.add(Value.create(value));
                        }
                        return ExecutableList.wrap(computedValues);
                    }
                }
                return new ConstantEvaluatorState();
            }
        };
    }

    public static <E> DefaultPostfixCompiler<E> addSymbolGetState(DefaultPostfixCompiler<E> compiler) {
        return compiler.addModifierStateProvider(MODIFIER_SYMBOL_GET, new DefaultPostfixCompiler.IStateProvider<E>(){

            @Override
            public IPostfixCompilerState<E> createState() {
                return new SymbolGetPostfixCompilerState();
            }
        });
    }

    protected DefaultExprNodeFactory<E> createExprNodeFactory(IValueParser<E> valueParser) {
        return new DefaultExprNodeFactory<E>(valueParser);
    }

    protected void configureCompilerStateCommon(MappedCompilerState<E> compilerState, Environment<E> environment) {
    }

    public static class ParserSwitchTransition<E>
    implements ISymbolCallStateTransition<E> {
        private ICompilerState<E> switchState;

        public ParserSwitchTransition(ICompilerState<E> switchState) {
            this.switchState = switchState;
        }

        @Override
        public ICompilerState<E> getState() {
            return this.switchState;
        }

        @Override
        public IExprNode<E> createRootNode(List<IExprNode<E>> children) {
            Preconditions.checkState((children.size() == 1 ? 1 : 0) != 0, (String)"Expected one node, got %s", (Object[])new Object[]{children});
            return new DummyNode<E>(children.get(0));
        }
    }

    private static class WrappedCompiler<E>
    implements Compilers.ICompiler<E> {
        private final Tokenizer tokenizer;
        private final ITokenStreamCompiler<E> compiler;

        private WrappedCompiler(Tokenizer tokenizer, ITokenStreamCompiler<E> compiler) {
            this.tokenizer = tokenizer;
            this.compiler = compiler;
        }

        @Override
        public IExecutable<E> compile(String input) {
            TokenIterator tokens = this.tokenizer.tokenize(input);
            IExecutable<E> result = this.compiler.compile(tokens);
            if (tokens.hasNext()) {
                throw new IllegalStateException("Unconsumed tokens: " + Lists.newArrayList((Iterator)((Object)tokens)));
            }
            return result;
        }
    }
}

