/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.network.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import de.eydamos.backpack.Backpack;
import de.eydamos.backpack.network.message.MessageBackpackInfo;
import de.eydamos.backpack.saves.BackpackSave;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class MessageBackpackInfoRequest
implements IMessage,
IMessageHandler<MessageBackpackInfoRequest, IMessage> {
    private String backpackUUID;

    public MessageBackpackInfoRequest() {
    }

    public MessageBackpackInfoRequest(String uuid) {
        this.backpackUUID = uuid;
    }

    public void fromBytes(ByteBuf buf) {
        int length = buf.readInt();
        this.backpackUUID = new String(buf.readBytes(length).array());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.backpackUUID.length());
        buf.writeBytes(this.backpackUUID.getBytes());
    }

    public IMessage onMessage(MessageBackpackInfoRequest message, MessageContext ctx) {
        NBTTagCompound backpack = Backpack.saveFileHandler.loadBackpack(message.backpackUUID);
        BackpackSave backpackSave = new BackpackSave(backpack);
        int used = backpackSave.getInventory("backpack").func_74745_c();
        int total = backpackSave.getSize();
        return new MessageBackpackInfo(message.backpackUUID, used, total);
    }
}

