/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymapserver;

import java.util.List;
import net.techbrew.journeymapserver.bukkit.command.CommandJMServerBukkit;
import net.techbrew.journeymapserver.bukkit.events.BukkitEvents;
import net.techbrew.journeymapserver.bukkit.network.BukkitPacketHandler;
import net.techbrew.journeymapserver.bukkit.util.BukkitChat;
import net.techbrew.journeymapserver.bukkit.util.BukkitPlayerUtil;
import net.techbrew.journeymapserver.bukkit.util.BukkitWorldUtil;
import net.techbrew.journeymapserver.common.chat.ChatHandler;
import net.techbrew.journeymapserver.common.config.ConfigHandler;
import net.techbrew.journeymapserver.common.network.PacketManager;
import net.techbrew.journeymapserver.common.reference.Controller;
import net.techbrew.journeymapserver.common.util.LogHelper;
import net.techbrew.journeymapserver.common.util.PlayerUtil;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class JMServerBukkit
extends JavaPlugin {
    public static JMServerBukkit instance;

    public void onEnable() {
        Controller.setController(Controller.BUKKIT);
        LogHelper.info("JourneyMapSever Loading!");
        ConfigHandler.init(this.getDataFolder());
        PlayerUtil.init(new BukkitPlayerUtil());
        this.getServer().getPluginManager().registerEvents((Listener)new BukkitEvents(this), (Plugin)this);
        this.populateWorldsIDs(this.getServer().getWorlds());
        PacketManager.init(new BukkitPacketHandler(this));
        ChatHandler.init(new BukkitChat());
        this.getCommand("jmserver").setExecutor((CommandExecutor)new CommandJMServerBukkit(this));
    }

    public void onDisable() {
    }

    private void populateWorldsIDs(List<World> worlds) {
        for (World world : worlds) {
            String worldID = ConfigHandler.getConfigByWorldName(BukkitWorldUtil.getWorldNameFromWorld(world)).getWorldID();
            LogHelper.info(String.format("The ID for World: %s is %s", world.getName(), worldID));
        }
    }
}

