/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import cpw.mods.fml.common.registry.GameData;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import serverutils.lib.util.InvUtils;
import serverutils.lib.util.JsonUtils;

public final class ItemEntry {
    public static final ItemEntry EMPTY = new ItemEntry(null, 0, null, null);
    public final Item item;
    public final int metadata;
    public final NBTTagCompound nbt;
    public final NBTTagCompound caps;
    private int hashCode;
    private ItemStack stack = null;

    public static ItemEntry get(ItemStack stack) {
        if (stack == null) {
            return EMPTY;
        }
        Item item = stack.func_77973_b();
        int metadata = stack.func_77960_j();
        NBTTagCompound nbt0 = stack.func_77955_b(new NBTTagCompound());
        NBTTagCompound nbt = (NBTTagCompound)nbt0.func_74781_a("tag");
        NBTTagCompound caps = (NBTTagCompound)nbt0.func_74781_a("ForgeCaps");
        return new ItemEntry(item, metadata, nbt, caps);
    }

    public static ItemEntry fromJson(@Nullable JsonElement json0) {
        if (!JsonUtils.isNull(json0) && json0.isJsonObject()) {
            JsonObject json = json0.getAsJsonObject();
            Item item = null;
            if (json.has("item")) {
                item = (Item)GameData.getItemRegistry().func_82594_a((Object)new ResourceLocation(json.get("item").getAsString()));
            }
            if (item == null) {
                return EMPTY;
            }
            int meta = 0;
            if (json.has("data") && item.func_77614_k()) {
                meta = json.get("data").getAsInt();
            }
            NBTTagCompound nbt = null;
            if (json.has("nbt")) {
                nbt = (NBTTagCompound)JsonUtils.toNBT(json.get("nbt"));
            }
            NBTTagCompound caps = null;
            if (json.has("caps")) {
                caps = (NBTTagCompound)JsonUtils.toNBT(json.get("caps"));
            }
            return new ItemEntry(item, meta, nbt, caps);
        }
        return EMPTY;
    }

    public ItemEntry(Item i, int m, @Nullable NBTTagCompound n, @Nullable NBTTagCompound c) {
        this.item = i;
        this.metadata = m;
        this.nbt = n;
        this.caps = c;
        this.hashCode = 0;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.item, this.metadata, this.nbt, this.caps);
            if (this.hashCode == 0) {
                this.hashCode = 1;
            }
        }
        return this.hashCode;
    }

    public boolean equalsEntry(ItemEntry entry) {
        if (entry == this) {
            return true;
        }
        return this.item == entry.item && this.metadata == entry.metadata && Objects.equals(this.nbt, entry.nbt) && Objects.equals(this.caps, entry.caps);
    }

    public boolean equals(Object o) {
        return o == this || o != null && o.getClass() == ItemEntry.class && this.equalsEntry((ItemEntry)o);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(StringBuilder builder) {
        builder.append(GameData.getItemRegistry().func_148750_c((Object)this.item));
        builder.append(' ');
        if (this.metadata == Short.MAX_VALUE) {
            builder.append('*');
        } else {
            builder.append(this.metadata);
        }
        if (this.nbt != null || this.caps != null) {
            builder.append(' ');
            builder.append(this.nbt);
        }
        if (this.caps != null) {
            builder.append(' ');
            builder.append(this.caps);
        }
    }

    public ItemStack getStack(int count, boolean copy) {
        if (count <= 0 || this.isEmpty()) {
            return InvUtils.EMPTY_STACK;
        }
        if (this.stack == null) {
            this.stack = new ItemStack(this.item, 1, this.metadata);
            this.stack.func_77982_d(this.nbt);
        }
        ItemStack stack1 = copy ? this.stack.func_77946_l() : this.stack;
        stack1.field_77994_a = count;
        return stack1;
    }

    public JsonElement toJson() {
        ResourceLocation id = new ResourceLocation(GameData.getItemRegistry().func_148750_c((Object)this.item));
        if (!(this.nbt != null || this.caps != null || this.metadata != 0 && this.item.func_77614_k())) {
            return new JsonPrimitive(id == null ? "minecraft:air" : id.toString());
        }
        JsonObject json = new JsonObject();
        json.addProperty("item", id == null ? "minecraft:air" : id.toString());
        if (this.item.func_77614_k()) {
            json.addProperty("data", (Number)this.metadata);
        }
        if (this.nbt != null) {
            json.add("nbt", JsonUtils.toJson((NBTBase)this.nbt));
        }
        if (this.caps != null) {
            json.add("caps", JsonUtils.toJson((NBTBase)this.caps));
        }
        return json;
    }
}

