/*
 * Decompiled with CFR 0.152.
 */
package serverutils.aurora;

import cpw.mods.fml.common.eventhandler.Event;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import serverutils.aurora.AuroraPageEvent;
import serverutils.aurora.PageType;
import serverutils.aurora.page.HomePage;
import serverutils.aurora.page.WebPage;
import serverutils.aurora.page.WebPageNotFound;
import serverutils.aurora.page.WebPageUnauthorized;

public class AuroraServer {
    private final MinecraftServer server;
    private final int port;
    private ChannelFuture channel;
    private final EventLoopGroup masterGroup;
    private final EventLoopGroup slaveGroup;
    private byte[] iconBytes = null;

    public AuroraServer(MinecraftServer s, int p) {
        this.server = s;
        this.port = p;
        this.masterGroup = new NioEventLoopGroup();
        this.slaveGroup = new NioEventLoopGroup();
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    void start() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.group(this.masterGroup, this.slaveGroup);
            bootstrap.channel(NioServerSocketChannel.class);
            bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(final SocketChannel ch) {
                    ch.pipeline().addLast("codec", (ChannelHandler)new HttpServerCodec());
                    ch.pipeline().addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(524288));
                    ch.pipeline().addLast("request", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            if (msg instanceof FullHttpRequest) {
                                AuroraServer.this.handleRequest(ch, ctx, (FullHttpRequest)msg);
                            } else {
                                super.channelRead(ctx, msg);
                            }
                        }

                        public void channelReadComplete(ChannelHandlerContext ctx) {
                            ctx.flush();
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.copiedBuffer((byte[])cause.getMessage().getBytes())));
                        }
                    });
                }
            });
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)128);
            bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            this.channel = bootstrap.bind(this.port).sync();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void shutdown() {
        this.slaveGroup.shutdownGracefully();
        this.masterGroup.shutdownGracefully();
        try {
            this.channel.channel().closeFuture().sync();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void handleRequest(SocketChannel channel, ChannelHandlerContext ctx, FullHttpRequest request) {
        String contentType;
        String content;
        WebPage page;
        String uri = request.getUri();
        while (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        while (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (uri.isEmpty()) {
            page = new HomePage(this);
        } else {
            try {
                AuroraPageEvent event = new AuroraPageEvent(this, request, uri);
                MinecraftForge.EVENT_BUS.post((Event)event);
                page = event.getPage();
                if (page != null && page.getPageType() != PageType.ENABLED && !System.getProperty("AuroraIgnoreAuth", "0").equals("1")) {
                    page = new WebPageUnauthorized(event.getUri());
                }
                if (page == null) {
                    page = new WebPageNotFound(event.getUri());
                }
            }
            catch (Exception ex) {
                page = new WebPageNotFound("errored");
                ex.printStackTrace();
            }
        }
        try {
            content = page.getContent();
            contentType = page.getContentType();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            printWriter.println("Error!");
            printWriter.println();
            ex.printStackTrace(printWriter);
            content = writer.toString();
            contentType = "text/plain";
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, page.getStatus(), Unpooled.copiedBuffer((byte[])content.getBytes()));
        if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
            response.headers().set("Connection", (Object)"keep-alive");
        }
        response.headers().set("Content-Type", (Object)contentType);
        response.headers().set("Content-Length", (Object)content.length());
        response.headers().set("Access-Control-Allow-Origin", (Object)"*");
        ctx.writeAndFlush((Object)response);
    }

    public boolean allow(String uri) {
        return true;
    }
}

