/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.datasource.bridge;

import com.mysql.jdbc.Driver;
import eu.usrv.yamcore.YAMCore;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.datasource.bridge.BridgeSQL;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class BridgeMySQL
extends BridgeSQL {
    private LogHelper _mLog = YAMCore.instance.getLogger();
    private String _mDBUser;
    private String _mDBPW;
    private String _mDBHost;
    private String _mDBDB;

    public BridgeMySQL(String pDBHost, String pDBUsername, String pDBPassword, String pDBDBName) {
        this._mDBUser = pDBUsername;
        this._mDBPW = pDBPassword;
        this._mDBHost = pDBHost;
        this._mDBDB = pDBDBName;
        this.initProperties();
        this.initConnection();
    }

    @Override
    protected void initProperties() {
        this.autoIncrement = "AUTO_INCREMENT";
        this.properties.put("autoReconnect", "true");
        this.properties.put("user", this._mDBUser);
        this.properties.put("password", this._mDBPW);
        this.properties.put("relaxAutoCommit", "true");
    }

    @Override
    protected void initConnection() {
        this.dsn = "jdbc:mysql://" + this._mDBHost + "/" + this._mDBDB;
        try {
            DriverManager.registerDriver((java.sql.Driver)new Driver());
        }
        catch (SQLException ex) {
            this._mLog.error("Failed to register driver for MySQL database.");
            this._mLog.error(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                try {
                    this.conn.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                this.conn = null;
            }
            this.conn = DriverManager.getConnection(this.dsn, this.properties);
        }
        catch (SQLException ex) {
            this._mLog.error("Failed to get SQL connection!");
            this._mLog.error(ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }
}

