/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.coast;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoWaterGrass;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.NoiseGenerator;

public class RealisticBiomeCoastDunes
extends RealisticBiomeBase {
    public RealisticBiomeCoastDunes() {
        super(0, RWGBiomes.baseOceanTemperate);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, NoiseGenerator perlin, CellNoise cell, float strength, float river) {
        int l14 = 0;
        while ((float)l14 < 11.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = 64 + rand.nextInt(64);
            int j24 = chunkY + rand.nextInt(16) + 8;
            if (rand.nextInt(5) == 0) {
                new DecoWaterGrass((Block)Blocks.field_150398_cm, 2, 69).func_76484_a(world, rand, l19, k22, j24);
            }
            if (rand.nextInt(3) == 0) {
                new DecoWaterGrass((Block)Blocks.field_150362_t, 4, 67).func_76484_a(world, rand, l19, k22, j24);
            } else {
                new DecoWaterGrass((Block)Blocks.field_150329_H, 1, 65).func_76484_a(world, rand, l19, k22, j24);
            }
            ++l14;
        }
    }

    @Override
    public float rNoise(NoiseGenerator perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        float h;
        river = river > 0.5f ? 1.0f : river * 2.0f;
        float f = h = ocean < 0.5f ? ocean * 18.0f : 9.0f;
        if (ocean < 1.9f) {
            float st = (1.9f - ocean) * 20.0f;
            st = st > 1.0f ? 1.0f : st;
            h += perlin.noise2((float)x / 12.0f, (float)y / 12.0f) * 1.0f;
            h += perlin.noise2((float)x / 23.0f, (float)y / 23.0f) * 2.0f;
        }
        if (ocean > 1.0f) {
            h += perlin.noise2((float)x / 15.0f, (float)y / 15.0f) * (ocean - 1.0f) * 8.0f;
            h += perlin.noise2((float)x / 25.0f, (float)y / 25.0f) * (ocean - 1.0f) * 13.0f;
            h += (ocean - 1.0f) * 9.0f;
        }
        return 55.0f + h;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, NoiseGenerator perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float cliff = CliffCalculator.calc(x, y, noise);
        boolean sand = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            ++depth;
            if (cliff > 1.3f) {
                if (depth > -1 && depth < 2) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (depth >= 10) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                continue;
            }
            if (depth == 0) {
                if (k > 68) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                sand = true;
                continue;
            }
            if (depth >= 5) continue;
            if (sand) {
                if (depth < 4) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
        }
    }
}

