/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.utils.JsonArrayBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Consumer;

public class JsonBuilder {
    private final JsonObject json;

    public JsonBuilder(JsonObject json) {
        this.json = json;
    }

    public JsonBuilder() {
        this(new JsonObject());
    }

    public JsonObject getJson() {
        return this.json;
    }

    public JsonBuilder add(String key, JsonElement element) {
        this.json.add(key, element);
        return this;
    }

    public JsonBuilder mergeAdd(String key, JsonObject element) {
        JsonElement merged = this.json.get(key);
        if (merged == null || !merged.isJsonObject()) {
            return this.add(key, (JsonElement)element);
        }
        JsonObject mergedObj = merged.getAsJsonObject();
        for (Map.Entry entry : element.entrySet()) {
            mergedObj.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return this;
    }

    public JsonBuilder add(String key, String element) {
        this.json.addProperty(key, element);
        return this;
    }

    public JsonBuilder add(String key, Number element) {
        this.json.addProperty(key, element);
        return this;
    }

    public JsonBuilder add(String key, boolean element) {
        this.json.addProperty(key, Boolean.valueOf(element));
        return this;
    }

    public JsonBuilder add(String key, char element) {
        this.json.addProperty(key, Character.valueOf(element));
        return this;
    }

    public JsonBuilder add(String key, JsonBuilder element) {
        return this.add(key, (JsonElement)element.getJson());
    }

    public JsonBuilder add(String key, JsonArrayBuilder element) {
        return this.add(key, (JsonElement)element.getJson());
    }

    public JsonBuilder mergeAdd(String key, JsonBuilder element) {
        return this.mergeAdd(key, element.getJson());
    }

    public JsonBuilder addObject(String key, Consumer<JsonBuilder> builderConsumer) {
        JsonBuilder builder = new JsonBuilder();
        builderConsumer.accept(builder);
        return this.add(key, (JsonElement)builder.getJson());
    }

    public JsonBuilder addArray(String key, Consumer<JsonArrayBuilder> builderConsumer) {
        JsonArrayBuilder builder = new JsonArrayBuilder();
        builderConsumer.accept(builder);
        return this.add(key, (JsonElement)builder.getJson());
    }

    public JsonBuilder addAllOf(JsonObject json) {
        for (Map.Entry entry : json.entrySet()) {
            this.json.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return this;
    }

    public JsonBuilder addAllOf(JsonBuilder json) {
        return this.addAllOf(json.getJson());
    }
}

