/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Locale;
import li.cil.oc.api.event.RobotAnalyzeEvent;
import li.cil.oc.api.event.RobotRenderEvent;
import li.cil.oc.api.internal.Agent;
import li.cil.oc.api.internal.Robot;
import li.cil.oc.api.network.Node;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import org.lwjgl.opengl.GL11;
import pl.asie.computronics.item.ItemOpenComputers;
import pl.asie.computronics.oc.driver.RobotUpgradeColorful;

public class ColorfulUpgradeHandler {
    @SubscribeEvent
    @Optional.Method(modid="OpenComputers")
    public void onRobotAnalyze(RobotAnalyzeEvent e) {
        int color = this.getColor(e.agent);
        if (color < 0) {
            return;
        }
        e.player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.computronics.colorful_upgrade.color", new Object[]{"0x" + String.format("%06x", color).toUpperCase(Locale.ENGLISH)}));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @Optional.Method(modid="OpenComputers")
    public void onRobotRender(RobotRenderEvent e) {
        int color = -1;
        if (e.agent instanceof Robot) {
            Robot robot = (Robot)e.agent;
            for (int i = 0; i < robot.func_70302_i_(); ++i) {
                int newcol;
                NBTTagCompound tag;
                ItemStack stack = robot.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemOpenComputers) || stack.func_77960_j() != 7 || !(tag = ((ItemOpenComputers)stack.func_77973_b()).dataTag(stack)).func_74764_b("computronics:color") || (newcol = tag.func_74762_e("computronics:color")) <= color) continue;
                color = newcol;
            }
        }
        if (color < 0) {
            return;
        }
        GL11.glColor3ub((byte)((byte)((color &= 0xFFFFFF) >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
    }

    @Optional.Method(modid="OpenComputers")
    private int getColor(Agent agent) {
        try {
            for (Node node : agent.machine().node().reachableNodes()) {
                if (node == null || !(node.host() instanceof RobotUpgradeColorful)) continue;
                return ((RobotUpgradeColorful)node.host()).getColor();
            }
        }
        catch (NullPointerException e) {
            return -1;
        }
        return -1;
    }
}

