/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.client.gui.tabs;

import de.katzenpapst.amunra.client.gui.GuiMothershipSettings;
import de.katzenpapst.amunra.client.gui.elements.StringSelectBox;
import de.katzenpapst.amunra.client.gui.tabs.AbstractTab;
import de.katzenpapst.amunra.helper.PlayerID;
import de.katzenpapst.amunra.mothership.Mothership;
import de.katzenpapst.amunra.tile.TileEntityMothershipSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementDropdown;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementTextBox;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;

public abstract class AbstractPermissionTab
extends AbstractTab
implements GuiElementDropdown.IDropboxCallback,
GuiElementTextBox.ITextBoxCallback,
StringSelectBox.ISelectBoxCallback,
GuiMothershipSettings.IMothershipSettingsTab {
    protected final TileEntityMothershipSettings tile;
    protected GuiElementDropdown modeDropdown;
    protected GuiElementTextBox textBoxUsername;
    protected StringSelectBox selectBox;
    protected GuiButton addBtn;
    protected GuiButton rmBtn;
    protected final List<PlayerID> playerIdList = new ArrayList<PlayerID>();
    protected final Map<Mothership.PermissionMode, String> permissionModeMap = new HashMap<Mothership.PermissionMode, String>();
    protected String error = "";
    protected float errorTime = 0.0f;

    public AbstractPermissionTab(TileEntityMothershipSettings tile, GuiMothershipSettings parent, Minecraft mc, int width, int height, int xSize, int ySize) {
        super(parent, mc, width, height, xSize, ySize);
        this.tile = tile;
        this.permissionModeMap.put(Mothership.PermissionMode.ALL, GCCoreUtil.translate((String)"tile.mothershipSettings.permission.allowAll"));
        this.permissionModeMap.put(Mothership.PermissionMode.NONE, GCCoreUtil.translate((String)"tile.mothershipSettings.permission.allowNone"));
        this.permissionModeMap.put(Mothership.PermissionMode.WHITELIST, GCCoreUtil.translate((String)"tile.mothershipSettings.permission.whitelist"));
        this.permissionModeMap.put(Mothership.PermissionMode.BLACKLIST, GCCoreUtil.translate((String)"tile.mothershipSettings.permission.blacklist"));
    }

    protected abstract void addUsername(Mothership var1, String var2);

    protected abstract void removeUsernameFromList(int var1);

    @Override
    public boolean actionPerformed(GuiButton btn) {
        if (btn == this.addBtn) {
            this.addUsername(this.tile.getMothership(), this.textBoxUsername.text);
            this.textBoxUsername.text = "";
            this.addBtn.field_146124_l = false;
            return true;
        }
        if (btn == this.rmBtn) {
            int selection = this.selectBox.getSelectedStringIndex();
            if (selection != -1) {
                this.removeUsernameFromList(selection);
                this.selectBox.clearSelection();
                this.applyData();
            }
            return true;
        }
        return false;
    }

    public abstract void resetData();

    @Override
    public void mothershipResponsePacketRecieved() {
        this.resetData();
    }

    protected String[] getDropdownOptions() {
        int num = Mothership.PermissionMode.values().length;
        String[] result = new String[num];
        for (int i = 0; i < num; ++i) {
            result[i] = this.permissionModeMap.get((Object)Mothership.PermissionMode.values()[i]);
        }
        return result;
    }

    protected void applyData() {
        GuiMothershipSettings actualParent = (GuiMothershipSettings)this.parent;
        actualParent.sendMothershipSettingsPacket();
    }

    @Override
    public void initGui() {
        int guiX = (this.width - this.xSize) / 2;
        int guiY = (this.height - this.ySize) / 2;
        this.modeDropdown = new GuiElementDropdown(1, (GuiElementDropdown.IDropboxCallback)this, guiX + 90, guiY + 14, this.getDropdownOptions());
        this.textBoxUsername = new GuiElementTextBox(2, (GuiElementTextBox.ITextBoxCallback)this, guiX + 5, guiY + 30, 95, 20, "", false, 50, false);
        this.selectBox = new StringSelectBox(this, 3, guiX + 5, guiY + 50, 95, 50);
        this.addBtn = new GuiButton(4, guiX + 100, guiY + 30, 70, 20, GCCoreUtil.translate((String)"tile.mothershipSettings.permission.addUser"));
        this.rmBtn = new GuiButton(5, guiX + 100, guiY + 50, 70, 20, GCCoreUtil.translate((String)"tile.mothershipSettings.permission.removeUser"));
        this.rmBtn.field_146124_l = false;
        this.addBtn.field_146124_l = false;
        this.addButton((GuiButton)this.modeDropdown);
        this.addButton(this.selectBox);
        this.addButton(this.addBtn);
        this.addButton(this.rmBtn);
        this.addTextBox(this.textBoxUsername);
        this.resetData();
    }

    @Override
    public void onTabActivated() {
        this.resetData();
    }

    @Override
    protected void drawExtraScreenElements(int mouseX, int mouseY, float ticks) {
        int guiX = (this.width - this.xSize) / 2;
        int guiY = (this.height - this.ySize) / 2;
        this.fontRendererObj.func_78276_b(this.getTooltip(), guiX + 5, guiY + 5, 0x404040);
        this.fontRendererObj.func_78276_b(GCCoreUtil.translate((String)"tile.mothershipSettings.permission.allowLabel") + ":", guiX + 9, guiY + 16, 0x404040);
        if (this.errorTime > 0.0f) {
            this.fontRendererObj.func_78279_b(this.error, guiX + 102, guiY + 80, 70, 0x404040);
            this.errorTime -= ticks;
        }
        this.fontRendererObj.func_78276_b(GCCoreUtil.translate((String)"container.inventory"), guiX + 8, guiY + this.ySize - 94, 0x404040);
    }

    public boolean canBeClickedBy(GuiElementDropdown dropdown, EntityPlayer player) {
        return true;
    }

    public abstract int getInitialSelection(GuiElementDropdown var1);

    public void onIntruderInteraction() {
    }

    public boolean canPlayerEdit(GuiElementTextBox textBox, EntityPlayer player) {
        return true;
    }

    public void onTextChanged(GuiElementTextBox textBox, String newText) {
        this.addBtn.field_146124_l = newText != null && !newText.isEmpty();
    }

    public String getInitialText(GuiElementTextBox textBox) {
        return "";
    }

    public int getTextColor(GuiElementTextBox textBox) {
        return -15401196;
    }

    public void onIntruderInteraction(GuiElementTextBox textBox) {
    }

    @Override
    public void onSelectionChanged(StringSelectBox box, int selection) {
        this.rmBtn.field_146124_l = box.hasSelection();
    }

    @Override
    public void mothershipOperationFailed(String message) {
        this.error = message;
        this.errorTime = 60.0f;
    }
}

