/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.harvestcraft;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import java.awt.Point;
import java.util.Map;
import net.minecraft.item.ItemStack;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public abstract class RecipeHandlerHCBase
extends RecipeHandlerBase {
    protected abstract String getRecipeSubID();

    public String getGuiTexture() {
        return String.format("neiintegration:textures/harvestcraft/%s.png", this.getRecipeSubID());
    }

    @Override
    public String getRecipeID() {
        return "harvestcraft." + this.getRecipeSubID();
    }

    public Point getInputStackPos() {
        return new Point(45, 4);
    }

    public Point getOutputStackPos() {
        return new Point(105, 22);
    }

    public Point getFuelStackPos() {
        return new Point(45, 40);
    }

    public void loadTransferRects() {
        this.addTransferRect(68, 21, 24, 17);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)160, (int)65);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(68, 21, 160, 0, 24, 16, 80, 0);
    }

    public abstract Map<ItemStack, ItemStack> getRecipes();

    public ItemStack getFuelItem() {
        return null;
    }

    @Override
    public void loadAllRecipes() {
        for (Map.Entry<ItemStack, ItemStack> recipe : this.getRecipes().entrySet()) {
            this.arecipes.add(new CachedHCRecipe(recipe.getKey(), recipe.getValue(), this.getFuelItem()));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ItemStack, ItemStack> recipe : this.getRecipes().entrySet()) {
            if (!Utils.areStacksSameTypeCraftingSafe(recipe.getValue(), result)) continue;
            this.arecipes.add(new CachedHCRecipe(recipe.getKey(), recipe.getValue(), this.getFuelItem()));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        ingredient = ingredient.func_77946_l();
        ingredient.field_77994_a = 1;
        if (Utils.areStacksSameTypeCraftingSafe(this.getFuelItem(), ingredient)) {
            for (Map.Entry<ItemStack, ItemStack> recipe : this.getRecipes().entrySet()) {
                this.arecipes.add(new CachedHCRecipe(recipe.getKey(), recipe.getValue(), ingredient));
            }
            return;
        }
        for (Map.Entry<ItemStack, ItemStack> recipe : this.getRecipes().entrySet()) {
            if (!Utils.areStacksSameTypeCraftingSafe(recipe.getKey(), ingredient)) continue;
            this.arecipes.add(new CachedHCRecipe(ingredient, recipe.getValue(), this.getFuelItem()));
        }
    }

    public class CachedHCRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedStack input;
        public PositionedStack output;
        public PositionedStack fuel;

        public CachedHCRecipe(ItemStack input, ItemStack output, ItemStack fuel) {
            super(RecipeHandlerHCBase.this);
            Point inputStackPos = RecipeHandlerHCBase.this.getInputStackPos();
            Point outputStackPos = RecipeHandlerHCBase.this.getOutputStackPos();
            Point fuelStackPos = RecipeHandlerHCBase.this.getFuelStackPos();
            this.input = new PositionedStack((Object)input, inputStackPos.x, inputStackPos.y);
            this.output = new PositionedStack((Object)output, outputStackPos.x, outputStackPos.y);
            if (fuel != null) {
                this.fuel = new PositionedStack((Object)fuel, fuelStackPos.x, fuelStackPos.y);
            }
        }

        public PositionedStack getIngredient() {
            this.randomRenderPermutation(this.input, RecipeHandlerHCBase.this.cycleticks / 40);
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public PositionedStack getOtherStack() {
            return this.fuel;
        }
    }
}

