/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.coremod.registries;

import appeng.api.networking.IGridHost;
import appeng.parts.automation.PartLevelEmitter;
import com.glodblock.github.api.registries.ILevelTerminalRegistry;
import com.glodblock.github.api.registries.ILevelViewable;
import com.glodblock.github.api.registries.ILevelViewableAdapter;
import com.glodblock.github.common.parts.PartFluidLevelEmitter;
import com.glodblock.github.common.tile.TileLevelMaintainer;
import com.glodblock.github.coremod.registries.adapters.PartFluidLevelEmitterAdapter;
import com.glodblock.github.coremod.registries.adapters.PartLevelEmitterAdapter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class LevelTerminalRegistry
implements ILevelTerminalRegistry {
    private final Set<Class<? extends ILevelViewable>> supportedClasses = new HashSet<Class<? extends ILevelViewable>>();
    private final Map<Class<? extends ILevelViewable>, Class<? extends IGridHost>> adapterMap = new WeakHashMap<Class<? extends ILevelViewable>, Class<? extends IGridHost>>();
    private final Map<Class<? extends ILevelViewable>, ILevelViewableAdapter> adapterInstanceMap = new WeakHashMap<Class<? extends ILevelViewable>, ILevelViewableAdapter>();

    public LevelTerminalRegistry() {
        this.register(TileLevelMaintainer.class);
        this.register(PartFluidLevelEmitter.class, new PartFluidLevelEmitterAdapter());
        this.register(PartLevelEmitter.class, new PartLevelEmitterAdapter());
    }

    @Override
    public Set<Class<? extends ILevelViewable>> getSupportedClasses() {
        return this.supportedClasses;
    }

    @Override
    public boolean isAdopted(Class<? extends ILevelViewable> clazz) {
        return this.adapterMap.containsKey(clazz);
    }

    @Override
    public Class<? extends IGridHost> getAdopted(Class<? extends ILevelViewable> clazz) {
        return this.adapterMap.getOrDefault(clazz, null);
    }

    @Override
    public ILevelViewableAdapter getAdapter(Class<? extends ILevelViewable> clazz) {
        return this.adapterInstanceMap.getOrDefault(clazz, null);
    }

    public static ILevelTerminalRegistry instance() {
        return Singleton.INSTANCE;
    }

    @Override
    public void register(Class<? extends ILevelViewable> clazz) {
        this.supportedClasses.add(clazz);
    }

    @Override
    public void register(Class<? extends IGridHost> aeClass, ILevelViewableAdapter adapter) {
        Class<?> aClass = adapter.getClass();
        this.supportedClasses.add(aClass);
        this.adapterMap.put(aClass, aeClass);
        this.adapterInstanceMap.put(aClass, adapter);
    }

    private static class Singleton {
        private static final ILevelTerminalRegistry INSTANCE = new LevelTerminalRegistry();

        private Singleton() {
        }
    }
}

