/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IBoxProvider;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.client.texture.CableBusTextures;
import appeng.me.GridAccessException;
import appeng.util.item.AEFluidStack;
import com.glodblock.github.client.textures.FCPartsTexture;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.parts.base.FCSharedFluidBus;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PartFluidImportBus
extends FCSharedFluidBus {
    private final BaseActionSource source;

    public PartFluidImportBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, (Enum)YesNo.NO);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, (Enum)SchedulingMode.DEFAULT);
        this.source = new MachineSource((IActionHost)this);
    }

    @Override
    public IIcon getFaceIcon() {
        return FCPartsTexture.PartFluidImportBus.getIcon();
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(5, 40, this.isSleeping(), false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.canDoBusWork() ? this.doBusWork() : TickRateModulation.IDLE;
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        TileEntity te = this.getConnectedTE();
        if (te instanceof IFluidHandler) {
            try {
                IFluidHandler fh = (IFluidHandler)te;
                FluidTankInfo[] tanksInfo = fh.getTankInfo(this.getSide().getOpposite());
                if (tanksInfo == null) {
                    return TickRateModulation.SLOWER;
                }
                IMEMonitor inv = this.getProxy().getStorage().getFluidInventory();
                int maxDrain = this.calculateAmountToSend();
                boolean drained = false;
                for (FluidTankInfo tankInfo : tanksInfo) {
                    AEFluidStack aeFluidStack;
                    if (tankInfo.fluid == null) continue;
                    FluidStack fluidStack = new FluidStack(tankInfo.fluid, Math.min(tankInfo.fluid.amount, maxDrain));
                    fluidStack = fh.drain(this.getSide().getOpposite(), fluidStack, false);
                    if (this.filterEnabled() && !this.isInFilter(fluidStack) || (aeFluidStack = AEFluidStack.create((Object)fluidStack)) == null) continue;
                    IAEFluidStack notInserted = (IAEFluidStack)inv.injectItems((IAEStack)aeFluidStack, Actionable.MODULATE, this.source);
                    if (notInserted != null && notInserted.getStackSize() > 0L) {
                        aeFluidStack.decStackSize(notInserted.getStackSize());
                    }
                    fh.drain(this.getSide().getOpposite(), aeFluidStack.getFluidStack(), true);
                    maxDrain -= aeFluidStack.getFluidStack().amount;
                    drained = true;
                }
                return drained ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
            }
            catch (GridAccessException e) {
                e.printStackTrace();
            }
        }
        return TickRateModulation.SLEEP;
    }

    @Override
    protected boolean canDoBusWork() {
        return this.getProxy().isActive();
    }

    private boolean isInFilter(FluidStack fluid) {
        for (int i = 0; i < this.getInventoryByName("config").func_70302_i_(); ++i) {
            AEFluidStack stack = AEFluidStack.create((Object)ItemFluidPacket.getFluidStack(this.getInventoryByName("config").func_70301_a(i)));
            if (stack == null || !stack.getFluidStack().equals((Object)fluid)) continue;
            return true;
        }
        return false;
    }

    private boolean filterEnabled() {
        for (int i = 0; i < this.getInventoryByName("config").func_70302_i_(); ++i) {
            AEFluidStack stack = AEFluidStack.create((Object)ItemFluidPacket.getFluidStack(this.getInventoryByName("config").func_70301_a(i)));
            if (stack == null) continue;
            return true;
        }
        return false;
    }

    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.getFaceIcon(), CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartImportSides.getIcon());
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 15.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderInventoryBox(renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, (IBoxProvider)this, this.getRenderCache()));
        rh.setTexture(CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.getFaceIcon(), CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartImportSides.getIcon());
        rh.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(6.0f, 6.0f, 12.0f, 10.0f, 10.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.getFaceIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon());
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }
}

