/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.render;

import chylex.hee.gui.GuiEnderCompendium;
import chylex.hee.mechanics.compendium.content.KnowledgeFragment;
import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.objects.IKnowledgeObjectInstance;
import chylex.hee.mechanics.compendium.player.PlayerCompendiumData;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import org.lwjgl.opengl.GL11;

public class ObjectDisplayElement {
    public final KnowledgeObject<IKnowledgeObjectInstance<?>> object;
    public final int y;

    public ObjectDisplayElement(KnowledgeObject<IKnowledgeObjectInstance<?>> object, int y) {
        this.object = object;
        this.y = y;
    }

    public void render(GuiScreen gui, PlayerCompendiumData compendiumData, int yLowerBound, int yUpperBound) {
        int x = 32 + this.object.getX();
        int y = this.y + this.object.getY();
        if (y < yLowerBound || y > yUpperBound) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BackgroundTile tile = BackgroundTile.DISABLED;
        if (compendiumData.hasDiscoveredObject(this.object)) {
            boolean hasAll = true;
            for (KnowledgeFragment fragment : this.object.getFragments()) {
                if (compendiumData.hasUnlockedFragment(fragment)) continue;
                hasAll = false;
                break;
            }
            tile = hasAll ? BackgroundTile.GOLD : BackgroundTile.PLAIN;
        }
        RenderHelper.func_74518_a();
        gui.field_146297_k.func_110434_K().func_110577_a(GuiEnderCompendium.texBack);
        gui.func_73729_b(x, y, (int)tile.x, (int)tile.y, 22, 22);
        RenderHelper.func_74520_c();
        GuiEnderCompendium.renderItem.renderItemIntoGUI(gui.field_146297_k.field_71466_p, gui.field_146297_k.func_110434_K(), this.object.getItemStack(), x + 3, y + 3, true);
    }

    public boolean isMouseOver(int mouseX, int mouseY, int offsetY) {
        int x = 32 + this.object.getX();
        int y = this.y + this.object.getY() + offsetY;
        return mouseX >= x && mouseY >= y && mouseX <= x + 20 && mouseY <= y + 20;
    }

    private static enum BackgroundTile {
        PLAIN(113, 0),
        DISABLED(113, 23),
        CHECKERED(136, 0),
        BRIGHT(136, 23),
        GOLD(159, 0);

        final byte x;
        final byte y;

        private BackgroundTile(int x, int y) {
            this.x = (byte)x;
            this.y = (byte)y;
        }
    }
}

