/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.managers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import mcp.mobius.mobiuscore.monitors.MonitoredTileList;
import mcp.mobius.mobiuscore.profiler.ProfilerSection;
import mcp.mobius.opis.data.holders.basetypes.AmountHolder;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesBlock;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesChunk;
import mcp.mobius.opis.data.holders.newtypes.DataBlockTileEntity;
import mcp.mobius.opis.data.holders.newtypes.DataBlockTileEntityPerClass;
import mcp.mobius.opis.data.holders.newtypes.DataTileEntity;
import mcp.mobius.opis.data.holders.newtypes.DataTiming;
import mcp.mobius.opis.data.holders.stats.StatsChunk;
import mcp.mobius.opis.data.profilers.ProfilerTileEntityUpdate;
import mcp.mobius.opis.helpers.ModIdentification;
import mcp.mobius.opis.modOpis;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public enum TileEntityManager {
    INSTANCE;


    public HashMap<CoordinatesChunk, StatsChunk> getTimes(int dim) {
        HashMap<CoordinatesChunk, StatsChunk> chunks = new HashMap<CoordinatesChunk, StatsChunk>();
        for (CoordinatesBlock coord : ((ProfilerTileEntityUpdate)ProfilerSection.TILEENT_UPDATETIME.getProfiler()).data.keySet()) {
            if (coord.dim != dim) continue;
            CoordinatesChunk coordC = new CoordinatesChunk(coord);
            if (!chunks.containsKey(coordC)) {
                chunks.put(coordC, new StatsChunk());
            }
            chunks.get(coordC).addEntity();
            chunks.get(coordC).addMeasure(((ProfilerTileEntityUpdate)ProfilerSection.TILEENT_UPDATETIME.getProfiler()).data.get(coord).getGeometricMean());
        }
        return chunks;
    }

    private void cleanUpStats() {
    }

    public ArrayList<DataBlockTileEntity> getTileEntitiesInChunk(CoordinatesChunk coord) {
        this.cleanUpStats();
        ArrayList<DataBlockTileEntity> returnList = new ArrayList<DataBlockTileEntity>();
        for (CoordinatesBlock tecoord : ((ProfilerTileEntityUpdate)ProfilerSection.TILEENT_UPDATETIME.getProfiler()).data.keySet()) {
            if (!coord.equals(tecoord.asCoordinatesChunk())) continue;
            DataBlockTileEntity testats = new DataBlockTileEntity().fill(tecoord);
            returnList.add(testats);
        }
        return returnList;
    }

    public ArrayList<DataBlockTileEntity> getWorses(int amount) {
        ArrayList<DataBlockTileEntity> sorted = new ArrayList<DataBlockTileEntity>();
        ArrayList<DataBlockTileEntity> topEntities = new ArrayList<DataBlockTileEntity>();
        for (CoordinatesBlock coord : ((ProfilerTileEntityUpdate)ProfilerSection.TILEENT_UPDATETIME.getProfiler()).data.keySet()) {
            sorted.add(new DataBlockTileEntity().fill(coord));
        }
        Collections.sort(sorted);
        for (int i = 0; i < Math.min(amount, sorted.size()); ++i) {
            topEntities.add((DataBlockTileEntity)sorted.get(i));
        }
        return topEntities;
    }

    public DataTiming getTotalUpdateTime() {
        double updateTime = 0.0;
        for (CoordinatesBlock coords : ((ProfilerTileEntityUpdate)ProfilerSection.TILEENT_UPDATETIME.getProfiler()).data.keySet()) {
            updateTime += ((ProfilerTileEntityUpdate)ProfilerSection.TILEENT_UPDATETIME.getProfiler()).data.get(coords).getGeometricMean();
        }
        return new DataTiming(updateTime);
    }

    public int getAmountTileEntities() {
        int amountTileEntities = 0;
        for (WorldServer world : DimensionManager.getWorlds()) {
            amountTileEntities += world.field_147482_g.size();
        }
        return amountTileEntities;
    }

    public ArrayList<DataTileEntity> getOrphans() {
        ArrayList<DataTileEntity> orphans = new ArrayList<DataTileEntity>();
        HashMap<CoordinatesBlock, DataTileEntity> coordHashset = new HashMap<CoordinatesBlock, DataTileEntity>();
        HashSet<Integer> registeredEntities = new HashSet<Integer>();
        for (WorldServer world : DimensionManager.getWorlds()) {
            for (Object o : world.field_147482_g.toArray()) {
                TileEntity tileEntity = (TileEntity)o;
                if (tileEntity == null) continue;
                CoordinatesBlock coord = new CoordinatesBlock(world.field_73011_w.field_76574_g, tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                int hash = System.identityHashCode(tileEntity);
                if (registeredEntities.contains(hash)) continue;
                Block block = world.func_147439_a(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                if (block == Blocks.field_150350_a || block == null || !block.hasTileEntity(0) || world.func_147438_o(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e) == null || world.func_147438_o(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e).getClass() != tileEntity.getClass()) {
                    orphans.add(new DataTileEntity().fill(tileEntity, "Orphan"));
                    registeredEntities.add(hash);
                }
                if (coordHashset.containsKey(coord)) {
                    if (!registeredEntities.contains(hash)) {
                        orphans.add(new DataTileEntity().fill(tileEntity, "Duplicate"));
                    }
                    if (!registeredEntities.contains(((DataTileEntity)coordHashset.get((Object)coord)).hashCode)) {
                        orphans.add((DataTileEntity)coordHashset.get(coord));
                    }
                }
                if (coordHashset.containsKey(coord)) continue;
                coordHashset.put(coord, new DataTileEntity().fill(tileEntity, "Duplicate"));
            }
        }
        modOpis.log.warn(String.format("Found %d potential orphans !", orphans.size()));
        return orphans;
    }

    public ArrayList<AmountHolder> getCumulativeAmountTileEntities() {
        ArrayList<AmountHolder> cumData = new ArrayList<AmountHolder>();
        Integer[] integerArray = DimensionManager.getIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dim = integerArray[i];
            WorldServer world = DimensionManager.getWorld((int)dim);
            if (world == null) continue;
            if (!(world.field_147482_g instanceof MonitoredTileList)) {
                modOpis.log.info("Improper type detected for tile entity list in world " + dim + ". Regenerating tracking list.");
                MonitoredTileList<TileEntity> newList = new MonitoredTileList<TileEntity>();
                for (int i2 = 0; i2 < world.field_147482_g.size(); ++i2) {
                    newList.add((TileEntity)world.field_147482_g.get(i2));
                }
                world.field_147482_g = newList;
            }
            Table<Block, Integer, Integer> count = ((MonitoredTileList)world.field_147482_g).getCount();
            HashBasedTable reducedCount = HashBasedTable.create();
            for (Table.Cell c : count.cellSet()) {
                if ((Integer)c.getValue() <= 0) continue;
                String stackName = ModIdentification.getStackName((Block)c.getRowKey(), (int)((Integer)c.getColumnKey()));
                String modName = ModIdentification.getModStackName((Block)c.getRowKey(), (int)((Integer)c.getColumnKey()));
                try {
                    reducedCount.put((Object)stackName, (Object)modName, (Object)((Integer)reducedCount.get((Object)stackName, (Object)modName) + (Integer)c.getValue()));
                }
                catch (Exception e) {
                    reducedCount.put((Object)stackName, (Object)modName, (Object)((Integer)c.getValue()));
                }
            }
            for (Table.Cell c : reducedCount.cellSet()) {
                cumData.add(new AmountHolder((String)c.getRowKey(), (Integer)c.getValue(), (String)c.getColumnKey()));
            }
        }
        return cumData;
    }

    public ArrayList<DataBlockTileEntityPerClass> getCumulativeTimingTileEntities() {
        HashBasedTable data = HashBasedTable.create();
        for (CoordinatesBlock coord : ((ProfilerTileEntityUpdate)ProfilerSection.TILEENT_UPDATETIME.getProfiler()).data.keySet()) {
            WorldServer world = DimensionManager.getWorld((int)coord.dim);
            int id = Block.func_149682_b((Block)world.func_147439_a(coord.x, coord.y, coord.z));
            int meta = world.func_72805_g(coord.x, coord.y, coord.z);
            if (!data.contains((Object)id, (Object)meta)) {
                data.put((Object)id, (Object)meta, (Object)new DataBlockTileEntityPerClass(id, meta));
            }
            ((DataBlockTileEntityPerClass)data.get((Object)id, (Object)meta)).add(((ProfilerTileEntityUpdate)ProfilerSection.TILEENT_UPDATETIME.getProfiler()).data.get(coord).getGeometricMean());
        }
        return new ArrayList<DataBlockTileEntityPerClass>(data.values());
    }
}

